/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.registration;

import io.quarkus.jsonp.JsonProviderHolder;
import io.quarkus.oidc.common.runtime.AbstractJsonObject;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.List;
import java.util.Map;

public class ClientMetadata
extends AbstractJsonObject {
    public ClientMetadata() {
    }

    public ClientMetadata(String json) {
        super(json);
    }

    public ClientMetadata(JsonObject json) {
        super(json);
    }

    public ClientMetadata(ClientMetadata metadata) {
        super(metadata.getJsonObject());
    }

    public String getClientId() {
        return super.getString("client_id");
    }

    public String getClientSecret() {
        return super.getString("client_secret");
    }

    public String getClientName() {
        return super.getString("client_name");
    }

    public List<String> getRedirectUris() {
        return this.getListOfStrings("redirect_uris");
    }

    public List<String> getPostLogoutUris() {
        return this.getListOfStrings("post_logout_redirect_uris");
    }

    public String getMetadataString() {
        return super.getJsonString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClientMetadata m) {
        return new Builder(m.getJsonObject());
    }

    public static class Builder {
        JsonObjectBuilder builder;
        boolean built = false;

        Builder() {
            this.builder = JsonProviderHolder.jsonProvider().createObjectBuilder();
        }

        Builder(JsonObject json) {
            this.builder = JsonProviderHolder.jsonProvider().createObjectBuilder(json);
        }

        public Builder clientName(String clientName) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.builder.add("client_name", clientName);
            return this;
        }

        public Builder redirectUri(String redirectUri) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.builder.add("redirect_uris", (JsonValue)JsonProviderHolder.jsonProvider().createArrayBuilder().add(redirectUri).build());
            return this;
        }

        public Builder postLogoutUri(String postLogoutUri) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.builder.add("post_logout_redirect_uris", (JsonValue)JsonProviderHolder.jsonProvider().createArrayBuilder().add(postLogoutUri).build());
            return this;
        }

        public Builder extraProps(Map<String, String> extraProps) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.builder.addAll(JsonProviderHolder.jsonProvider().createObjectBuilder(extraProps));
            return this;
        }

        public ClientMetadata build() {
            this.built = true;
            return new ClientMetadata(this.builder.build());
        }
    }
}

