/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.devresource.testcontainers;

import io.quarkus.observability.common.config.ContainerConfig;
import io.quarkus.observability.devresource.Container;
import io.quarkus.observability.devresource.DevResourceLifecycleManager;
import io.quarkus.observability.devresource.testcontainers.TestcontainerContainer;
import java.util.Map;
import org.testcontainers.containers.GenericContainer;

public abstract class ContainerResource<T extends GenericContainer<T>, C extends ContainerConfig>
implements DevResourceLifecycleManager<C> {
    protected T container;
    protected Container<C> wrapper;

    protected Container<C> set(T container) {
        this.container = container;
        this.wrapper = new TestcontainerContainer(container);
        return this.wrapper;
    }

    public Map<String, String> start() {
        if (this.container == null) {
            this.set(this.defaultContainer());
        }
        this.container.start();
        return this.doStart();
    }

    public void stop() {
        if (this.container != null) {
            this.container.stop();
        }
    }

    protected abstract T defaultContainer();

    protected abstract Map<String, String> doStart();
}

