/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.lra.deployment.devservice;

import com.github.dockerjava.api.command.InspectContainerResponse;
import io.quarkus.deployment.builditem.Startable;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.runtime.LaunchMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class LRACoordinatorContainer
extends GenericContainer<LRACoordinatorContainer>
implements Startable {
    private final Integer fixedExposedPort;
    private int exposedPort = -1;

    public LRACoordinatorContainer(DockerImageName imageName, Integer fixedExposedPort, String defaultNetworkId, boolean useSharedNetwork) {
        super(imageName);
        this.fixedExposedPort = fixedExposedPort;
        ConfigureUtil.configureNetwork((GenericContainer)this, (String)defaultNetworkId, (boolean)useSharedNetwork, (String)"lra-coordinator");
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*lra-coordinator-quarkus.*started in.*", (int)1));
    }

    protected void containerIsStarting(InspectContainerResponse inspectContainerResponse, boolean reused) {
        super.containerIsStarting(inspectContainerResponse, reused);
        this.exposedPort = this.getMappedPort(8080);
    }

    public void configure() {
        super.configure();
        this.addExposedPort(8080);
        if (this.fixedExposedPort != null) {
            this.addFixedExposedPort(this.fixedExposedPort, 8080);
        }
    }

    public String getConnectionInfo() {
        return String.format("http://%s:%d/lra-coordinator", this.getHost(), this.getExposedPort());
    }

    public void close() {
        super.close();
    }

    public int getExposedPort() {
        return this.exposedPort;
    }

    public LRACoordinatorContainer withSharedServiceLabel(LaunchMode launchMode, String serviceName) {
        return (LRACoordinatorContainer)ConfigureUtil.configureSharedServiceLabel((GenericContainer)this, (LaunchMode)launchMode, (String)"quarkus-dev-service-lra-coordinator", (String)serviceName);
    }
}

