/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.lra.deployment;

import java.util.HashSet;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Paths;

public class NarayanaLRAOpenAPIFilter
implements OASFilter {
    static final String LRA_PROXY_PATH = "/lraproxy";
    static final String LRA_PARTICIAPANT_PROXY_PATH = "/lra-participant-proxy";
    static final String LRA_STATUS_SCHEMA = "LRAStatus";
    boolean openapiIncluded;

    public NarayanaLRAOpenAPIFilter(boolean openapiIncluded) {
        this.openapiIncluded = openapiIncluded;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        Paths paths = openAPI.getPaths();
        if (!this.openapiIncluded) {
            HashSet<String> lraProxyPaths = new HashSet<String>();
            for (String path : paths.getPathItems().keySet()) {
                if (!path.startsWith(LRA_PROXY_PATH) && !path.startsWith(LRA_PARTICIAPANT_PROXY_PATH)) continue;
                lraProxyPaths.add(path);
            }
            for (String path : lraProxyPaths) {
                paths.removePathItem(path);
            }
            openAPI.getComponents().removeSchema(LRA_STATUS_SCHEMA);
        }
    }
}

