/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.lra.deployment;

import io.narayana.lra.client.internal.proxy.ParticipantProxyResource;
import io.narayana.lra.client.internal.proxy.nonjaxrs.jandex.DotNames;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.narayana.lra.deployment.LRABuildTimeConfiguration;
import io.quarkus.narayana.lra.deployment.NarayanaLRAOpenAPIFilter;
import io.quarkus.narayana.lra.runtime.LRAConfiguration;
import io.quarkus.narayana.lra.runtime.NarayanaLRAProducers;
import io.quarkus.narayana.lra.runtime.NarayanaLRARecorder;
import io.quarkus.smallrye.openapi.deployment.spi.AddToOpenAPIDefinitionBuildItem;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.OASFilter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class NarayanaLRAProcessor {
    private static final DotName PATH = DotName.createSimple((String)"jakarta.ws.rs.Path");

    NarayanaLRAProcessor() {
    }

    @BuildStep
    void registerFeature(BuildProducer<FeatureBuildItem> feature, Capabilities capabilities) {
        boolean isResteasyClassicAvailable = capabilities.isPresent("io.quarkus.resteasy.json.jackson");
        boolean isResteasyReactiveAvailable = capabilities.isPresent("io.quarkus.resteasy.reactive.json.jackson");
        if (!isResteasyClassicAvailable && !isResteasyReactiveAvailable) {
            throw new IllegalStateException("'quarkus-narayana-lra' can only work if 'quarkus-rest-jackson' or 'quarkus-resteasy-jackson' is present");
        }
        if (!capabilities.isCapabilityWithPrefixPresent("io.quarkus.rest.client")) {
            throw new IllegalStateException("'quarkus-narayana-lra' can only work if 'quarkus-rest-client' or 'quarkus-resteasy-client' is present");
        }
        feature.produce((BuildItem)new FeatureBuildItem(Feature.NARAYANA_LRA));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void build(NarayanaLRARecorder recorder, LRAConfiguration configuration) {
        recorder.setConfig(configuration);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void createLRAParticipantRegistry(NarayanaLRARecorder recorder, BeanArchiveIndexBuildItem beanArchiveIndex) {
        ArrayList<String> classNames = new ArrayList<String>();
        IndexView index = beanArchiveIndex.getIndex();
        Collection annotations = index.getAnnotations(PATH);
        for (AnnotationInstance annotation : annotations) {
            short modifiers;
            ClassInfo classInfo;
            AnnotationTarget target = annotation.target();
            if (target.kind().equals((Object)AnnotationTarget.Kind.CLASS)) {
                classInfo = target.asClass();
            } else {
                if (!target.kind().equals((Object)AnnotationTarget.Kind.METHOD)) continue;
                classInfo = target.asMethod().declaringClass();
            }
            if (Modifier.isInterface(modifiers = classInfo.flags()) || Modifier.isAbstract(modifiers) || !this.isLRAParticipant(index, classInfo)) continue;
            classNames.add(classInfo.toString());
        }
        recorder.setParticipantTypes(classNames);
    }

    private boolean isLRAParticipant(IndexView index, ClassInfo classInfo) {
        Map<DotName, List<AnnotationInstance>> annotations = this.getAllAnnotationsFromClassInfoHierarchy(classInfo.name(), index);
        if (!annotations.containsKey(DotNames.LRA)) {
            return false;
        }
        if (!annotations.containsKey(DotNames.COMPENSATE) && !annotations.containsKey(DotNames.AFTER_LRA)) {
            throw new IllegalStateException(String.format("%s: %s", classInfo.name(), "The class contains a method annotated with @LRA and no method annotated with @Compensate or @AfterLRA was found."));
        }
        return true;
    }

    private Map<DotName, List<AnnotationInstance>> getAllAnnotationsFromClassInfoHierarchy(DotName name, IndexView index) {
        HashMap<DotName, List<AnnotationInstance>> annotations = new HashMap<DotName, List<AnnotationInstance>>();
        if (name == null || name.equals((Object)DotNames.OBJECT)) {
            return annotations;
        }
        ClassInfo classInfo = index.getClassByName(name);
        if (classInfo != null) {
            annotations.putAll(classInfo.annotationsMap());
            annotations.putAll(NarayanaLRAProcessor.getInterfaceAnnotations(classInfo.interfaceNames(), index));
            annotations.putAll(this.getAllAnnotationsFromClassInfoHierarchy(classInfo.superName(), index));
        }
        return annotations;
    }

    private static Map<DotName, List<AnnotationInstance>> getInterfaceAnnotations(List<DotName> interfaceNames, IndexView index) {
        HashMap<DotName, List<AnnotationInstance>> annotations = new HashMap<DotName, List<AnnotationInstance>>();
        ClassInfo interfaceClassInfo = null;
        for (DotName interfaceName : interfaceNames) {
            interfaceClassInfo = index.getClassByName(interfaceName);
            Map interfaceAnnotations = interfaceClassInfo.annotationsMap();
            annotations.forEach((k, v) -> interfaceAnnotations.merge(k, v, (v1, v2) -> {
                v1.addAll(v2);
                return v1;
            }));
        }
        return annotations;
    }

    @BuildStep
    void registerBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(ParticipantProxyResource.class).build());
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{NarayanaLRAProducers.class}));
    }

    @BuildStep
    public void filterOpenAPIEndpoint(BuildProducer<AddToOpenAPIDefinitionBuildItem> openAPIProducer, Capabilities capabilities, LRABuildTimeConfiguration lraBuildTimeConfig) {
        if (capabilities.isPresent("io.quarkus.smallrye.openapi")) {
            NarayanaLRAOpenAPIFilter lraOpenAPIFilter = new NarayanaLRAOpenAPIFilter(lraBuildTimeConfig.openapiIncluded());
            openAPIProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem((OASFilter)lraOpenAPIFilter));
        }
    }
}

