/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.rest.data.panache.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.mongodb.rest.data.panache.PanacheMongoEntityResource;
import io.quarkus.mongodb.rest.data.panache.PanacheMongoRepositoryResource;
import io.quarkus.mongodb.rest.data.panache.deployment.EntityClassHelper;
import io.quarkus.mongodb.rest.data.panache.deployment.EntityDataAccessImplementor;
import io.quarkus.mongodb.rest.data.panache.deployment.RepositoryDataAccessImplementor;
import io.quarkus.mongodb.rest.data.panache.deployment.ResourceImplementor;
import io.quarkus.mongodb.rest.data.panache.runtime.NoopUpdateExecutor;
import io.quarkus.mongodb.rest.data.panache.runtime.RestDataPanacheExceptionMapper;
import io.quarkus.rest.data.panache.RestDataPanacheException;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.RestDataResourceBuildItem;
import io.quarkus.rest.data.panache.deployment.utils.EntityTypeUtils;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.reactive.spi.ExceptionMapperBuildItem;
import java.lang.reflect.Modifier;
import java.util.List;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;

class MongoPanacheRestProcessor {
    private static final DotName PANACHE_MONGO_ENTITY_RESOURCE_INTERFACE = DotName.createSimple((String)PanacheMongoEntityResource.class.getName());
    private static final DotName PANACHE_MONGO_REPOSITORY_RESOURCE_INTERFACE = DotName.createSimple((String)PanacheMongoRepositoryResource.class.getName());

    MongoPanacheRestProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.MONGODB_REST_DATA_PANACHE);
    }

    @BuildStep
    void registerRestDataPanacheExceptionMapper(BuildProducer<ResteasyJaxrsProviderBuildItem> resteasyJaxrsProviderBuildItemBuildProducer, BuildProducer<ExceptionMapperBuildItem> exceptionMapperBuildItemBuildProducer) {
        resteasyJaxrsProviderBuildItemBuildProducer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(RestDataPanacheExceptionMapper.class.getName()));
        exceptionMapperBuildItemBuildProducer.produce((BuildItem)new ExceptionMapperBuildItem(RestDataPanacheExceptionMapper.class.getName(), RestDataPanacheException.class.getName(), Integer.valueOf(5100), false));
    }

    @BuildStep
    AdditionalBeanBuildItem registerTransactionalExecutor() {
        return AdditionalBeanBuildItem.unremovableOf(NoopUpdateExecutor.class);
    }

    @BuildStep
    void findEntityResources(CombinedIndexBuildItem index, Capabilities capabilities, BuildProducer<GeneratedBeanBuildItem> implementationsProducer, BuildProducer<RestDataResourceBuildItem> restDataResourceProducer, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformersProducer) {
        EntityClassHelper entityClassHelper = new EntityClassHelper(index.getComputingIndex());
        ResourceImplementor resourceImplementor = new ResourceImplementor(entityClassHelper);
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(implementationsProducer);
        for (ClassInfo resourceInterface : index.getComputingIndex().getKnownDirectImplementors(PANACHE_MONGO_ENTITY_RESOURCE_INTERFACE)) {
            this.validateResource(index.getComputingIndex(), resourceInterface);
            List<Type> generics = this.getGenericTypes(resourceInterface);
            String entityType = generics.get(0).name().toString();
            String idType = generics.get(1).name().toString();
            EntityDataAccessImplementor dataAccessImplementor = new EntityDataAccessImplementor(entityType);
            String resourceClass = resourceImplementor.implement((ClassOutput)classOutput, dataAccessImplementor, resourceInterface, entityType);
            restDataResourceProducer.produce((BuildItem)new RestDataResourceBuildItem(new ResourceMetadata(resourceClass, resourceInterface, entityType, idType, EntityTypeUtils.getEntityFields((IndexView)index.getIndex(), (String)entityType))));
            if (!capabilities.isPresent("io.quarkus.resteasy")) continue;
            bytecodeTransformersProducer.produce((BuildItem)this.getEntityIdAnnotationTransformer(entityType, entityClassHelper.getIdField(entityType).name()));
        }
    }

    @BuildStep
    void findRepositoryResources(CombinedIndexBuildItem index, Capabilities capabilities, BuildProducer<GeneratedBeanBuildItem> implementationsProducer, BuildProducer<RestDataResourceBuildItem> restDataResourceProducer, BuildProducer<UnremovableBeanBuildItem> unremovableBeansProducer, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformersProducer) {
        EntityClassHelper entityClassHelper = new EntityClassHelper(index.getComputingIndex());
        ResourceImplementor resourceImplementor = new ResourceImplementor(entityClassHelper);
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(implementationsProducer);
        for (ClassInfo resourceInterface : index.getComputingIndex().getKnownDirectImplementors(PANACHE_MONGO_REPOSITORY_RESOURCE_INTERFACE)) {
            this.validateResource(index.getComputingIndex(), resourceInterface);
            List<Type> generics = this.getGenericTypes(resourceInterface);
            String repositoryClassName = generics.get(0).name().toString();
            String entityType = generics.get(1).name().toString();
            String idType = generics.get(2).name().toString();
            RepositoryDataAccessImplementor dataAccessImplementor = new RepositoryDataAccessImplementor(repositoryClassName);
            String resourceClass = resourceImplementor.implement((ClassOutput)classOutput, dataAccessImplementor, resourceInterface, entityType);
            unremovableBeansProducer.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNameExclusion(repositoryClassName)));
            restDataResourceProducer.produce((BuildItem)new RestDataResourceBuildItem(new ResourceMetadata(resourceClass, resourceInterface, entityType, idType, EntityTypeUtils.getEntityFields((IndexView)index.getIndex(), (String)entityType))));
            if (!capabilities.isPresent("io.quarkus.resteasy")) continue;
            bytecodeTransformersProducer.produce((BuildItem)this.getEntityIdAnnotationTransformer(entityType, entityClassHelper.getIdField(entityType).name()));
        }
    }

    private void validateResource(IndexView index, ClassInfo classInfo) {
        if (!Modifier.isInterface(classInfo.flags())) {
            throw new RuntimeException(String.valueOf(classInfo.name()) + " has to be an interface");
        }
        if (classInfo.interfaceNames().size() > 1) {
            throw new RuntimeException(String.valueOf(classInfo.name()) + " should only extend REST Data Panache interface");
        }
        if (!index.getKnownDirectImplementors(classInfo.name()).isEmpty()) {
            throw new RuntimeException(String.valueOf(classInfo.name()) + " should not be extended or implemented");
        }
    }

    private List<Type> getGenericTypes(ClassInfo classInfo) {
        return ((Type)classInfo.interfaceTypes().stream().findFirst().orElseThrow(() -> new RuntimeException(classInfo.toString() + " does not have generic types"))).asParameterizedType().arguments();
    }

    private BytecodeTransformerBuildItem getEntityIdAnnotationTransformer(String entityClassName, final String idFieldName) {
        return new BytecodeTransformerBuildItem(entityClassName, (className, classVisitor) -> new ClassVisitor(589824, (ClassVisitor)classVisitor){

            public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                FieldVisitor fieldVisitor = super.visitField(access, name, descriptor, signature, value);
                if (name.equals(idFieldName)) {
                    fieldVisitor.visitAnnotation("Lorg/jboss/resteasy/links/ResourceID;", true).visitEnd();
                }
                return fieldVisitor;
            }
        });
    }
}

