/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.runtime.graal;

import com.mongodb.MongoClientException;
import com.mongodb.ServerAddress;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.internal.connection.BufferProvider;
import com.mongodb.internal.connection.SocketStream;
import com.mongodb.internal.connection.SocketStreamFactory;
import com.mongodb.internal.connection.Stream;
import com.mongodb.spi.dns.InetAddressResolver;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.security.NoSuchAlgorithmException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;

@TargetClass(value=SocketStreamFactory.class)
final class SocketStreamFactorySubstitution {
    @Alias
    private InetAddressResolver inetAddressResolver;
    @Alias
    private SocketSettings settings;
    @Alias
    private SslSettings sslSettings;
    @Alias
    private BufferProvider bufferProvider;

    SocketStreamFactorySubstitution() {
    }

    @Substitute
    public Stream create(ServerAddress serverAddress) {
        SocketStream stream = this.sslSettings.isEnabled() ? new SocketStream(serverAddress, this.inetAddressResolver, this.settings, this.sslSettings, (SocketFactory)this.getSslContext().getSocketFactory(), this.bufferProvider) : new SocketStream(serverAddress, this.inetAddressResolver, this.settings, this.sslSettings, SocketFactory.getDefault(), this.bufferProvider);
        return stream;
    }

    @Alias
    private SSLContext getSslContext() {
        try {
            return this.sslSettings.getContext() == null ? SSLContext.getDefault() : this.sslSettings.getContext();
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoClientException("Unable to create default SSLContext", (Throwable)e);
        }
    }
}

