/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime;

import io.quarkus.runtime.annotations.ConfigDocIgnore;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.util.Map;
import java.util.Optional;

@ConfigRoot(phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
@ConfigMapping(prefix="quarkus.messaging")
public interface ReactiveMessagingConfiguration {
    public static final String CHANNEL_INCOMING_PROPERTY = "mp.messaging.incoming.%s.%s";
    public static final String CHANNEL_OUTGOING_PROPERTY = "mp.messaging.outgoing.%s.%s";

    @ConfigDocIgnore
    public Map<String, Incoming> incoming();

    @ConfigDocIgnore
    public Map<String, Outgoing> outgoing();

    @WithName(value="metrics.enabled")
    @WithDefault(value="false")
    public boolean metricsEnabled();

    @WithDefault(value="false")
    public boolean strict();

    @WithName(value="blocking.signatures.execution.mode")
    @WithDefault(value="worker")
    public ExecutionMode blockingSignaturesExecutionMode();

    public static String getChannelIncomingPropertyName(String channelName, String attribute) {
        return String.format(CHANNEL_INCOMING_PROPERTY, channelName.contains(".") ? "\"" + channelName + "\"" : channelName, attribute);
    }

    public static String getChannelOutgoingPropertyName(String channelName, String attribute) {
        return String.format(CHANNEL_OUTGOING_PROPERTY, channelName.contains(".") ? "\"" + channelName + "\"" : channelName, attribute);
    }

    public static String getChannelPropertyName(String channelName, String attribute, boolean incoming) {
        return incoming ? ReactiveMessagingConfiguration.getChannelIncomingPropertyName(channelName, attribute) : ReactiveMessagingConfiguration.getChannelOutgoingPropertyName(channelName, attribute);
    }

    public static interface Outgoing
    extends ChannelDirection {
    }

    public static interface Incoming
    extends ChannelDirection {
    }

    public static interface ChannelDirection {
        @ConfigDocIgnore
        public Optional<String> connector();

        @ConfigDocIgnore
        @WithDefault(value="true")
        public boolean enabled();
    }

    public static enum ExecutionMode {
        EVENT_LOOP,
        WORKER,
        VIRTUAL_THREAD;

    }
}

