/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import java.util.Set;
import java.util.function.Function;

public class ReactiveMessagingConfigBuilderCustomizer
implements SmallRyeConfigBuilderCustomizer {
    private static final String REACTIVE_MESSAGING_PREFIX = "quarkus.messaging.";
    private static final String MP_MESSAGING_PREFIX = "mp.messaging.";
    private static final String INCOMING = "incoming.";
    private static final String OUTGOING = "outgoing.";
    private static final Set<String> PROPERTIES = Set.of(".connector", ".enabled");

    public void configBuilder(SmallRyeConfigBuilder builder) {
        builder.withInterceptors(new ConfigSourceInterceptor[]{new FallbackConfigSourceInterceptor((Function)new Fallback())});
        builder.withInterceptors(new ConfigSourceInterceptor[]{new RelocateConfigSourceInterceptor((Function)new Relocate())});
    }

    private record Fallback() implements Function<String, String>
    {
        @Override
        public String apply(String name) {
            if (name.startsWith(ReactiveMessagingConfigBuilderCustomizer.REACTIVE_MESSAGING_PREFIX) && (name.regionMatches(18, ReactiveMessagingConfigBuilderCustomizer.INCOMING, 0, 9) || name.regionMatches(18, ReactiveMessagingConfigBuilderCustomizer.OUTGOING, 0, 9))) {
                for (String property : PROPERTIES) {
                    if (!name.endsWith(property)) continue;
                    return "mp" + name.substring(7);
                }
            }
            return name;
        }
    }

    private record Relocate() implements Function<String, String>
    {
        @Override
        public String apply(String name) {
            if (name.startsWith(ReactiveMessagingConfigBuilderCustomizer.MP_MESSAGING_PREFIX) && (name.regionMatches(13, ReactiveMessagingConfigBuilderCustomizer.INCOMING, 0, 9) || name.regionMatches(13, ReactiveMessagingConfigBuilderCustomizer.OUTGOING, 0, 9))) {
                for (String property : PROPERTIES) {
                    if (!name.endsWith(property)) continue;
                    return "quarkus" + name.substring(2);
                }
            }
            return name;
        }
    }
}

