/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.pulsar;

import io.quarkus.pulsar.schema.BufferSchema;
import io.quarkus.pulsar.schema.JsonArraySchema;
import io.quarkus.pulsar.schema.JsonObjectSchema;
import io.quarkus.pulsar.schema.ObjectMapperSchema;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Schema;

@Recorder
public class SchemaProviderRecorder {
    public <T> Supplier<Schema<T>> createJsonSchema(final Class<T> type) {
        return new Supplier<Schema<T>>(){

            @Override
            public Schema<T> get() {
                return Schema.JSON((Class)type);
            }
        };
    }

    public <T> Supplier<Schema<T>> createAvroSchema(final Class<T> type) {
        return new Supplier<Schema<T>>(){

            @Override
            public Schema<T> get() {
                return Schema.AVRO((Class)type);
            }
        };
    }

    public Supplier<Schema<?>> createProtoBufSchema(final Class<?> type) {
        return new Supplier<Schema<?>>(){

            @Override
            public Schema<?> get() {
                return Schema.PROTOBUF((Class)type);
            }
        };
    }

    public <T> RuntimeValue<Schema<T>> createObjectMapperSchema(Class<T> type) {
        return new RuntimeValue(ObjectMapperSchema.of(type));
    }

    public RuntimeValue<Schema<Buffer>> createBufferSchema() {
        return new RuntimeValue((Object)BufferSchema.INSTANCE);
    }

    public RuntimeValue<Schema<JsonObject>> createJsonObjectSchema() {
        return new RuntimeValue((Object)JsonObjectSchema.INSTANCE);
    }

    public RuntimeValue<Schema<JsonArray>> createJsonArraySchema() {
        return new RuntimeValue((Object)JsonArraySchema.INSTANCE);
    }

    public RuntimeValue<Schema<ByteBuffer>> createByteBufferSchema() {
        return new RuntimeValue((Object)Schema.BYTEBUFFER);
    }
}

