/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.pulsar.schema;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.quarkus.pulsar.schema.ObjectMapperProducer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class ObjectMapperSchema<T>
extends AbstractSchema<T> {
    private static final SchemaInfo SCHEMA_INFO = SchemaInfoImpl.builder().name("ObjectMapper").type(SchemaType.NONE).schema(new byte[0]).build();
    private final ObjectMapper objectMapper;
    private final JavaType javaType;
    private final boolean nullAsNull;

    public static <T> ObjectMapperSchema<T> of(Class<T> type) {
        return new ObjectMapperSchema<T>(type);
    }

    public ObjectMapperSchema(Class<T> type) {
        this(type, ObjectMapperProducer.get());
    }

    public ObjectMapperSchema(Class<T> type, boolean nullAsNull) {
        this(type, ObjectMapperProducer.get(), nullAsNull);
    }

    public ObjectMapperSchema(Class<T> type, ObjectMapper objectMapper) {
        this(TypeFactory.defaultInstance().constructType(type), objectMapper, false);
    }

    public ObjectMapperSchema(Class<T> type, ObjectMapper objectMapper, boolean nullAsNull) {
        this(TypeFactory.defaultInstance().constructType(type), objectMapper, nullAsNull);
    }

    public ObjectMapperSchema(TypeReference<T> typeReference, ObjectMapper objectMapper) {
        this(TypeFactory.defaultInstance().constructType(typeReference), objectMapper, false);
    }

    public ObjectMapperSchema(TypeReference<T> typeReference, ObjectMapper objectMapper, boolean nullAsNull) {
        this(TypeFactory.defaultInstance().constructType(typeReference), objectMapper, nullAsNull);
    }

    public ObjectMapperSchema(JavaType javaType, ObjectMapper objectMapper, boolean nullAsNull) {
        this.javaType = javaType;
        this.objectMapper = objectMapper;
        this.nullAsNull = nullAsNull;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T decode(ByteBuf byteBuf) {
        if (byteBuf == null) {
            return null;
        }
        try (ByteBufInputStream is = new ByteBufInputStream(byteBuf);){
            Object object = this.objectMapper.readValue((InputStream)is, this.javaType);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encode(T message) {
        byte[] byArray;
        if (this.nullAsNull && message == null) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.objectMapper.writeValue((OutputStream)output, message);
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        output.close();
        return byArray;
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }
}

