/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.pulsar;

import com.google.common.base.CaseFormat;
import io.quarkus.arc.DefaultBean;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.config.Config;

@Singleton
public class PulsarRuntimeConfigProducer {
    @Produces
    @DefaultBean
    @Singleton
    @Identifier(value="default-pulsar-client")
    public Map<String, Object> createPulsarClientRuntimeConfig(Config config) {
        return PulsarRuntimeConfigProducer.getMapFromConfig(config, "pulsar.client");
    }

    @Produces
    @DefaultBean
    @Singleton
    @Identifier(value="default-pulsar-consumer")
    public Map<String, Object> createPulsarConsumerRuntimeConfig(Config config) {
        return PulsarRuntimeConfigProducer.getMapFromConfig(config, "pulsar.consumer");
    }

    @Produces
    @DefaultBean
    @Singleton
    @Identifier(value="default-pulsar-producer")
    public Map<String, Object> createPulsarProducerRuntimeConfig(Config config) {
        return PulsarRuntimeConfigProducer.getMapFromConfig(config, "pulsar.producer");
    }

    @Produces
    @DefaultBean
    @Singleton
    @Identifier(value="default-pulsar-admin")
    public Map<String, Object> createPulsarAdminRuntimeConfig(Config config) {
        return PulsarRuntimeConfigProducer.getMapFromConfig(config, "pulsar.admin");
    }

    public static Map<String, Object> getMapFromConfig(Config config, String prefix) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String upperCasePrefix = prefix.toUpperCase().replaceAll("\\.", "_");
        for (String originalKey : config.getPropertyNames()) {
            if (!originalKey.startsWith(prefix) && !originalKey.startsWith(upperCasePrefix)) continue;
            String effectivePropertyName = originalKey.substring(prefix.length() + 1);
            if (originalKey.contains("_") || PulsarRuntimeConfigProducer.allCaps(originalKey)) {
                effectivePropertyName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, effectivePropertyName);
            }
            String value = config.getOptionalValue(originalKey, String.class).orElse("");
            result.put(effectivePropertyName, value);
        }
        return result;
    }

    public static boolean allCaps(String key) {
        return key.toUpperCase().equals(key);
    }
}

