/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.pulsar.schema;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class JsonArraySchema
extends AbstractSchema<JsonArray> {
    public static final JsonArraySchema INSTANCE = new JsonArraySchema();
    private static final SchemaInfo SCHEMA_INFO = SchemaInfoImpl.builder().name("JsonArray").type(SchemaType.NONE).schema(new byte[0]).build();

    public JsonArray decode(ByteBuf byteBuf) {
        if (byteBuf == null) {
            return null;
        }
        return Buffer.buffer((ByteBuf)byteBuf).toJsonArray();
    }

    public byte[] encode(JsonArray message) {
        if (message == null) {
            return null;
        }
        return message.encode().getBytes();
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }
}

