/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.pulsar;

import io.quarkus.tls.TlsConfiguration;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.KeyStoreOptionsBase;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.PulsarClientException;

public class QuarkusPulsarKeyStoreAuthentication
implements Authentication {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private final TlsConfiguration configuration;

    public QuarkusPulsarKeyStoreAuthentication(TlsConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAuthMethodName() {
        return "quarkus-pulsar";
    }

    public void configure(Map<String, String> authParams) {
    }

    public void start() throws PulsarClientException {
    }

    public void close() throws IOException {
    }

    public AuthenticationDataProvider getAuthData() throws PulsarClientException {
        try {
            String keyStorePwd = ((KeyStoreOptionsBase)this.configuration.getKeyStoreOptions()).getPassword();
            KeyStore keyStore = this.configuration.getKeyStore();
            String alias = keyStore.aliases().nextElement();
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
            Certificate[] certificates = (X509Certificate[])Stream.of(cert).toArray(X509Certificate[]::new);
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(keyStorePwd.toCharArray()));
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            KeyStore trustStore = this.configuration.getTrustStore();
            String trustAlias = trustStore.aliases().nextElement();
            Certificate trustStoreCertificate = trustStore.getCertificate(trustAlias);
            Buffer formatCrtFileContents = QuarkusPulsarKeyStoreAuthentication.formatCrtFileContents(trustStoreCertificate);
            return new QuarkusPulsarAuthenticationData(certificates, privateKey, formatCrtFileContents);
        }
        catch (Exception e) {
            throw new PulsarClientException((Throwable)e);
        }
    }

    public static Buffer formatCrtFileContents(Certificate certificate) throws CertificateEncodingException {
        Buffer buffer = Buffer.buffer();
        Base64.Encoder encoder = Base64.getMimeEncoder(64, LINE_SEPARATOR.getBytes());
        buffer.appendString(BEGIN_CERT).appendString(LINE_SEPARATOR).appendBytes(encoder.encode(certificate.getEncoded())).appendString(LINE_SEPARATOR).appendString(END_CERT);
        return buffer;
    }

    private static class QuarkusPulsarAuthenticationData
    implements AuthenticationDataProvider {
        private final Certificate[] certs;
        private final PrivateKey privateKey;
        private final InputStream trustStoreStream;

        public QuarkusPulsarAuthenticationData(Certificate[] certs, PrivateKey privateKey, Buffer trustStore) {
            this.certs = certs;
            this.privateKey = privateKey;
            this.trustStoreStream = new ByteArrayInputStream(trustStore.getBytes());
        }

        public boolean hasDataForTls() {
            return true;
        }

        public Certificate[] getTlsCertificates() {
            return this.certs;
        }

        public PrivateKey getTlsPrivateKey() {
            return this.privateKey;
        }

        public InputStream getTlsTrustStoreStream() {
            return this.trustStoreStream;
        }
    }
}

