/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.KotlinUtils;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.QuarkusMediatorConfigurationUtil;
import io.quarkus.smallrye.reactivemessaging.deployment.ReactiveMessagingBuildTimeConfig;
import io.quarkus.smallrye.reactivemessaging.deployment.ReactiveMessagingDotNames;
import io.quarkus.smallrye.reactivemessaging.deployment.items.ChannelDirection;
import io.quarkus.smallrye.reactivemessaging.deployment.items.ConnectorManagedChannelBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.items.InjectedChannelBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.items.InjectedEmitterBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.items.MediatorBuildItem;
import io.quarkus.smallrye.reactivemessaging.runtime.ConnectorContextPropagationDecorator;
import io.quarkus.smallrye.reactivemessaging.runtime.ContextualEmitterFactory;
import io.quarkus.smallrye.reactivemessaging.runtime.DuplicatedContextConnectorFactory;
import io.quarkus.smallrye.reactivemessaging.runtime.DuplicatedContextConnectorFactoryInterceptor;
import io.quarkus.smallrye.reactivemessaging.runtime.HealthCenterFilter;
import io.quarkus.smallrye.reactivemessaging.runtime.HealthCenterInterceptor;
import io.quarkus.smallrye.reactivemessaging.runtime.QuarkusMediatorConfiguration;
import io.quarkus.smallrye.reactivemessaging.runtime.QuarkusWorkerPoolRegistry;
import io.quarkus.smallrye.reactivemessaging.runtime.ReactiveMessagingConfiguration;
import io.quarkus.smallrye.reactivemessaging.runtime.RequestScopedDecorator;
import io.quarkus.smallrye.reactivemessaging.runtime.SmallRyeReactiveMessagingLifecycle;
import io.quarkus.smallrye.reactivemessaging.runtime.SmallRyeReactiveMessagingRecorder;
import io.quarkus.smallrye.reactivemessaging.runtime.WorkerConfiguration;
import io.quarkus.smallrye.reactivemessaging.runtime.devmode.DevModeSupportConnectorFactory;
import io.quarkus.smallrye.reactivemessaging.runtime.devmode.DevModeSupportConnectorFactoryInterceptor;
import io.smallrye.reactive.messaging.EmitterConfiguration;
import io.smallrye.reactive.messaging.Invoker;
import io.smallrye.reactive.messaging.extension.health.SmallRyeReactiveMessagingLivenessCheck;
import io.smallrye.reactive.messaging.extension.health.SmallRyeReactiveMessagingReadinessCheck;
import io.smallrye.reactive.messaging.extension.health.SmallRyeReactiveMessagingStartupCheck;
import io.smallrye.reactive.messaging.providers.extension.ChannelConfiguration;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Vetoed;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SmallRyeReactiveMessagingProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)"io.quarkus.smallrye-reactive-messaging.deployment.processor");
    static final String DEFAULT_VIRTUAL_THREADS_MAX_CONCURRENCY = "1024";
    static final String INVOKER_SUFFIX = "_SmallRyeMessagingInvoker";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.MESSAGING);
    }

    @BuildStep
    void beans(BuildProducer<AdditionalBeanBuildItem> additionalBean, ReactiveMessagingBuildTimeConfig buildTimeConfig) {
        additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{SmallRyeReactiveMessagingLifecycle.class, Connector.class, Channel.class, io.smallrye.reactive.messaging.annotations.Channel.class, QuarkusWorkerPoolRegistry.class, ConnectorContextPropagationDecorator.class, ContextualEmitterFactory.class}));
        if (buildTimeConfig.activateRequestScopeEnabled()) {
            additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{RequestScopedDecorator.class}));
        }
    }

    @BuildStep
    AnnotationsTransformerBuildItem transformBeanScope(BeanArchiveIndexBuildItem index, final CustomScopeAnnotationsBuildItem scopes) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public int priority() {
                return 500;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                if (ctx.isClass()) {
                    ClassInfo clazz = ctx.getTarget().asClass();
                    Map annotations = clazz.annotationsMap();
                    if (scopes.isScopeIn(ctx.getAnnotations()) || annotations.containsKey(ReactiveMessagingDotNames.JAXRS_PATH) || annotations.containsKey(ReactiveMessagingDotNames.REST_CONTROLLER) || annotations.containsKey(ReactiveMessagingDotNames.JAXRS_PROVIDER)) {
                        return;
                    }
                    if (annotations.containsKey(ReactiveMessagingDotNames.INCOMING) || annotations.containsKey(ReactiveMessagingDotNames.OUTGOING) || annotations.containsKey(ReactiveMessagingDotNames.CHANNEL)) {
                        LOGGER.debugf("Found reactive messaging annotations on a class %s with no scope defined - adding @Dependent", (Object)ctx.getTarget());
                        ctx.transform().add(Dependent.class, new AnnotationValue[0]).done();
                    }
                }
            }
        });
    }

    @BuildStep
    public List<UnremovableBeanBuildItem> removalExclusions() {
        return Arrays.asList(new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(ReactiveMessagingDotNames.INCOMING)), new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(ReactiveMessagingDotNames.INCOMINGS)), new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(ReactiveMessagingDotNames.OUTGOING)), new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(ReactiveMessagingDotNames.OUTGOINGS)), new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(ReactiveMessagingDotNames.MESSAGE_CONVERTER)), new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(ReactiveMessagingDotNames.KEY_VALUE_EXTRACTOR)));
    }

    @BuildStep
    public AnnotationsTransformerBuildItem enableMetrics(Optional<MetricsCapabilityBuildItem> metricsCapability, ReactiveMessagingConfiguration configuration) {
        final boolean isMetricEnabled = metricsCapability.isPresent() && configuration.metricsEnabled();
        final boolean useMicrometer = isMetricEnabled && metricsCapability.get().metricsSupported("micrometer");
        LOGGER.debug((Object)("Metrics Enabled: " + isMetricEnabled + "; Using Micrometer: " + useMicrometer));
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                if (!(!ctx.getTarget().asClass().name().equals((Object)ReactiveMessagingDotNames.MICROMETER_DECORATOR) || isMetricEnabled && useMicrometer)) {
                    ctx.transform().removeAll().add(Vetoed.class, new AnnotationValue[0]).done();
                }
                if (ctx.getTarget().asClass().name().equals((Object)ReactiveMessagingDotNames.METRIC_DECORATOR) && (!isMetricEnabled || useMicrometer)) {
                    ctx.transform().removeAll().add(Vetoed.class, new AnnotationValue[0]).done();
                }
            }
        });
    }

    @BuildStep
    public void disableObservation(BuildProducer<RunTimeConfigurationDefaultBuildItem> runtimeConfigProducer) {
        runtimeConfigProducer.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("smallrye.messaging.observation.enabled", "false"));
    }

    @BuildStep
    public void enableHealth(ReactiveMessagingBuildTimeConfig buildTimeConfig, BuildProducer<HealthBuildItem> producer, BuildProducer<AdditionalBeanBuildItem> beans, BuildProducer<AnnotationsTransformerBuildItem> transformations) {
        producer.produce((BuildItem)new HealthBuildItem(SmallRyeReactiveMessagingLivenessCheck.class.getName(), buildTimeConfig.healthEnabled()));
        producer.produce((BuildItem)new HealthBuildItem(SmallRyeReactiveMessagingReadinessCheck.class.getName(), buildTimeConfig.healthEnabled()));
        producer.produce((BuildItem)new HealthBuildItem(SmallRyeReactiveMessagingStartupCheck.class.getName(), buildTimeConfig.healthEnabled()));
        if (buildTimeConfig.healthEnabled()) {
            beans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{HealthCenterFilter.class, HealthCenterInterceptor.class}));
            transformations.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

                public boolean appliesTo(AnnotationTarget.Kind kind) {
                    return kind == AnnotationTarget.Kind.CLASS;
                }

                public void transform(AnnotationsTransformer.TransformationContext ctx) {
                    ClassInfo clazz = ctx.getTarget().asClass();
                    if (clazz.name().equals((Object)ReactiveMessagingDotNames.HEALTH_CENTER)) {
                        ctx.transform().add(HealthCenterFilter.class, new AnnotationValue[0]).done();
                    }
                }
            }));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(SmallRyeReactiveMessagingRecorder recorder, RecorderContext recorderContext, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, List<MediatorBuildItem> mediatorMethods, List<ConnectorManagedChannelBuildItem> connectorManagedChannels, List<InjectedEmitterBuildItem> emitterFields, List<InjectedChannelBuildItem> channelFields, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<RunTimeConfigurationDefaultBuildItem> defaultConfig, ReactiveMessagingConfiguration conf) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        Set<String> connectorManagedIncomingChannels = connectorManagedChannels.stream().filter(c -> c.getDirection() == ChannelDirection.INCOMING).map(ConnectorManagedChannelBuildItem::getName).collect(Collectors.toSet());
        ArrayList<QuarkusMediatorConfiguration> mediatorConfigurations = new ArrayList<QuarkusMediatorConfiguration>(mediatorMethods.size());
        ArrayList<WorkerConfiguration> workerConfigurations = new ArrayList<WorkerConfiguration>();
        HashMap<String, EmitterConfiguration> emittersConfigurations = new HashMap<String, EmitterConfiguration>();
        ArrayList<ChannelConfiguration> channelConfigurations = new ArrayList<ChannelConfiguration>();
        for (MediatorBuildItem mediatorBuildItem : mediatorMethods) {
            MethodInfo methodInfo = mediatorBuildItem.getMethod();
            BeanInfo bean = mediatorBuildItem.getBean();
            if (QuarkusMediatorConfigurationUtil.hasBlockingAnnotation(methodInfo)) {
                String poolName;
                String string = poolName = methodInfo.hasAnnotation(ReactiveMessagingDotNames.RUN_ON_VIRTUAL_THREAD) ? "<virtual-thread>" : "<no-value>";
                if (methodInfo.hasAnnotation(ReactiveMessagingDotNames.BLOCKING)) {
                    AnnotationInstance blocking = methodInfo.annotation(ReactiveMessagingDotNames.BLOCKING);
                    String string2 = poolName = blocking.value() == null ? "<no-value>" : blocking.value().asString();
                }
                if (methodInfo.hasAnnotation(ReactiveMessagingDotNames.RUN_ON_VIRTUAL_THREAD)) {
                    defaultConfig.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("smallrye.messaging.worker." + poolName + ".max-concurrency", DEFAULT_VIRTUAL_THREADS_MAX_CONCURRENCY));
                }
                workerConfigurations.add(new WorkerConfiguration(methodInfo.declaringClass().toString(), methodInfo.name(), poolName, methodInfo.hasAnnotation(ReactiveMessagingDotNames.RUN_ON_VIRTUAL_THREAD)));
            }
            try {
                boolean isSuspendMethod = KotlinUtils.isKotlinSuspendMethod((MethodInfo)methodInfo);
                QuarkusMediatorConfiguration mediatorConfiguration = QuarkusMediatorConfigurationUtil.create(methodInfo, isSuspendMethod, bean, recorderContext, Thread.currentThread().getContextClassLoader(), conf.strict(), this.consumesFromConnector(methodInfo, connectorManagedIncomingChannels) ? conf.blockingSignaturesExecutionMode() : ReactiveMessagingConfiguration.ExecutionMode.EVENT_LOOP);
                mediatorConfigurations.add(mediatorConfiguration);
                String generatedInvokerName = this.generateInvoker(bean, methodInfo, isSuspendMethod, mediatorConfiguration, (ClassOutput)classOutput);
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{generatedInvokerName}).build());
                mediatorConfiguration.setInvokerClass(recorderContext.classProxy(generatedInvokerName));
            }
            catch (IllegalArgumentException e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        for (InjectedEmitterBuildItem injectedEmitterBuildItem : emitterFields) {
            EmitterConfiguration configuration = injectedEmitterBuildItem.getEmitterConfig();
            String channel = configuration.name();
            EmitterConfiguration previousConfig = (EmitterConfiguration)emittersConfigurations.get(channel);
            if (previousConfig != null && !previousConfig.equals((Object)configuration)) {
                throw new DeploymentException(String.format("Emitter configuration for channel `%s` is different than previous configuration : %s", channel, injectedEmitterBuildItem.getEmitterConfig()));
            }
            emittersConfigurations.put(channel, configuration);
        }
        for (InjectedChannelBuildItem injectedChannelBuildItem : channelFields) {
            channelConfigurations.add(injectedChannelBuildItem.getChannelConfig());
        }
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(SmallRyeReactiveMessagingRecorder.SmallRyeReactiveMessagingContext.class).supplier(recorder.createContext(mediatorConfigurations, workerConfigurations, new ArrayList(emittersConfigurations.values()), channelConfigurations)).done());
    }

    private String generateInvoker(BeanInfo bean, MethodInfo method, boolean isSuspendMethod, QuarkusMediatorConfiguration mediatorConfiguration, ClassOutput classOutput) {
        Object baseName = bean.getImplClazz().enclosingClass() != null ? DotNames.simpleName((DotName)bean.getImplClazz().enclosingClass()) + "_" + DotNames.simpleName((DotName)bean.getImplClazz().name()) : DotNames.simpleName((DotName)bean.getImplClazz().name());
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(method.name()).append("_").append(method.returnType().name().toString());
        for (Type i : method.parameterTypes()) {
            sigBuilder.append(i.name().toString());
        }
        String targetPackage = DotNames.internalPackageNameWithTrailingSlash((DotName)bean.getImplClazz().name());
        String generatedName = targetPackage + (String)baseName + "_SmallRyeMessagingInvoker_" + method.name() + "_" + HashUtil.sha1((String)sigBuilder.toString());
        if (isSuspendMethod && mediatorConfiguration.getIncoming().isEmpty() && mediatorConfiguration.getOutgoing() != null) {
            throw new IllegalStateException("Currently suspend methods for Reactive Messaging are not supported on methods that are only annotated with @Outgoing");
        }
        if (!isSuspendMethod) {
            this.generateStandardInvoker(method, classOutput, generatedName);
        } else if (!mediatorConfiguration.getIncoming().isEmpty()) {
            this.generateSubscribingCoroutineInvoker(method, classOutput, generatedName);
        }
        return generatedName.replace('/', '.');
    }

    private void generateStandardInvoker(MethodInfo method, ClassOutput classOutput, String generatedName) {
        try (ClassCreator invoker = ClassCreator.builder().classOutput(classOutput).className(generatedName).interfaces(new Class[]{Invoker.class}).build();){
            String beanInstanceType = method.declaringClass().name().toString();
            FieldDescriptor beanInstanceField = invoker.getFieldCreator("beanInstance", beanInstanceType).getFieldDescriptor();
            try (MethodCreator ctor = invoker.getMethodCreator("<init>", Void.TYPE, new Class[]{Object.class});){
                ctor.setModifiers(1);
                ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), ctor.getThis(), new ResultHandle[0]);
                ResultHandle self = ctor.getThis();
                ResultHandle beanInstance = ctor.getMethodParam(0);
                ctor.writeInstanceField(beanInstanceField, self, beanInstance);
                ctor.returnValue(null);
            }
            try (MethodCreator invoke = invoker.getMethodCreator(MethodDescriptor.ofMethod((Object)generatedName, (String)"invoke", Object.class, (Object[])new Object[]{Object[].class}));){
                int parametersCount = method.parametersCount();
                String[] argTypes = new String[parametersCount];
                ResultHandle[] args = new ResultHandle[parametersCount];
                for (int i = 0; i < parametersCount; ++i) {
                    args[i] = invoke.readArrayValue(invoke.getMethodParam(0), i);
                    argTypes[i] = method.parameterType(i).name().toString();
                }
                ResultHandle result = invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((String)beanInstanceType, (String)method.name(), (String)method.returnType().name().toString(), (String[])argTypes), invoke.readInstanceField(beanInstanceField, invoke.getThis()), args);
                if (ReactiveMessagingDotNames.VOID.equals((Object)method.returnType().name())) {
                    invoke.returnValue(invoke.loadNull());
                } else {
                    invoke.returnValue(result);
                }
            }
        }
    }

    private void generateSubscribingCoroutineInvoker(MethodInfo method, ClassOutput classOutput, String generatedName) {
        try (ClassCreator invoker = ClassCreator.builder().classOutput(classOutput).className(generatedName).superClass(ReactiveMessagingDotNames.ABSTRACT_SUBSCRIBING_COROUTINE_INVOKER.toString()).build();){
            try (MethodCreator ctor = invoker.getMethodCreator("<init>", Void.TYPE, new Class[]{Object.class});){
                ctor.setModifiers(1);
                ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)ReactiveMessagingDotNames.ABSTRACT_SUBSCRIBING_COROUTINE_INVOKER.toString(), (String[])new String[]{Object.class.getName()}), ctor.getThis(), new ResultHandle[]{ctor.getMethodParam(0)});
                ctor.returnValue(null);
            }
            try (MethodCreator invoke = invoker.getMethodCreator("invokeBean", Object.class, new Object[]{Object.class, Object[].class, ReactiveMessagingDotNames.CONTINUATION.toString()});){
                ResultHandle[] args = new ResultHandle[method.parametersCount()];
                ResultHandle array = invoke.getMethodParam(1);
                for (int i = 0; i < method.parametersCount() - 1; ++i) {
                    args[i] = invoke.readArrayValue(array, i);
                }
                args[args.length - 1] = invoke.getMethodParam(2);
                ResultHandle result = invoke.invokeVirtualMethod(method, invoke.getMethodParam(0), args);
                invoke.returnValue(result);
            }
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void devmodeSupport(final CombinedIndexBuildItem index, BuildProducer<AdditionalBeanBuildItem> beans, BuildProducer<AnnotationsTransformerBuildItem> transformations) {
        beans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{DevModeSupportConnectorFactory.class, DevModeSupportConnectorFactoryInterceptor.class}));
        transformations.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                ClassInfo clazz = ctx.getTarget().asClass();
                if (this.doesImplement(clazz, ReactiveMessagingDotNames.INCOMING_CONNECTOR_FACTORY, index.getIndex()) || this.doesImplement(clazz, ReactiveMessagingDotNames.INBOUND_CONNECTOR, index.getIndex()) || this.doesImplement(clazz, ReactiveMessagingDotNames.OUTGOING_CONNECTOR_FACTORY, index.getIndex()) || this.doesImplement(clazz, ReactiveMessagingDotNames.OUTBOUND_CONNECTOR, index.getIndex())) {
                    ctx.transform().add(DevModeSupportConnectorFactory.class, new AnnotationValue[0]).done();
                }
            }

            private boolean doesImplement(ClassInfo clazz, DotName iface, IndexView index2) {
                while (clazz != null && !clazz.name().equals((Object)ReactiveMessagingDotNames.OBJECT)) {
                    if (clazz.interfaceNames().contains(iface)) {
                        return true;
                    }
                    clazz = index2.getClassByName(clazz.superName());
                }
                return false;
            }
        }));
    }

    @BuildStep
    CoroutineConfigurationBuildItem producesCoroutineConfiguration() {
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"kotlinx.coroutines.future.FutureKt")) {
            return new CoroutineConfigurationBuildItem(true);
        }
        return new CoroutineConfigurationBuildItem(false);
    }

    @BuildStep
    void produceCoroutineScope(CoroutineConfigurationBuildItem coroutineConfigurationBuildItem, BuildProducer<AdditionalBeanBuildItem> buildItemBuildProducer) {
        if (coroutineConfigurationBuildItem.isEnabled()) {
            buildItemBuildProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new String[]{"io.quarkus.smallrye.reactivemessaging.runtime.kotlin.ApplicationCoroutineScope"}).setUnremovable().build());
        }
    }

    private void ensureKotlinCoroutinesEnabled(CoroutineConfigurationBuildItem coroutineConfigurationBuildItem, MethodInfo method) {
        if (!coroutineConfigurationBuildItem.isEnabled()) {
            String format = String.format("Method %s.%s is suspendable but kotlinx-coroutines-jdk8 dependency not detected", method.declaringClass().name(), method.name());
            throw new IllegalStateException(format);
        }
    }

    @BuildStep
    void duplicatedContextSupport(final CombinedIndexBuildItem index, BuildProducer<AdditionalBeanBuildItem> beans, BuildProducer<AnnotationsTransformerBuildItem> transformations) {
        beans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{DuplicatedContextConnectorFactory.class, DuplicatedContextConnectorFactoryInterceptor.class}));
        transformations.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                ClassInfo clazz = ctx.getTarget().asClass();
                if (this.doesImplement(clazz, ReactiveMessagingDotNames.INCOMING_CONNECTOR_FACTORY, index.getIndex()) || this.doesImplement(clazz, ReactiveMessagingDotNames.INBOUND_CONNECTOR, index.getIndex())) {
                    ctx.transform().add(DuplicatedContextConnectorFactory.class, new AnnotationValue[0]).done();
                }
            }

            private boolean doesImplement(ClassInfo clazz, DotName iface, IndexView index2) {
                while (clazz != null && !clazz.name().equals((Object)ReactiveMessagingDotNames.OBJECT)) {
                    if (clazz.interfaceNames().contains(iface)) {
                        return true;
                    }
                    clazz = index2.getClassByName(clazz.superName());
                }
                return false;
            }
        }));
    }

    boolean consumesFromConnector(MethodInfo methodInfo, Set<String> connectorManagedChannels) {
        AnnotationInstance incoming = methodInfo.annotation(ReactiveMessagingDotNames.INCOMING);
        if (incoming != null) {
            return connectorManagedChannels.contains(incoming.value().asString());
        }
        AnnotationInstance incomings = methodInfo.annotation(ReactiveMessagingDotNames.INCOMINGS);
        if (incomings != null) {
            return connectorManagedChannels.containsAll(Arrays.stream(incomings.value().asNestedArray()).map(i -> i.value().asString()).collect(Collectors.toSet()));
        }
        return false;
    }

    public static final class CoroutineConfigurationBuildItem
    extends SimpleBuildItem {
        private final boolean isEnabled;

        public CoroutineConfigurationBuildItem(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }
    }
}

