/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.EffectiveModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.cyclonedx.generator.CycloneDxSbomGenerator;
import io.quarkus.maven.components.QuarkusWorkspaceProvider;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.sbom.ApplicationManifest;
import io.quarkus.sbom.ApplicationManifestConfig;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="dependency-sbom", defaultPhase=LifecyclePhase.NONE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class DependencySbomMojo
extends AbstractMojo {
    @Component
    QuarkusWorkspaceProvider workspaceProvider;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repos;
    @Parameter(defaultValue="false", property="quarkus.dependency.sbom.skip")
    boolean skip = false;
    @Parameter(property="quarkus.dependency.sbom.mode", defaultValue="prod")
    String mode;
    @Parameter(property="quarkus.dependency.sbom.format", defaultValue="json")
    String format;
    @Parameter(property="quarkus.dependency.sbom.output-file")
    File outputFile;
    @Parameter(property="quarkus.dependency.sbom.include-license-text", defaultValue="false")
    boolean includeLicenseText;
    @Parameter(property="quarkus.dependency.sbom.schema-version")
    String schemaVersion;
    @Parameter(property="quarkus.dependency.sbom.runtime-only")
    boolean runtimeOnly;
    protected MavenArtifactResolver resolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping config dump");
            return;
        }
        Path outputFilePath = this.getSbomFile().toPath();
        CycloneDxSbomGenerator.newInstance().setManifest(ApplicationManifest.fromConfig((ApplicationManifestConfig)ApplicationManifestConfig.builder().setApplicationModel(this.resolveApplicationModel()).build())).setOutputFile(outputFilePath).setFormat(this.format).setEffectiveModelResolver(EffectiveModelResolver.of((MavenArtifactResolver)this.getResolver())).setSchemaVersion(this.schemaVersion).setIncludeLicenseText(this.includeLicenseText).generate();
        this.getLog().info((CharSequence)("The SBOM has been saved in " + String.valueOf(outputFilePath)));
    }

    private ApplicationModel resolveApplicationModel() throws MojoExecutionException {
        ArtifactCoords appArtifact = ArtifactCoords.pom((String)this.project.getGroupId(), (String)this.project.getArtifactId(), (String)this.project.getVersion());
        try {
            BootstrapAppModelResolver modelResolver = new BootstrapAppModelResolver(this.getResolver()).setRuntimeModelOnly(this.runtimeOnly);
            if (this.mode != null) {
                if (this.mode.equalsIgnoreCase("test")) {
                    modelResolver.setTest(true);
                } else if (this.mode.equalsIgnoreCase("dev") || this.mode.equalsIgnoreCase("development")) {
                    modelResolver.setDevMode(true);
                } else if (!this.mode.equalsIgnoreCase("prod") && !this.mode.isEmpty()) {
                    throw new MojoExecutionException("Parameter 'mode' was set to '" + this.mode + "' while expected one of 'dev', 'test' or 'prod'");
                }
            }
            modelResolver.setLegacyModelResolver(BootstrapAppModelResolver.isLegacyModelResolver((Properties)this.project.getProperties()));
            return modelResolver.resolveModel(appArtifact);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve application model " + String.valueOf(appArtifact) + " dependencies", e);
        }
    }

    private String getSbomFilename() {
        Artifact a = this.project.getArtifact();
        StringBuilder sb = new StringBuilder().append(a.getArtifactId()).append("-").append(a.getVersion()).append("-");
        if (!"prod".equalsIgnoreCase(this.mode)) {
            sb.append(this.mode).append("-");
        }
        return sb.append("dependency-cyclonedx").append(".").append(this.format).toString();
    }

    private File getSbomFile() {
        File f = this.outputFile;
        if (f == null) {
            f = new File(this.project.getBuild().getDirectory(), this.getSbomFilename());
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("SBOM will be stored in " + String.valueOf(f)));
        }
        return f;
    }

    protected MavenArtifactResolver getResolver() {
        if (this.resolver == null) {
            this.resolver = this.workspaceProvider.createArtifactResolver(BootstrapMavenContext.config().setUserSettings(this.session.getRequest().getUserSettingsFile()).setRemoteRepositories(this.repos).setPreferPomsFromWorkspace(true));
        }
        return this.resolver;
    }
}

