/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.deployment.cmd.RunCommandActionResultBuildItem;
import io.quarkus.deployment.cmd.StartDevServicesAndRunCommandHandler;
import io.quarkus.maven.QuarkusBootstrapMojo;
import io.quarkus.runtime.LaunchMode;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="run")
public class RunMojo
extends QuarkusBootstrapMojo {
    @Parameter
    Map<String, String> systemProperties = Collections.emptyMap();

    @Override
    protected boolean beforeExecute() throws MojoExecutionException, MojoFailureException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        HashSet<String> propertiesToClear = new HashSet<String>();
        for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
            String key;
            if (entry.getValue() == null || System.getProperty(key = entry.getKey()) != null) continue;
            System.setProperty(key, entry.getValue());
            propertiesToClear.add(key);
        }
        try (CuratedApplication curatedApplication = this.bootstrapApplication(LaunchMode.NORMAL, new Consumer<QuarkusBootstrap.Builder>(){

            @Override
            public void accept(QuarkusBootstrap.Builder builder) {
                builder.setMode(QuarkusBootstrap.Mode.TEST);
            }
        });){
            AugmentAction action = curatedApplication.createAugmentor();
            final AtomicReference exists = new AtomicReference();
            final AtomicReference tooMany = new AtomicReference();
            final String target = System.getProperty("quarkus.run.target");
            action.performCustomBuild(StartDevServicesAndRunCommandHandler.class.getName(), (Object)new Consumer<Map<String, List>>(){

                @Override
                public void accept(Map<String, List> cmds) {
                    List cmd = null;
                    if (target != null) {
                        cmd = cmds.get(target);
                        if (cmd == null) {
                            exists.set(false);
                            return;
                        }
                    } else if (cmds.size() == 1) {
                        cmd = cmds.values().iterator().next();
                    } else if (cmds.size() == 2) {
                        for (Map.Entry<String, List> entry : cmds.entrySet()) {
                            if (entry.getKey().equals("java")) continue;
                            cmd = entry.getValue();
                            break;
                        }
                    } else {
                        if (cmds.size() > 2) {
                            tooMany.set(cmds.keySet().stream().collect(Collectors.joining(" ")));
                            return;
                        }
                        throw new RuntimeException("Should never reach this!");
                    }
                    List args = (List)cmd.get(0);
                    if (RunMojo.this.getLog().isInfoEnabled()) {
                        RunMojo.this.getLog().info((CharSequence)("Executing \"" + String.join((CharSequence)" ", args) + "\""));
                    }
                    Path workingDirectory = (Path)cmd.get(1);
                    try {
                        ProcessBuilder builder = new ProcessBuilder(new String[0]).command(args).inheritIO();
                        if (workingDirectory != null) {
                            builder.directory(workingDirectory.toFile());
                        }
                        Process process = builder.start();
                        int n = process.waitFor();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, new String[]{RunCommandActionResultBuildItem.class.getName(), DevServicesLauncherConfigResultBuildItem.class.getName()});
            if (target != null && !((Boolean)exists.get()).booleanValue()) {
                this.getLog().error((CharSequence)("quarkus.run.target " + target + " is not found"));
                return;
            }
            if (tooMany.get() != null) {
                this.getLog().error((CharSequence)"Too many installed extensions support quarkus:run.  Use -Dquarkus.run.target=<target> to choose");
                this.getLog().error((CharSequence)("Extensions: " + (String)tooMany.get()));
            }
        }
        finally {
            propertiesToClear.forEach(System::clearProperty);
        }
    }
}

