/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer.runtime;

import io.quarkus.mailer.Mail;
import io.quarkus.mailer.MockMailbox;
import io.smallrye.mutiny.Uni;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class MockMailboxImpl
implements MockMailbox {
    private Map<String, List<Mail>> sentMessages = new HashMap<String, List<Mail>>();
    private int sentMessagesCount;

    Uni<Void> send(Mail email) {
        if (email.getTo() != null) {
            for (String to : email.getTo()) {
                this.send(email, to);
            }
        }
        if (email.getCc() != null) {
            for (String to : email.getCc()) {
                this.send(email, to);
            }
        }
        if (email.getBcc() != null) {
            for (String to : email.getBcc()) {
                this.send(email, to);
            }
        }
        return Uni.createFrom().item(() -> null);
    }

    private void send(Mail sentMail, String to) {
        List mails = this.sentMessages.computeIfAbsent(to, k -> new LinkedList());
        ++this.sentMessagesCount;
        mails.add(sentMail);
    }

    @Override
    public List<Mail> getMessagesSentTo(String address) {
        return this.sentMessages.get(address);
    }

    @Override
    public void clear() {
        this.sentMessagesCount = 0;
        this.sentMessages.clear();
    }

    @Override
    public int getTotalMessagesSent() {
        return this.sentMessagesCount;
    }
}

