/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.pep.runtime;

import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerTenantConfig;
import io.quarkus.runtime.util.StringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.random.RandomGenerator;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;

public final class KeycloakPolicyEnforcerTenantConfigBuilder {
    private final Map<String, PathConfigBuilderImpl> paths = new HashMap<String, PathConfigBuilderImpl>();
    private int connectionPoolSize;
    private PolicyEnforcerConfig.EnforcementMode enforcementMode;
    private boolean lazyLoadPaths;
    private boolean httpMethodAsScope;
    private KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.ClaimInformationPointConfig claimInformationPoint;
    private KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.PathCacheConfig pathCache;

    KeycloakPolicyEnforcerTenantConfigBuilder(KeycloakPolicyEnforcerTenantConfig originalConfig) {
        this.connectionPoolSize = originalConfig.connectionPoolSize();
        KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer policyEnforcer = originalConfig.policyEnforcer();
        this.enforcementMode = policyEnforcer.enforcementMode();
        this.lazyLoadPaths = policyEnforcer.lazyLoadPaths();
        this.httpMethodAsScope = policyEnforcer.httpMethodAsScope();
        this.claimInformationPoint = policyEnforcer.claimInformationPoint();
        this.pathCache = policyEnforcer.pathCache();
        policyEnforcer.paths().forEach(new BiConsumer<String, KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.PathConfig>(){

            @Override
            public void accept(String name, KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.PathConfig pathConfig) {
                KeycloakPolicyEnforcerTenantConfigBuilder.this.paths.put(name, new PathConfigBuilderImpl(KeycloakPolicyEnforcerTenantConfigBuilder.this, pathConfig));
            }
        });
    }

    public KeycloakPolicyEnforcerTenantConfig build() {
        final HashMap pathConfigs = new HashMap();
        this.paths.forEach(new BiConsumer<String, PathConfigBuilderImpl>(){

            @Override
            public void accept(String name, PathConfigBuilderImpl pathConfigBuilder) {
                PathConfigImpl pathConfig = new PathConfigImpl(Optional.ofNullable(pathConfigBuilder.name), Optional.empty(), Optional.of(List.copyOf(pathConfigBuilder.paths)), Map.copyOf(pathConfigBuilder.methods), pathConfigBuilder.enforcementMode, pathConfigBuilder.claimInformationPointConfig);
                pathConfigs.put(name, pathConfig);
            }
        });
        return new KeycloakPolicyEnforcerTenantConfigImpl(this.connectionPoolSize, new KeycloakConfigPolicyEnforcerImpl(Map.copyOf(pathConfigs), this.enforcementMode, this.lazyLoadPaths, this.httpMethodAsScope, this.claimInformationPoint, this.pathCache));
    }

    public KeycloakPolicyEnforcerTenantConfigBuilder connectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this;
    }

    public KeycloakPolicyEnforcerTenantConfigBuilder enforcementMode(PolicyEnforcerConfig.EnforcementMode enforcementMode) {
        Objects.requireNonNull(enforcementMode);
        this.enforcementMode = enforcementMode;
        return this;
    }

    public KeycloakPolicyEnforcerTenantConfigBuilder lazyLoadPaths(boolean lazyLoadPaths) {
        this.lazyLoadPaths = lazyLoadPaths;
        return this;
    }

    public KeycloakPolicyEnforcerTenantConfigBuilder httpMethodAsScope(boolean httpMethodAsScope) {
        this.httpMethodAsScope = httpMethodAsScope;
        return this;
    }

    public KeycloakPolicyEnforcerTenantConfigBuilder pathCache(long lifespan) {
        this.pathCache = new PathCacheConfigImpl(lifespan, this.pathCache == null ? 0 : this.pathCache.maxEntries());
        return this;
    }

    public KeycloakPolicyEnforcerTenantConfigBuilder pathCache(int maxEntries) {
        this.pathCache = new PathCacheConfigImpl(this.pathCache == null ? 0L : this.pathCache.lifespan(), maxEntries);
        return this;
    }

    public KeycloakPolicyEnforcerTenantConfigBuilder pathCache(int maxEntries, long lifespan) {
        this.pathCache = new PathCacheConfigImpl(lifespan, maxEntries);
        return this;
    }

    public PathCacheConfigBuilder pathCache() {
        return new PathCacheConfigBuilder(this);
    }

    public KeycloakPolicyEnforcerTenantConfigBuilder claimInformationPoint(Map<String, Map<String, String>> simpleConfig) {
        this.claimInformationPoint = new ClaimInformationPointConfigImpl(simpleConfig == null ? Map.of() : Map.copyOf(simpleConfig), this.claimInformationPoint == null ? Map.of() : this.claimInformationPoint.complexConfig());
        return this;
    }

    public KeycloakPolicyEnforcerTenantConfigBuilder claimInformationPoint(Map<String, Map<String, String>> simpleConfig, Map<String, Map<String, Map<String, String>>> complexConfig) {
        this.claimInformationPoint = new ClaimInformationPointConfigImpl(simpleConfig == null ? Map.of() : Map.copyOf(simpleConfig), complexConfig == null ? Map.of() : Map.copyOf(complexConfig));
        return this;
    }

    public ClaimInformationPointConfigBuilder<KeycloakPolicyEnforcerTenantConfigBuilder> claimInformationPoint() {
        return new ClaimInformationPointConfigBuilder<KeycloakPolicyEnforcerTenantConfigBuilder>(){

            @Override
            public KeycloakPolicyEnforcerTenantConfigBuilder build() {
                if (this.simpleConfig != null || this.complexConfig != null) {
                    return KeycloakPolicyEnforcerTenantConfigBuilder.this.claimInformationPoint(this.simpleConfig, this.complexConfig);
                }
                return KeycloakPolicyEnforcerTenantConfigBuilder.this;
            }
        };
    }

    public PathConfigBuilder namedPaths(String name, PolicyEnforcerConfig.EnforcementMode enforcementMode, String ... paths) {
        PathConfigBuilder pathConfigBuilder = this.namedPaths(name, paths);
        pathConfigBuilder.enforcementMode(enforcementMode);
        return pathConfigBuilder;
    }

    public PathConfigBuilder namedPaths(String name, String ... paths) {
        Objects.requireNonNull(name);
        PathConfigBuilderImpl pathConfigBuilder = this.paths.computeIfAbsent(name, new Function<String, PathConfigBuilderImpl>(){

            @Override
            public PathConfigBuilderImpl apply(String ignored) {
                return new PathConfigBuilderImpl(KeycloakPolicyEnforcerTenantConfigBuilder.this, null);
            }
        });
        if (paths != null && paths.length > 0) {
            pathConfigBuilder.paths.addAll(Set.of(paths));
        }
        return pathConfigBuilder;
    }

    public PathConfigBuilder paths(PolicyEnforcerConfig.EnforcementMode enforcementMode, String ... paths) {
        PathConfigBuilder pathConfigBuilder = this.paths(paths);
        pathConfigBuilder.enforcementMode(enforcementMode);
        return pathConfigBuilder;
    }

    public PathConfigBuilder paths(String ... paths) {
        String name = paths == null || paths.length == 0 ? this.getRandomPathName() : StringUtil.hyphenate((String)String.join((CharSequence)"-", paths));
        return this.namedPaths(name, paths);
    }

    private String getRandomPathName() {
        String name;
        while (this.paths.containsKey(name = "path" + RandomGenerator.getDefault().nextInt())) {
        }
        return name;
    }

    private record KeycloakPolicyEnforcerTenantConfigImpl(int connectionPoolSize, KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer policyEnforcer) implements KeycloakPolicyEnforcerTenantConfig
    {
    }

    private record KeycloakConfigPolicyEnforcerImpl(Map<String, KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.PathConfig> paths, PolicyEnforcerConfig.EnforcementMode enforcementMode, boolean lazyLoadPaths, boolean httpMethodAsScope, KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.ClaimInformationPointConfig claimInformationPoint, KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.PathCacheConfig pathCache) implements KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer
    {
    }

    private record PathCacheConfigImpl(long lifespan, int maxEntries) implements KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.PathCacheConfig
    {
    }

    public static final class PathCacheConfigBuilder {
        private final KeycloakPolicyEnforcerTenantConfigBuilder parent;
        Integer maxEntries = null;
        Long lifespan = null;

        private PathCacheConfigBuilder(KeycloakPolicyEnforcerTenantConfigBuilder parent) {
            this.parent = parent;
        }

        public PathCacheConfigBuilder lifespan(long lifespan) {
            this.lifespan = lifespan;
            return this;
        }

        public PathCacheConfigBuilder maxEntries(int maxEntries) {
            this.maxEntries = maxEntries;
            return this;
        }

        public KeycloakPolicyEnforcerTenantConfigBuilder build() {
            if (this.maxEntries == null && this.lifespan == null) {
                return this.parent;
            }
            if (this.maxEntries == null) {
                return this.parent.pathCache(this.lifespan);
            }
            if (this.lifespan == null) {
                return this.parent.pathCache(this.maxEntries);
            }
            return this.parent.pathCache(this.maxEntries, this.lifespan);
        }
    }

    private record ClaimInformationPointConfigImpl(Map<String, Map<String, String>> simpleConfig, Map<String, Map<String, Map<String, String>>> complexConfig) implements KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.ClaimInformationPointConfig
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface PathConfigBuilder {
        public KeycloakPolicyEnforcerTenantConfigBuilder claimInformationPoint(Map<String, Map<String, String>> var1);

        public KeycloakPolicyEnforcerTenantConfigBuilder claimInformationPoint(Map<String, Map<String, String>> var1, Map<String, Map<String, Map<String, String>>> var2);

        public ClaimInformationPointConfigBuilder<PathConfigBuilder> claimInformationPoint();

        public KeycloakPolicyEnforcerTenantConfigBuilder enforcementMode(PolicyEnforcerConfig.EnforcementMode var1);

        public KeycloakPolicyEnforcerTenantConfigBuilder post(String ... var1);

        public KeycloakPolicyEnforcerTenantConfigBuilder post(PolicyEnforcerConfig.ScopeEnforcementMode var1, String ... var2);

        public KeycloakPolicyEnforcerTenantConfigBuilder head(String ... var1);

        public KeycloakPolicyEnforcerTenantConfigBuilder head(PolicyEnforcerConfig.ScopeEnforcementMode var1, String ... var2);

        public KeycloakPolicyEnforcerTenantConfigBuilder get(String ... var1);

        public KeycloakPolicyEnforcerTenantConfigBuilder get(PolicyEnforcerConfig.ScopeEnforcementMode var1, String ... var2);

        public KeycloakPolicyEnforcerTenantConfigBuilder put(String ... var1);

        public KeycloakPolicyEnforcerTenantConfigBuilder put(PolicyEnforcerConfig.ScopeEnforcementMode var1, String ... var2);

        public KeycloakPolicyEnforcerTenantConfigBuilder patch(String ... var1);

        public KeycloakPolicyEnforcerTenantConfigBuilder patch(PolicyEnforcerConfig.ScopeEnforcementMode var1, String ... var2);

        public KeycloakPolicyEnforcerTenantConfigBuilder method(String var1, PolicyEnforcerConfig.ScopeEnforcementMode var2, String ... var3);

        public MethodConfigBuilder method();

        public PathConfigBuilder permissionName(String var1);

        public KeycloakPolicyEnforcerTenantConfigBuilder parent();
    }

    private static final class PathConfigBuilderImpl
    implements PathConfigBuilder {
        private final KeycloakPolicyEnforcerTenantConfigBuilder builder;
        private final Map<String, KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.MethodConfig> methods = new HashMap<String, KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.MethodConfig>();
        private final Set<String> paths = new HashSet<String>();
        private KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.ClaimInformationPointConfig claimInformationPointConfig = new ClaimInformationPointConfigImpl(Map.of(), Map.of());
        private PolicyEnforcerConfig.EnforcementMode enforcementMode = PolicyEnforcerConfig.EnforcementMode.ENFORCING;
        private String name = null;

        private PathConfigBuilderImpl(KeycloakPolicyEnforcerTenantConfigBuilder builder, KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.PathConfig pathConfig) {
            this.builder = builder;
            if (pathConfig != null) {
                this.methods.putAll(pathConfig.methods());
                this.claimInformationPointConfig = pathConfig.claimInformationPoint();
                this.paths.addAll(pathConfig.paths().orElse(List.of()));
                if (pathConfig.path().isPresent()) {
                    this.paths.add(pathConfig.path().get());
                }
                this.enforcementMode = pathConfig.enforcementMode();
            }
        }

        @Override
        public KeycloakPolicyEnforcerTenantConfigBuilder claimInformationPoint(Map<String, Map<String, String>> simpleConfig) {
            this.claimInformationPointConfig = new ClaimInformationPointConfigImpl(simpleConfig == null ? Map.of() : Map.copyOf(simpleConfig), this.claimInformationPointConfig == null ? Map.of() : this.claimInformationPointConfig.complexConfig());
            return this.builder;
        }

        @Override
        public KeycloakPolicyEnforcerTenantConfigBuilder claimInformationPoint(Map<String, Map<String, String>> simpleConfig, Map<String, Map<String, Map<String, String>>> complexConfig) {
            this.claimInformationPointConfig = new ClaimInformationPointConfigImpl(simpleConfig == null ? Map.of() : Map.copyOf(simpleConfig), complexConfig == null ? Map.of() : Map.copyOf(complexConfig));
            return this.builder;
        }

        @Override
        public ClaimInformationPointConfigBuilder<PathConfigBuilder> claimInformationPoint() {
            return new ClaimInformationPointConfigBuilder<PathConfigBuilder>(){

                @Override
                public PathConfigBuilder build() {
                    if (this.simpleConfig != null || this.complexConfig != null) {
                        this.claimInformationPoint(this.simpleConfig, this.complexConfig);
                    }
                    return this;
                }
            };
        }

        @Override
        public PathConfigBuilder permissionName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public KeycloakPolicyEnforcerTenantConfigBuilder enforcementMode(PolicyEnforcerConfig.EnforcementMode enforcementMode) {
            Objects.requireNonNull(enforcementMode);
            this.enforcementMode = enforcementMode;
            return this.builder;
        }

        @Override
        public KeycloakPolicyEnforcerTenantConfigBuilder post(String ... scopes) {
            return this.post((PolicyEnforcerConfig.ScopeEnforcementMode)null, scopes);
        }

        @Override
        public KeycloakPolicyEnforcerTenantConfigBuilder post(PolicyEnforcerConfig.ScopeEnforcementMode scopeEnforcementMode, String ... scopes) {
            return this.method("POST", scopeEnforcementMode, scopes);
        }

        @Override
        public KeycloakPolicyEnforcerTenantConfigBuilder head(String ... scopes) {
            return this.head((PolicyEnforcerConfig.ScopeEnforcementMode)null, scopes);
        }

        @Override
        public KeycloakPolicyEnforcerTenantConfigBuilder head(PolicyEnforcerConfig.ScopeEnforcementMode scopeEnforcementMode, String ... scopes) {
            return this.method("HEAD", scopeEnforcementMode, scopes);
        }

        @Override
        public KeycloakPolicyEnforcerTenantConfigBuilder get(String ... scopes) {
            return this.get((PolicyEnforcerConfig.ScopeEnforcementMode)null, scopes);
        }

        @Override
        public KeycloakPolicyEnforcerTenantConfigBuilder get(PolicyEnforcerConfig.ScopeEnforcementMode scopeEnforcementMode, String ... scopes) {
            return this.method("GET", scopeEnforcementMode, scopes);
        }

        @Override
        public KeycloakPolicyEnforcerTenantConfigBuilder put(String ... scopes) {
            return this.put((PolicyEnforcerConfig.ScopeEnforcementMode)null, scopes);
        }

        @Override
        public KeycloakPolicyEnforcerTenantConfigBuilder put(PolicyEnforcerConfig.ScopeEnforcementMode scopeEnforcementMode, String ... scopes) {
            return this.method("PUT", scopeEnforcementMode, scopes);
        }

        @Override
        public KeycloakPolicyEnforcerTenantConfigBuilder patch(String ... scopes) {
            return this.patch((PolicyEnforcerConfig.ScopeEnforcementMode)null, scopes);
        }

        @Override
        public KeycloakPolicyEnforcerTenantConfigBuilder patch(PolicyEnforcerConfig.ScopeEnforcementMode scopeEnforcementMode, String ... scopes) {
            return this.method("PATCH", scopeEnforcementMode, scopes);
        }

        @Override
        public KeycloakPolicyEnforcerTenantConfigBuilder method(String method, PolicyEnforcerConfig.ScopeEnforcementMode scopeEnforcementMode, String ... scopes) {
            Objects.requireNonNull(method);
            if (scopeEnforcementMode == null) {
                scopeEnforcementMode = PolicyEnforcerConfig.ScopeEnforcementMode.ALL;
            }
            this.methods.put(method.toLowerCase(), new MethodConfigImpl(method, List.of(scopes), scopeEnforcementMode));
            return this.builder;
        }

        @Override
        public MethodConfigBuilder method() {
            return new MethodConfigBuilder(this);
        }

        @Override
        public KeycloakPolicyEnforcerTenantConfigBuilder parent() {
            return this.builder;
        }
    }

    public static final class MethodConfigBuilder {
        private final PathConfigBuilder builder;
        private String method;
        private String[] scopes;
        private PolicyEnforcerConfig.ScopeEnforcementMode scopesEnforcementMode;

        private MethodConfigBuilder(PathConfigBuilder builder) {
            this.builder = builder;
        }

        public MethodConfigBuilder method(String method) {
            this.method = method;
            return this;
        }

        public MethodConfigBuilder scopes(String ... scopes) {
            this.scopes = scopes;
            return this;
        }

        public MethodConfigBuilder scopesEnforcementMode(PolicyEnforcerConfig.ScopeEnforcementMode scopesEnforcementMode) {
            this.scopesEnforcementMode = scopesEnforcementMode;
            return this;
        }

        public PathConfigBuilder build() {
            Objects.requireNonNull(this.method);
            this.builder.method(this.method, this.scopesEnforcementMode, this.scopes == null ? new String[]{} : this.scopes);
            return this.builder;
        }
    }

    public static abstract class ClaimInformationPointConfigBuilder<T> {
        protected Map<String, Map<String, String>> simpleConfig = null;
        protected Map<String, Map<String, Map<String, String>>> complexConfig = null;

        private ClaimInformationPointConfigBuilder() {
        }

        public ClaimInformationPointConfigBuilder<T> simpleConfig(Map<String, Map<String, String>> simpleConfig) {
            this.simpleConfig = simpleConfig;
            return this;
        }

        public ClaimInformationPointConfigBuilder<T> complexConfig(Map<String, Map<String, Map<String, String>>> complexConfig) {
            this.complexConfig = complexConfig;
            return this;
        }

        public abstract T build();
    }

    private record PathConfigImpl(Optional<String> name, Optional<String> path, Optional<List<String>> paths, Map<String, KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.MethodConfig> methods, PolicyEnforcerConfig.EnforcementMode enforcementMode, KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.ClaimInformationPointConfig claimInformationPoint) implements KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.PathConfig
    {
    }

    private record MethodConfigImpl(String method, List<String> scopes, PolicyEnforcerConfig.ScopeEnforcementMode scopesEnforcementMode) implements KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.MethodConfig
    {
    }
}

