/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.pep.runtime;

import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerConfig;
import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerTenantConfig;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Map;
import java.util.function.BooleanSupplier;

@Recorder
public class KeycloakPolicyEnforcerRecorder {
    public BooleanSupplier createBodyHandlerRequiredEvaluator(final KeycloakPolicyEnforcerConfig config) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                if (KeycloakPolicyEnforcerRecorder.isBodyHandlerRequired(config.defaultTenant())) {
                    return true;
                }
                for (KeycloakPolicyEnforcerTenantConfig tenantConfig : config.namedTenants().values()) {
                    if (!KeycloakPolicyEnforcerRecorder.isBodyHandlerRequired(tenantConfig)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static boolean isBodyHandlerRequired(KeycloakPolicyEnforcerTenantConfig config) {
        if (KeycloakPolicyEnforcerRecorder.isBodyClaimInformationPointDefined(config.policyEnforcer().claimInformationPoint().simpleConfig())) {
            return true;
        }
        for (KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.PathConfig path : config.policyEnforcer().paths().values()) {
            if (!KeycloakPolicyEnforcerRecorder.isBodyClaimInformationPointDefined(path.claimInformationPoint().simpleConfig())) continue;
            return true;
        }
        return false;
    }

    private static boolean isBodyClaimInformationPointDefined(Map<String, Map<String, String>> claims) {
        for (Map.Entry<String, Map<String, String>> entry : claims.entrySet()) {
            Map<String, String> value = entry.getValue();
            for (String nestedValue : value.values()) {
                if (!nestedValue.contains("request.body")) continue;
                return true;
            }
        }
        return false;
    }
}

