/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.pep.runtime;

import java.util.Map;
import org.keycloak.adapters.authorization.PolicyEnforcer;

public class PolicyEnforcerResolver {
    private final PolicyEnforcer defaultPolicyEnforcer;
    private final Map<String, PolicyEnforcer> policyEnforcerTenants;
    private final long readTimeout;

    public PolicyEnforcerResolver(PolicyEnforcer defaultPolicyEnforcer, Map<String, PolicyEnforcer> policyEnforcerTenants, long readTimeout) {
        this.defaultPolicyEnforcer = defaultPolicyEnforcer;
        this.policyEnforcerTenants = policyEnforcerTenants;
        this.readTimeout = readTimeout;
    }

    public PolicyEnforcer getPolicyEnforcer(String tenantId) {
        return tenantId != null && this.policyEnforcerTenants.containsKey(tenantId) ? this.policyEnforcerTenants.get(tenantId) : this.defaultPolicyEnforcer;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }
}

