/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.streams.runtime.health;

import io.quarkus.kafka.streams.runtime.KafkaStreamsTopologyManager;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;
import org.jboss.logging.Logger;

@Readiness
@ApplicationScoped
public class KafkaStreamsTopicsHealthCheck
implements HealthCheck {
    private static final Logger LOGGER = Logger.getLogger((String)KafkaStreamsTopicsHealthCheck.class.getName());
    @Inject
    KafkaStreamsTopologyManager manager;
    private final List<String> checkedTopics;

    @Inject
    public KafkaStreamsTopicsHealthCheck(KafkaStreamsTopologyManager manager) {
        this.manager = manager;
        this.checkedTopics = new ArrayList<String>();
        if (manager.isTopicsCheckEnabled()) {
            this.checkedTopics.addAll(manager.getSourceTopics());
            this.checkedTopics.addAll(manager.getSourcePatterns().stream().map(Pattern::pattern).toList());
        }
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Kafka Streams topics health check").up();
        if (this.manager.isTopicsCheckEnabled()) {
            try {
                Set<String> missingTopics = this.manager.getMissingTopics();
                ArrayList<String> availableTopics = new ArrayList<String>(this.checkedTopics);
                availableTopics.removeAll(missingTopics);
                if (!availableTopics.isEmpty()) {
                    builder.withData("available_topics", String.join((CharSequence)",", availableTopics));
                }
                if (!missingTopics.isEmpty()) {
                    builder.down().withData("missing_topics", String.join((CharSequence)",", missingTopics));
                }
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"error when retrieving missing topics", (Throwable)e);
                builder.down().withData("technical_error", e.getMessage());
            }
        }
        return builder.build();
    }
}

