/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.streams.runtime.health;

import io.quarkus.kafka.streams.runtime.KafkaStreamsRuntimeConfig;
import io.quarkus.kafka.streams.runtime.KafkaStreamsTopologyManager;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;
import org.jboss.logging.Logger;

@Readiness
@ApplicationScoped
public class KafkaStreamsTopicsHealthCheck
implements HealthCheck {
    private static final Logger LOGGER = Logger.getLogger((String)KafkaStreamsTopicsHealthCheck.class.getName());
    @Inject
    KafkaStreamsRuntimeConfig kafkaStreamsRuntimeConfig;
    @Inject
    KafkaStreamsTopologyManager manager;
    private List<String> trimmedTopics;

    @PostConstruct
    public void init() {
        if (this.kafkaStreamsRuntimeConfig.topicsTimeout().compareTo(Duration.ZERO) > 0) {
            this.trimmedTopics = this.kafkaStreamsRuntimeConfig.topics().orElseThrow(() -> new IllegalArgumentException("Missing list of topics")).stream().map(String::trim).collect(Collectors.toList());
        }
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Kafka Streams topics health check").up();
        if (this.trimmedTopics != null) {
            try {
                Set<String> missingTopics = this.manager.getMissingTopics(this.trimmedTopics, this.kafkaStreamsRuntimeConfig.topicsTimeout());
                ArrayList<String> availableTopics = new ArrayList<String>(this.trimmedTopics);
                availableTopics.removeAll(missingTopics);
                if (!availableTopics.isEmpty()) {
                    builder.withData("available_topics", String.join((CharSequence)",", availableTopics));
                }
                if (!missingTopics.isEmpty()) {
                    builder.down().withData("missing_topics", String.join((CharSequence)",", missingTopics));
                }
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"error when retrieving missing topics", (Throwable)e);
                builder.down().withData("technical_error", e.getMessage());
            }
        }
        return builder.build();
    }
}

