/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.streams.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JniRuntimeAccessBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageRunnerBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.kafka.streams.deployment.KafkaStreamsBuildTimeConfig;
import io.quarkus.kafka.streams.runtime.KafkaStreamsProducer;
import io.quarkus.kafka.streams.runtime.KafkaStreamsPropertiesUtil;
import io.quarkus.kafka.streams.runtime.KafkaStreamsRecorder;
import io.quarkus.kafka.streams.runtime.KafkaStreamsRuntimeConfig;
import io.quarkus.kafka.streams.runtime.KafkaStreamsSupport;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.errors.DefaultProductionExceptionHandler;
import org.apache.kafka.streams.errors.LogAndFailExceptionHandler;
import org.apache.kafka.streams.processor.FailOnInvalidTimestamp;
import org.apache.kafka.streams.processor.internals.StreamsPartitionAssignor;
import org.apache.kafka.streams.processor.internals.assignment.FallbackPriorTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.HighAvailabilityTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.StickyTaskAssignor;
import org.rocksdb.RocksDBException;
import org.rocksdb.Status;
import org.rocksdb.util.Environment;

class KafkaStreamsProcessor {
    public static final String DEFAULT_PARTITION_GROUPER = "org.apache.kafka.streams.processor.DefaultPartitionGrouper";

    KafkaStreamsProcessor() {
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void build(BuildProducer<FeatureBuildItem> feature, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<JniRuntimeAccessBuildItem> jniRuntimeAccessibleClasses, BuildProducer<RuntimeReinitializedClassBuildItem> reinitialized, BuildProducer<NativeImageResourceBuildItem> nativeLibs, LaunchModeBuildItem launchMode, NativeImageRunnerBuildItem nativeImageRunner) throws IOException {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.KAFKA_STREAMS));
        this.registerClassesThatAreLoadedThroughReflection(reflectiveClasses, launchMode);
        this.registerClassesThatAreAccessedViaJni(jniRuntimeAccessibleClasses);
        this.addSupportForRocksDbLib(nativeLibs, nativeImageRunner);
        this.enableLoadOfNativeLibs(reinitialized);
    }

    private void registerClassesThatAreLoadedThroughReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, LaunchModeBuildItem launchMode) {
        this.registerCompulsoryClasses(reflectiveClasses);
        this.registerClassesThatClientMaySpecify(reflectiveClasses, launchMode);
    }

    private void registerCompulsoryClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{StreamsPartitionAssignor.class}).build());
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)DEFAULT_PARTITION_GROUPER)) {
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{DEFAULT_PARTITION_GROUPER}).build());
        }
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{DefaultProductionExceptionHandler.class}).build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{FailOnInvalidTimestamp.class}).build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{HighAvailabilityTaskAssignor.class}).methods().fields().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{StickyTaskAssignor.class}).methods().fields().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{FallbackPriorTaskAssignor.class}).methods().fields().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.apache.kafka.streams.processor.internals.StateDirectory$StateDirectoryProcessFile"}).methods().fields().build());
    }

    private void registerClassesThatClientMaySpecify(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, LaunchModeBuildItem launchMode) {
        Properties properties = KafkaStreamsPropertiesUtil.buildKafkaStreamsProperties((LaunchMode)launchMode.getLaunchMode());
        this.registerExceptionHandler(reflectiveClasses, properties);
        this.registerDefaultSerdes(reflectiveClasses, properties);
    }

    private void registerExceptionHandler(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, Properties kafkaStreamsProperties) {
        String exceptionHandlerClassName = kafkaStreamsProperties.getProperty("default.deserialization.exception.handler");
        if (exceptionHandlerClassName == null) {
            this.registerDefaultExceptionHandler(reflectiveClasses);
        } else {
            this.registerClassName(reflectiveClasses, exceptionHandlerClassName);
        }
    }

    private void registerDefaultExceptionHandler(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{LogAndFailExceptionHandler.class}).build());
    }

    private void registerDefaultSerdes(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, Properties kafkaStreamsProperties) {
        String defaultKeySerdeClass = kafkaStreamsProperties.getProperty("default.key.serde");
        String defaultValueSerdeClass = kafkaStreamsProperties.getProperty("default.value.serde");
        if (defaultKeySerdeClass != null) {
            this.registerClassName(reflectiveClasses, defaultKeySerdeClass);
        }
        if (defaultValueSerdeClass != null) {
            this.registerClassName(reflectiveClasses, defaultValueSerdeClass);
        }
        if (!this.allDefaultSerdesAreDefinedInProperties(defaultKeySerdeClass, defaultValueSerdeClass)) {
            this.registerDefaultSerde(reflectiveClasses);
        }
    }

    private void registerClassesThatAreAccessedViaJni(BuildProducer<JniRuntimeAccessBuildItem> jniRuntimeAccessibleClasses) {
        jniRuntimeAccessibleClasses.produce((BuildItem)new JniRuntimeAccessBuildItem(true, false, false, new Class[]{RocksDBException.class, Status.class}));
    }

    private void addSupportForRocksDbLib(BuildProducer<NativeImageResourceBuildItem> nativeLibs, NativeImageRunnerBuildItem nativeImageRunnerFactory) {
        if (nativeImageRunnerFactory.isContainerBuild()) {
            nativeLibs.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"librocksdbjni-linux64.so"}));
        } else {
            nativeLibs.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{Environment.getJniLibraryFileName((String)"rocksdb")}));
        }
    }

    private void enableLoadOfNativeLibs(BuildProducer<RuntimeReinitializedClassBuildItem> reinitialized) {
        reinitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.rocksdb.RocksDB"));
    }

    private void registerClassName(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, String defaultKeySerdeClass) {
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{defaultKeySerdeClass}).build());
    }

    private boolean allDefaultSerdesAreDefinedInProperties(String defaultKeySerdeClass, String defaultValueSerdeClass) {
        return defaultKeySerdeClass != null && defaultValueSerdeClass != null;
    }

    private void registerDefaultSerde(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{Serdes.ByteArraySerde.class}).build());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void processBuildTimeConfig(KafkaStreamsRecorder recorder, LaunchModeBuildItem launchMode, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        Properties kafkaStreamsProperties = KafkaStreamsPropertiesUtil.buildKafkaStreamsProperties((LaunchMode)launchMode.getLaunchMode());
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(KafkaStreamsSupport.class).scope(Singleton.class)).supplier(recorder.kafkaStreamsSupportSupplier(kafkaStreamsProperties)).done());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{KafkaStreamsProducer.class}).setUnremovable().build());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void loadRocksDb(KafkaStreamsRecorder recorder, KafkaStreamsRuntimeConfig runtimeConfig) {
        recorder.loadRocksDb();
    }

    @BuildStep
    void addHealthChecks(KafkaStreamsBuildTimeConfig buildTimeConfig, BuildProducer<HealthBuildItem> healthChecks) {
        healthChecks.produce((BuildItem)new HealthBuildItem("io.quarkus.kafka.streams.runtime.health.KafkaStreamsTopicsHealthCheck", buildTimeConfig.healthEnabled));
        healthChecks.produce((BuildItem)new HealthBuildItem("io.quarkus.kafka.streams.runtime.health.KafkaStreamsStateHealthCheck", buildTimeConfig.healthEnabled));
    }
}

