/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.kafka.client.serialization.ObjectMapperDeserializer;
import io.quarkus.kafka.client.serialization.ObjectMapperProducer;
import io.quarkus.kafka.client.serialization.ObjectMapperSerializer;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;

public class ObjectMapperSerde<T>
implements Serde<T> {
    private final ObjectMapperSerializer<T> serializer;
    private final ObjectMapperDeserializer<T> deserializer;

    public ObjectMapperSerde(Class<T> type) {
        this(type, ObjectMapperProducer.get());
    }

    public ObjectMapperSerde(Class<T> type, ObjectMapper objectMapper) {
        this.serializer = new ObjectMapperSerializer(objectMapper);
        this.deserializer = new ObjectMapperDeserializer<T>(type, objectMapper);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public void close() {
        this.serializer.close();
        this.deserializer.close();
    }

    public Serializer<T> serializer() {
        return this.serializer;
    }

    public Deserializer<T> deserializer() {
        return this.deserializer;
    }
}

