/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.launcher;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import java.util.Optional;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;

public class ExecutionListener
implements TestExecutionListener {
    private ClassLoader origCl = null;

    public void executionStarted(TestIdentifier testIdentifier) {
        TestSource source;
        Optional oSource = testIdentifier.getSource();
        if (oSource.isPresent() && (source = (TestSource)oSource.get()) instanceof ClassSource) {
            ClassSource cs = (ClassSource)source;
            ClassLoader classLoader = cs.getJavaClass().getClassLoader();
            if (classLoader instanceof QuarkusClassLoader) {
                this.origCl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
            } else {
                this.origCl = null;
            }
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult result) {
        if (this.origCl != null) {
            Thread.currentThread().setContextClassLoader(this.origCl);
        }
    }
}

