/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.AugmentResult;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.test.ExclusivityChecker;
import io.quarkus.test.InMemoryLogHandler;
import io.quarkus.test.LogFile;
import io.quarkus.test.ProdBuildResults;
import io.quarkus.test.ProdModeTestBuildChainBuilderConsumer;
import io.quarkus.test.ProdModeTestBuildChainCustomizerProducer;
import io.quarkus.test.ProdModeTestBuildStep;
import io.quarkus.test.ProdModeTestResults;
import io.quarkus.test.PropertiesAsset;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.utilities.JavaBinFinder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.jboss.logmanager.Logger;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.junit.platform.commons.JUnitException;

public class QuarkusProdModeTest
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
TestWatcher,
InvocationInterceptor {
    private static final String EXPECTED_OUTPUT_FROM_SUCCESSFULLY_STARTED = "features";
    private static final int DEFAULT_HTTP_PORT_INT = 8081;
    private static final String DEFAULT_HTTP_PORT = "8081";
    private static final String QUARKUS_HTTP_PORT_PROPERTY = "quarkus.http.port";
    static final String BUILD_CONTEXT_BUILD_STEP_ENTRIES = "buildStepEntries";
    static final String BUILD_CONTEXT_BUILD_STEP_ENTRY_CONSUMES = "buildStepEntryConsumes";
    static final String BUILD_CONTEXT_BUILD_STEP_ENTRY_PRODUCES = "buildStepEntryProduces";
    public static String BUILD_CONTEXT_CUSTOM_SOURCES_PATH_KEY = "customSourcesDir";
    private static final Logger rootLogger;
    private Handler[] originalHandlers;
    private Path outputDir;
    private Path buildDir;
    private Supplier<JavaArchive> archiveProducer;
    private String applicationName;
    private String applicationVersion;
    private boolean buildNative;
    private static final Timer timeoutTimer;
    private volatile TimerTask timeoutTask;
    private Properties customApplicationProperties;
    private CuratedApplication curatedApplication;
    private boolean run;
    private boolean preventOutputDirCleanup;
    private String logFileName;
    private Map<String, String> runtimeProperties;
    private List<String> jvmArgs = Collections.singletonList("-Xmx128m");
    private Map<String, String> testResourceProperties = new HashMap<String, String>();
    private Map<Path, String> customSourcesMap = new HashMap<Path, String>();
    private List<BuildChainCustomizerEntry> buildChainCustomizerEntries = new ArrayList<BuildChainCustomizerEntry>();
    private Process process;
    private Path builtResultArtifact;
    private ProdModeTestResults prodModeTestResults;
    private Optional<Field> prodModeTestResultsField = Optional.empty();
    private Path logfilePath;
    private Optional<Field> logfileField = Optional.empty();
    private List<AppArtifact> forcedDependencies = Collections.emptyList();
    private InMemoryLogHandler inMemoryLogHandler = new InMemoryLogHandler(r -> false);
    private boolean expectExit;
    private String startupConsoleOutput;
    private Integer exitCode;
    private Consumer<Throwable> assertBuildException;
    private String[] commandLineParameters = new String[0];

    public QuarkusProdModeTest() {
        InputStream appPropsIs = Thread.currentThread().getContextClassLoader().getResourceAsStream("application.properties");
        if (appPropsIs != null) {
            this.customApplicationProperties = new Properties();
            try (InputStream is = appPropsIs;){
                this.customApplicationProperties.load(is);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to load application configuration from " + Thread.currentThread().getContextClassLoader().getResource("application.properties"), e);
            }
        }
    }

    public Supplier<JavaArchive> getArchiveProducer() {
        return this.archiveProducer;
    }

    public QuarkusProdModeTest setArchiveProducer(Supplier<JavaArchive> archiveProducer) {
        Objects.requireNonNull(archiveProducer);
        this.archiveProducer = archiveProducer;
        return this;
    }

    public QuarkusProdModeTest addBuildChainCustomizerEntries(BuildChainCustomizerEntry entry) {
        Objects.requireNonNull(entry);
        this.buildChainCustomizerEntries.add(entry);
        return this;
    }

    public QuarkusProdModeTest addCustomResourceEntry(Path outputPath, String classPathLocation) {
        Objects.requireNonNull(outputPath);
        Objects.requireNonNull(classPathLocation);
        this.customSourcesMap.put(outputPath, classPathLocation);
        return this;
    }

    public QuarkusProdModeTest setApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public QuarkusProdModeTest setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
        return this;
    }

    public QuarkusProdModeTest setBuildNative(boolean buildNative) {
        this.buildNative = buildNative;
        return this;
    }

    public QuarkusProdModeTest setRun(boolean run) {
        this.run = run;
        return this;
    }

    public QuarkusProdModeTest setLogFileName(String logFileName) {
        this.logFileName = logFileName;
        return this;
    }

    public QuarkusProdModeTest setJVMArgs(List<String> jvmArgs) {
        this.jvmArgs = jvmArgs;
        return this;
    }

    public QuarkusProdModeTest setRuntimeProperties(Map<String, String> runtimeProperties) {
        this.runtimeProperties = runtimeProperties;
        return this;
    }

    public QuarkusProdModeTest setLogRecordPredicate(Predicate<LogRecord> predicate) {
        this.inMemoryLogHandler = new InMemoryLogHandler(predicate);
        return this;
    }

    public QuarkusProdModeTest setForcedDependencies(List<AppArtifact> forcedDependencies) {
        this.forcedDependencies = forcedDependencies;
        return this;
    }

    public QuarkusProdModeTest setExpectExit(boolean expectExit) {
        this.expectExit = expectExit;
        return this;
    }

    public QuarkusProdModeTest assertBuildException(Consumer<Throwable> assertException) {
        if (this.assertBuildException != null) {
            throw new IllegalStateException("Don't set the asserted or excepted exception twice to avoid shadowing out the first call.");
        }
        this.assertBuildException = assertException;
        return this;
    }

    public QuarkusProdModeTest setExpectedException(Class<? extends Throwable> expectedException) {
        return this.assertBuildException(t -> {
            boolean found = false;
            for (Throwable i = t; i != null; i = i.getCause()) {
                if (!i.getClass().getName().equals(expectedException.getName())) continue;
                found = true;
                break;
            }
            Assertions.assertTrue((boolean)found, (String)("Build failed with wrong exception, expected " + expectedException + " but got " + t));
        });
    }

    public String getStartupConsoleOutput() {
        return this.startupConsoleOutput;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    private void exportArchive(Path deploymentDir, Class<?> testClass) {
        try {
            JavaArchive archive = this.getArchiveProducerOrDefault();
            if (this.customApplicationProperties != null) {
                archive.add((Asset)new PropertiesAsset(this.customApplicationProperties), "application.properties");
            }
            ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExplodedInto(deploymentDir.toFile());
            String exportPath = System.getProperty("quarkus.deploymentExportPath");
            if (exportPath != null) {
                File exportDir = new File(exportPath);
                if (exportDir.exists()) {
                    if (!exportDir.isDirectory()) {
                        throw new IllegalStateException("Export path is not a directory: " + exportPath);
                    }
                    try (Stream<Path> stream = Files.walk(exportDir.toPath(), new FileVisitOption[0]);){
                        stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    }
                } else if (!exportDir.mkdirs()) {
                    throw new IllegalStateException("Export path could not be created: " + exportPath);
                }
                File exportFile = new File(exportDir, archive.getName());
                ((ZipExporter)archive.as(ZipExporter.class)).exportTo(exportFile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create the archive", e);
        }
    }

    private JavaArchive getArchiveProducerOrDefault() {
        if (this.archiveProducer == null) {
            return (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        }
        return this.archiveProducer.get();
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.ensureNoInjectAnnotationIsUsed(extensionContext.getRequiredTestClass());
        ExclusivityChecker.checkTestType(extensionContext, QuarkusProdModeTest.class);
        this.originalHandlers = rootLogger.getHandlers();
        rootLogger.addHandler((Handler)this.inMemoryLogHandler);
        this.timeoutTask = new PrintStackTraceTimerTask();
        timeoutTimer.schedule(this.timeoutTask, 300000L);
        ExtensionContext.Store store = extensionContext.getRoot().getStore(ExtensionContext.Namespace.GLOBAL);
        if (store.get((Object)TestResourceManager.class.getName()) == null) {
            final TestResourceManager manager = new TestResourceManager(extensionContext.getRequiredTestClass());
            manager.init();
            this.testResourceProperties = manager.start();
            store.put((Object)TestResourceManager.class.getName(), (Object)manager);
            store.put((Object)TestResourceManager.CLOSEABLE_NAME, (Object)new ExtensionContext.Store.CloseableResource(){

                public void close() throws Throwable {
                    manager.close();
                }
            });
        }
        Class testClass = extensionContext.getRequiredTestClass();
        try {
            AugmentResult result;
            Path projectClassesDir;
            this.outputDir = Files.createTempDirectory("quarkus-prod-mode-test", new FileAttribute[0]);
            Path deploymentDir = this.outputDir.resolve("deployment-result");
            this.buildDir = this.outputDir.resolve("build-result");
            if (this.applicationName != null) {
                this.overrideConfigKey("quarkus.application.name", this.applicationName);
            }
            if (this.applicationVersion != null) {
                this.overrideConfigKey("quarkus.application.version", this.applicationVersion);
            }
            if (this.buildNative) {
                this.overrideConfigKey("quarkus.package.type", "native");
            }
            this.exportArchive(deploymentDir, testClass);
            Path testLocation = PathTestHelper.getTestClassesLocation((Class)testClass);
            Path customSourcesDir = this.createCustomSources(testClass);
            if (Files.isDirectory(testLocation, new LinkOption[0]) && !Files.exists(projectClassesDir = PathTestHelper.getAppClassLocationForTestLocation((String)testLocation.toString()), new LinkOption[0])) {
                Files.createDirectories(projectClassesDir, new FileAttribute[0]);
            }
            QuarkusBootstrap.Builder builder = QuarkusBootstrap.builder().setApplicationRoot(deploymentDir).setMode(QuarkusBootstrap.Mode.PROD).setLocalProjectDiscovery(Boolean.valueOf(true)).setIsolateDeployment(true).addExcludedPath(testLocation).setProjectRoot(testLocation).setTargetDirectory(this.buildDir).setForcedDependencies(this.forcedDependencies.stream().map(d -> new AppDependency(d, "compile")).collect(Collectors.toList()));
            if (this.applicationName != null) {
                builder.setBaseName(this.applicationName);
            }
            HashMap<String, Object> buildContext = new HashMap<String, Object>();
            buildContext.put(BUILD_CONTEXT_CUSTOM_SOURCES_PATH_KEY, customSourcesDir);
            if (!this.buildChainCustomizerEntries.isEmpty()) {
                Path additionalDeploymentDir = Files.createDirectories(this.outputDir.resolve("additional-deployment"), new FileAttribute[0]);
                JavaArchive additionalDeploymentArchive = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{ProdModeTestBuildChainCustomizerProducer.class, ProdModeTestBuildChainBuilderConsumer.class, ProdModeTestBuildStep.class});
                HashMap entriesMap = new HashMap();
                buildContext.put(BUILD_CONTEXT_BUILD_STEP_ENTRIES, entriesMap);
                for (BuildChainCustomizerEntry entry : this.buildChainCustomizerEntries) {
                    additionalDeploymentArchive.addClasses(new Class[]{entry.getBuildStepClass()});
                    entriesMap.put(entry.getBuildStepClass().getName(), Map.of(BUILD_CONTEXT_BUILD_STEP_ENTRY_PRODUCES, entry.getProduces().stream().map(Class::getName).collect(Collectors.toList()), BUILD_CONTEXT_BUILD_STEP_ENTRY_CONSUMES, entry.getConsumes().stream().map(Class::getName).collect(Collectors.toList())));
                }
                ((ExplodedExporter)additionalDeploymentArchive.as(ExplodedExporter.class)).exportExplodedInto(additionalDeploymentDir.toFile());
                builder.addAdditionalDeploymentArchive(additionalDeploymentDir);
            }
            this.curatedApplication = builder.build().bootstrap();
            AugmentAction action = this.buildChainCustomizerEntries.isEmpty() ? this.curatedApplication.createAugmentor() : this.curatedApplication.createAugmentor(ProdModeTestBuildChainCustomizerProducer.class.getName(), buildContext);
            try {
                result = action.createProductionApplication();
                if (this.assertBuildException != null) {
                    Assertions.fail((String)"The build was expected to fail");
                }
            }
            catch (Exception e) {
                if (this.assertBuildException != null) {
                    this.assertBuildException.accept(e);
                    return;
                }
                throw e;
            }
            finally {
                this.curatedApplication.close();
            }
            this.builtResultArtifact = this.setupProdModeResults(testClass, this.buildDir, result);
            if (this.run) {
                this.start();
                if (this.logfilePath != null) {
                    this.logfileField = Arrays.stream(testClass.getDeclaredFields()).filter(f -> f.isAnnotationPresent(LogFile.class) && Path.class.equals(f.getType())).findAny();
                    this.logfileField.ifPresent(f -> f.setAccessible(true));
                }
            }
        }
        catch (Exception e) {
            this.preventOutputDirCleanup = true;
            this.logOutputPathForPostMortem();
            throw new RuntimeException(e);
        }
    }

    private void ensureNoInjectAnnotationIsUsed(Class<?> testClass) {
        Class<?> current = testClass;
        while (current.getSuperclass() != null) {
            for (Field field : current.getDeclaredFields()) {
                Inject injectAnnotation = field.getAnnotation(Inject.class);
                if (injectAnnotation == null) continue;
                throw new JUnitException("@Inject is not supported in QuarkusProdModeTest tests. Offending field is " + field.getDeclaringClass().getTypeName() + "." + field.getName());
            }
            current = current.getSuperclass();
        }
    }

    private Path createCustomSources(Class<?> testClass) throws IOException {
        Path customSourcesDir = this.outputDir.resolve("custom-sources");
        for (Map.Entry<Path, String> entry : this.customSourcesMap.entrySet()) {
            Path finalResourcePath = customSourcesDir.resolve(entry.getKey());
            Files.createDirectories(finalResourcePath.getParent(), new FileAttribute[0]);
            InputStream classPathResource = testClass.getClassLoader().getResourceAsStream(entry.getValue());
            if (classPathResource == null) {
                throw new IllegalArgumentException("Resource '" + finalResourcePath.getFileName() + "' supplied as a value of customSourcesMap does not exist on the test classpath");
            }
            Files.write(finalResourcePath, classPathResource.readAllBytes(), new OpenOption[0]);
        }
        return customSourcesDir;
    }

    private void logOutputPathForPostMortem() {
        if (this.buildDir != null) {
            String message = "The output of the Quarkus build can be found at " + this.buildDir.toAbsolutePath().toString();
            System.err.println(message);
        }
    }

    private Path setupProdModeResults(Class<?> testClass, Path buildDir, AugmentResult result) {
        this.prodModeTestResultsField = Arrays.stream(testClass.getDeclaredFields()).filter(f -> f.isAnnotationPresent(ProdBuildResults.class) && ProdModeTestResults.class.equals(f.getType())).findAny();
        this.prodModeTestResultsField.ifPresent(f -> f.setAccessible(true));
        Path builtResultArtifact = result.getNativeResult();
        if (builtResultArtifact == null) {
            builtResultArtifact = result.getJar().getPath();
        }
        this.prodModeTestResults = new ProdModeTestResults(buildDir, builtResultArtifact, result.getResults(), this.inMemoryLogHandler.records);
        return builtResultArtifact;
    }

    public void start() {
        if (this.process != null && this.process.isAlive()) {
            throw new IllegalStateException("Quarkus application is already started. ");
        }
        this.exitCode = null;
        Path builtResultArtifactParent = this.builtResultArtifact.getParent();
        this.runtimeProperties = this.runtimeProperties == null ? new HashMap<String, String>() : new HashMap<String, String>(this.runtimeProperties);
        this.runtimeProperties.putIfAbsent(QUARKUS_HTTP_PORT_PROPERTY, DEFAULT_HTTP_PORT);
        if (this.logFileName != null) {
            this.logfilePath = builtResultArtifactParent.resolve(this.logFileName);
            this.runtimeProperties.put("quarkus.log.file.path", this.logfilePath.toAbsolutePath().toString());
            this.runtimeProperties.put("quarkus.log.file.enable", "true");
        }
        this.runtimeProperties.putAll(this.testResourceProperties);
        List systemProperties = this.runtimeProperties.entrySet().stream().map(e -> "-D" + (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.toList());
        ArrayList<String> command = new ArrayList<String>(systemProperties.size() + 3);
        if (this.builtResultArtifact.getFileName().toString().endsWith(".jar")) {
            command.add(JavaBinFinder.findBin());
            if (this.jvmArgs != null) {
                command.addAll(this.jvmArgs);
            }
            command.addAll(systemProperties);
            command.add("-jar");
            command.add(this.builtResultArtifact.toAbsolutePath().toString());
        } else {
            command.add(this.builtResultArtifact.toAbsolutePath().toString());
            if (this.jvmArgs != null) {
                command.addAll(this.jvmArgs);
            }
            command.addAll(systemProperties);
        }
        command.addAll(Arrays.asList(this.commandLineParameters));
        try {
            this.process = new ProcessBuilder(command).redirectErrorStream(true).directory(builtResultArtifactParent.toFile()).start();
            this.ensureApplicationStartupOrFailure();
            this.setupRestAssured();
        }
        catch (IOException ex) {
            throw new RuntimeException("The produced jar could not be launched. ", ex);
        }
    }

    public void stop() {
        try {
            if (this.process != null) {
                this.process.destroy();
                this.process.waitFor();
                this.exitCode = this.process.exitValue();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void setupRestAssured() {
        Integer httpPort = Optional.ofNullable(this.runtimeProperties.get(QUARKUS_HTTP_PORT_PROPERTY)).map(Integer::parseInt).orElse(8081);
        if (httpPort == 0) {
            httpPort = null;
        }
        RestAssuredURLManager.setURL((boolean)false, (Integer)httpPort);
    }

    private void ensureApplicationStartupOrFailure() throws IOException {
        StringBuilder sb;
        BufferedReader in;
        block4: {
            String line;
            in = new BufferedReader(new InputStreamReader(this.process.getInputStream(), StandardCharsets.UTF_8));
            sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                System.out.println(line);
                sb.append(line);
                sb.append("\n");
                if (this.expectExit || !line.contains(EXPECTED_OUTPUT_FROM_SUCCESSFULLY_STARTED)) continue;
                break block4;
            }
            this.startupConsoleOutput = sb.toString();
            in.close();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.exitCode = this.process.exitValue();
            if (this.expectExit) {
                return;
            }
            throw new RuntimeException("The produced jar could not be launched. Consult the above output for the exact cause.");
        }
        in.close();
        this.startupConsoleOutput = sb.toString();
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.doIntercept(invocation);
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.doIntercept(invocation);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.doIntercept(invocation);
    }

    private void doIntercept(InvocationInterceptor.Invocation<Void> invocation) throws Throwable {
        if (this.assertBuildException != null) {
            invocation.skip();
        } else {
            invocation.proceed();
        }
    }

    public void testFailed(ExtensionContext context, Throwable cause) {
        this.preventOutputDirCleanup = true;
        this.logOutputPathForPostMortem();
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        rootLogger.setHandlers(this.originalHandlers);
        this.inMemoryLogHandler.clearRecords();
        if (this.run) {
            RestAssuredURLManager.clearURL();
        }
        this.stop();
        try {
            if (this.curatedApplication != null) {
                this.curatedApplication.close();
                this.curatedApplication = null;
            }
        }
        finally {
            this.timeoutTask.cancel();
            this.timeoutTask = null;
            if (!this.buildChainCustomizerEntries.isEmpty()) {
                this.buildChainCustomizerEntries.clear();
                this.buildChainCustomizerEntries = null;
            }
            if (this.outputDir != null && !this.preventOutputDirCleanup) {
                FileUtil.deleteDirectory((Path)this.outputDir);
            }
        }
    }

    public void beforeEach(ExtensionContext context) {
        if (this.run && (this.process == null || !this.process.isAlive())) {
            this.start();
        }
        this.prodModeTestResultsField.ifPresent(f -> {
            try {
                f.set(context.getRequiredTestInstance(), this.prodModeTestResults);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        this.logfileField.ifPresent(f -> {
            try {
                f.set(context.getRequiredTestInstance(), this.logfilePath);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public QuarkusProdModeTest withConfigurationResource(String resourceName) {
        if (this.customApplicationProperties == null) {
            this.customApplicationProperties = new Properties();
        }
        try {
            try (InputStream in = ClassLoader.getSystemResourceAsStream(resourceName);){
                this.customApplicationProperties.load(in);
            }
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load resource: '" + resourceName + "'");
        }
    }

    public QuarkusProdModeTest overrideConfigKey(String propertyKey, String propertyValue) {
        if (this.customApplicationProperties == null) {
            this.customApplicationProperties = new Properties();
        }
        this.customApplicationProperties.put(propertyKey, propertyValue);
        return this;
    }

    public QuarkusProdModeTest setCommandLineParameters(String ... commandLineParameters) {
        this.commandLineParameters = commandLineParameters;
        return this;
    }

    static {
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        rootLogger = (Logger)LogManager.getLogManager().getLogger("");
        timeoutTimer = new Timer("Test thread dump timer");
    }

    public static class BuildChainCustomizerEntry {
        private final Class<? extends ProdModeTestBuildStep> buildStepClass;
        private final List<Class<? extends BuildItem>> produces;
        private final List<Class<? extends BuildItem>> consumes;

        public BuildChainCustomizerEntry(Class<? extends ProdModeTestBuildStep> buildStepClass, List<Class<? extends BuildItem>> produces, List<Class<? extends BuildItem>> consumes) {
            this.buildStepClass = Objects.requireNonNull(buildStepClass);
            this.produces = produces == null ? Collections.emptyList() : produces;
            this.consumes = consumes == null ? Collections.emptyList() : consumes;
        }

        public Class<? extends BuildStep> getBuildStepClass() {
            return this.buildStepClass;
        }

        public List<Class<? extends BuildItem>> getProduces() {
            return this.produces;
        }

        public List<Class<? extends BuildItem>> getConsumes() {
            return this.consumes;
        }
    }

    private static class PrintStackTraceTimerTask
    extends TimerTask {
        private PrintStackTraceTimerTask() {
        }

        @Override
        public void run() {
            System.err.println("Test has been running for more than 5 minutes, thread dump is:");
            for (Map.Entry<Thread, StackTraceElement[]> i : Thread.getAllStackTraces().entrySet()) {
                System.err.println("\n");
                System.err.println(i.toString());
                System.err.println("\n");
                for (StackTraceElement j : i.getValue()) {
                    System.err.println(j);
                }
            }
        }
    }
}

