/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test;

import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.bootstrap.classloading.ClassLoaderEventListener;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.runner.bootstrap.AugmentActionImpl;
import io.quarkus.runner.bootstrap.StartupActionImpl;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.test.ClearCache;
import io.quarkus.test.ExclusivityChecker;
import io.quarkus.test.ExportUtil;
import io.quarkus.test.InMemoryLogHandler;
import io.quarkus.test.PropertiesAsset;
import io.quarkus.test.TestMethodInvoker;
import io.quarkus.test.common.GroovyCacheCleaner;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.jboss.logmanager.Logger;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.extension.TestInstantiationException;

public class QuarkusUnitTest
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
InvocationInterceptor,
ParameterResolver {
    public static final String THE_BUILD_WAS_EXPECTED_TO_FAIL = "The build was expected to fail";
    private static final String APP_ROOT = "app-root";
    private static final Logger rootLogger;
    private Handler[] originalHandlers;
    boolean started = false;
    private Path deploymentDir;
    private Consumer<Throwable> assertException;
    private Supplier<JavaArchive> archiveProducer;
    private List<JavaArchive> additionalDependencies = new ArrayList<JavaArchive>();
    private List<Consumer<BuildChainBuilder>> buildChainCustomizers = new ArrayList<Consumer<BuildChainBuilder>>();
    private Runnable afterUndeployListener;
    private String logFileName;
    private InMemoryLogHandler inMemoryLogHandler = new InMemoryLogHandler(r -> false);
    private Consumer<List<LogRecord>> assertLogRecords;
    private Timer timeoutTimer;
    private volatile TimerTask timeoutTask;
    private Properties customApplicationProperties;
    private Runnable beforeAllCustomizer;
    private Runnable afterAllCustomizer;
    private CuratedApplication curatedApplication;
    private RunningQuarkusApplication runningQuarkusApplication;
    private ClassLoader originalClassLoader;
    private List<Dependency> forcedDependencies = Collections.emptyList();
    private boolean useSecureConnection;
    private Class<?> actualTestClass;
    private Object actualTestInstance;
    private String[] commandLineParameters = new String[0];
    private boolean allowTestClassOutsideDeployment;
    private boolean flatClassPath;
    private List<ClassLoaderEventListener> classLoadListeners = new ArrayList<ClassLoaderEventListener>();
    private List<Object> testMethodInvokers;

    public QuarkusUnitTest setExpectedException(Class<? extends Throwable> expectedException) {
        return this.setExpectedException(expectedException, false);
    }

    public QuarkusUnitTest setExpectedException(Class<? extends Throwable> expectedException, boolean logMessage) {
        return this.assertException(t -> {
            Throwable i;
            boolean found = false;
            for (i = t; i != null; i = i.getCause()) {
                if (!i.getClass().getName().equals(expectedException.getName())) continue;
                found = true;
                break;
            }
            if (found && logMessage) {
                System.out.println("Build failed with the expected exception:" + i);
            }
            Assertions.assertTrue((boolean)found, (String)("Build failed with a wrong exception, expected " + expectedException + " but got " + t));
        });
    }

    public QuarkusUnitTest() {
        this(false);
    }

    public static QuarkusUnitTest withSecuredConnection() {
        return new QuarkusUnitTest(true);
    }

    private QuarkusUnitTest(boolean useSecureConnection) {
        this.useSecureConnection = useSecureConnection;
    }

    public QuarkusUnitTest assertException(Consumer<Throwable> assertException) {
        if (this.assertException != null) {
            throw new IllegalStateException("Don't set the asserted or excepted exception twice to avoid shadowing out the first call.");
        }
        this.assertException = assertException;
        return this;
    }

    public Supplier<JavaArchive> getArchiveProducer() {
        return this.archiveProducer;
    }

    public QuarkusUnitTest setArchiveProducer(Supplier<JavaArchive> archiveProducer) {
        this.archiveProducer = Objects.requireNonNull(archiveProducer);
        return this;
    }

    public QuarkusUnitTest withApplicationRoot(Consumer<JavaArchive> applicationRootConsumer) {
        Objects.requireNonNull(applicationRootConsumer);
        return this.setArchiveProducer(() -> {
            JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
            applicationRootConsumer.accept(jar);
            return jar;
        });
    }

    public QuarkusUnitTest withEmptyApplication() {
        return this.withApplicationRoot(new Consumer<JavaArchive>(){

            @Override
            public void accept(JavaArchive javaArchive) {
            }
        });
    }

    public QuarkusUnitTest addAdditionalDependency(JavaArchive archive) {
        this.additionalDependencies.add(Objects.requireNonNull(archive));
        return this;
    }

    public QuarkusUnitTest withAdditionalDependency(Consumer<JavaArchive> dependencyConsumer) {
        JavaArchive dependency = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        Objects.requireNonNull(dependencyConsumer).accept(dependency);
        return this.addAdditionalDependency(dependency);
    }

    public QuarkusUnitTest addBuildChainCustomizer(Consumer<BuildChainBuilder> customizer) {
        this.buildChainCustomizers.add(customizer);
        return this;
    }

    public QuarkusUnitTest addClassLoaderEventListener(ClassLoaderEventListener listener) {
        this.classLoadListeners.add(listener);
        return this;
    }

    public QuarkusUnitTest setLogFileName(String logFileName) {
        this.logFileName = logFileName;
        return this;
    }

    public QuarkusUnitTest setLogRecordPredicate(Predicate<LogRecord> predicate) {
        this.inMemoryLogHandler = new InMemoryLogHandler(predicate);
        return this;
    }

    public QuarkusUnitTest setFlatClassPath(boolean flatClassPath) {
        this.flatClassPath = flatClassPath;
        return this;
    }

    public QuarkusUnitTest assertLogRecords(Consumer<List<LogRecord>> assertLogRecords) {
        if (this.assertLogRecords != null) {
            throw new IllegalStateException("Don't set the a log record assertion twice to avoid shadowing out the first call.");
        }
        this.assertLogRecords = assertLogRecords;
        return this;
    }

    public QuarkusUnitTest setBeforeAllCustomizer(Runnable beforeAllCustomizer) {
        this.beforeAllCustomizer = beforeAllCustomizer;
        return this;
    }

    public QuarkusUnitTest setAfterAllCustomizer(Runnable afterAllCustomizer) {
        this.afterAllCustomizer = afterAllCustomizer;
        return this;
    }

    public QuarkusUnitTest setForcedDependencies(List<Dependency> forcedDependencies) {
        this.forcedDependencies = forcedDependencies;
        return this;
    }

    public String[] getCommandLineParameters() {
        return this.commandLineParameters;
    }

    public QuarkusUnitTest setCommandLineParameters(String ... commandLineParameters) {
        this.commandLineParameters = commandLineParameters;
        return this;
    }

    public QuarkusUnitTest setAllowTestClassOutsideDeployment(boolean allowTestClassOutsideDeployment) {
        this.allowTestClassOutsideDeployment = allowTestClassOutsideDeployment;
        return this;
    }

    private void exportArchives(Path deploymentDir, Class<?> testClass) {
        try {
            Class<?> c;
            JavaArchive archive = this.getArchiveProducerOrDefault();
            archive.addClasses((Class[])c.getClasses());
            for (c = testClass; c != Object.class; c = c.getSuperclass()) {
                archive.addClass(c);
            }
            if (this.customApplicationProperties != null) {
                archive.add((Asset)new PropertiesAsset(this.customApplicationProperties), "application.properties");
            }
            ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExplodedInto(deploymentDir.resolve(APP_ROOT).toFile());
            for (JavaArchive dependency : this.additionalDependencies) {
                ((ExplodedExporter)dependency.as(ExplodedExporter.class)).exportExplodedInto(deploymentDir.resolve(dependency.getName()).toFile());
            }
            ExportUtil.exportToQuarkusDeploymentPath(archive);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create the archive", e);
        }
    }

    private JavaArchive getArchiveProducerOrDefault() {
        if (this.archiveProducer == null) {
            return (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        }
        return this.archiveProducer.get();
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.runExtensionMethod(invocationContext, extensionContext, false);
        invocation.skip();
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.runExtensionMethod(invocationContext, extensionContext, true);
        invocation.skip();
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.assertException == null) {
            this.runExtensionMethod(invocationContext, extensionContext, true);
            invocation.skip();
        } else {
            invocation.proceed();
        }
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.assertException == null) {
            this.runExtensionMethod(invocationContext, extensionContext, false);
        }
        invocation.skip();
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.assertException == null) {
            this.runExtensionMethod(invocationContext, extensionContext, true);
        }
        invocation.skip();
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.assertException == null) {
            this.runExtensionMethod(invocationContext, extensionContext, false);
        }
        invocation.skip();
    }

    private void runExtensionMethod(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, boolean testMethodInvokersAllowed) throws Throwable {
        Object newMethod = null;
        block3: for (Class<?> c = this.actualTestClass; c != Object.class && newMethod == null; c = c.getSuperclass()) {
            Method[] declaredMethods = c.getDeclaredMethods();
            for (Method declaredMethod : declaredMethods) {
                if (!declaredMethod.getName().equals(((Method)invocationContext.getExecutable()).getName())) continue;
                boolean parametersMatch = true;
                for (Class<?> declaredMethodParameterType : declaredMethod.getParameterTypes()) {
                    boolean parameterTypeFound = false;
                    for (Class<?> executionContextParameterType : ((Method)invocationContext.getExecutable()).getParameterTypes()) {
                        if (!declaredMethodParameterType.getName().equals(executionContextParameterType.getName())) continue;
                        parameterTypeFound = true;
                        break;
                    }
                    if (parameterTypeFound) continue;
                    parametersMatch = false;
                    break;
                }
                if (!parametersMatch) continue;
                newMethod = declaredMethod;
                continue block3;
            }
        }
        if (newMethod == null) {
            throw new RuntimeException("Could not find method " + invocationContext.getExecutable() + " on test class");
        }
        Object testMethodInvokerToUse = null;
        if (testMethodInvokersAllowed) {
            for (Object e : this.testMethodInvokers) {
                boolean supportsMethod = (Boolean)e.getClass().getMethod("supportsMethod", Class.class, Method.class).invoke(e, extensionContext.getRequiredTestClass(), invocationContext.getExecutable());
                if (!supportsMethod) continue;
                testMethodInvokerToUse = e;
                break;
            }
        }
        try {
            ((Method)newMethod).setAccessible(true);
            if (testMethodInvokerToUse != null) {
                ArrayList<Object> effectiveArguments = new ArrayList<Object>(invocationContext.getArguments().size());
                Class<?>[] classArray = ((Method)newMethod).getParameterTypes();
                if (classArray.length != invocationContext.getArguments().size()) {
                    throw new IllegalStateException("Improper integration of '" + testMethodInvokerToUse.getClass() + "' detected");
                }
                for (int i = 0; i < invocationContext.getArguments().size(); ++i) {
                    Object originalValue = invocationContext.getArguments().get(i);
                    if (originalValue == null && this.testMethodInvokerHandlesParamType(testMethodInvokerToUse, classArray[i].getName())) {
                        effectiveArguments.add(this.testMethodInvokerParamInstance(testMethodInvokerToUse, classArray[i].getName()));
                        continue;
                    }
                    effectiveArguments.add(originalValue);
                }
                testMethodInvokerToUse.getClass().getMethod("invoke", Object.class, Method.class, List.class, String.class).invoke(testMethodInvokerToUse, this.actualTestInstance, newMethod, effectiveArguments, extensionContext.getRequiredTestClass().getName());
            } else {
                ((Method)newMethod).invoke(this.actualTestInstance, invocationContext.getArguments().toArray());
            }
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        block24: {
            ProfileManager.setLaunchMode((LaunchMode)LaunchMode.TEST);
            if (this.beforeAllCustomizer != null) {
                this.beforeAllCustomizer.run();
            }
            this.originalClassLoader = Thread.currentThread().getContextClassLoader();
            this.originalHandlers = rootLogger.getHandlers();
            rootLogger.addHandler((Handler)this.inMemoryLogHandler);
            this.timeoutTask = new TimerTask(){

                @Override
                public void run() {
                    System.err.println("Test has been running for more than 5 minutes, thread dump is:");
                    for (Map.Entry<Thread, StackTraceElement[]> i : Thread.getAllStackTraces().entrySet()) {
                        System.err.println("\n");
                        System.err.println(i.toString());
                        System.err.println("\n");
                        for (StackTraceElement j : i.getValue()) {
                            System.err.println(j);
                        }
                    }
                }
            };
            this.timeoutTimer = new Timer("Test thread dump timer");
            this.timeoutTimer.schedule(this.timeoutTask, 300000L);
            if (this.logFileName != null) {
                PropertyTestUtil.setLogFileProperty((String)this.logFileName);
            } else {
                PropertyTestUtil.setLogFileProperty();
            }
            ExtensionContext.Store store = extensionContext.getRoot().getStore(ExtensionContext.Namespace.GLOBAL);
            ExclusivityChecker.checkTestType(extensionContext, QuarkusUnitTest.class);
            TestResourceManager testResourceManager = (TestResourceManager)store.get((Object)TestResourceManager.class.getName());
            if (testResourceManager == null) {
                testResourceManager = new TestResourceManager(extensionContext.getRequiredTestClass());
                testResourceManager.init(null);
                testResourceManager.start();
                final TestResourceManager tm = testResourceManager;
                store.put((Object)TestResourceManager.class.getName(), (Object)testResourceManager);
                store.put((Object)TestResourceManager.CLOSEABLE_NAME, (Object)new ExtensionContext.Store.CloseableResource(){

                    public void close() throws Throwable {
                        tm.close();
                    }
                });
            }
            final Class testClass = extensionContext.getRequiredTestClass();
            try {
                this.deploymentDir = Files.createTempDirectory("quarkus-unit-test", new FileAttribute[0]);
                this.exportArchives(this.deploymentDir, testClass);
                ArrayList<Consumer<BuildChainBuilder>> customizers = new ArrayList<Consumer<BuildChainBuilder>>(this.buildChainCustomizers);
                try {
                    final Class<BuildItem> buildItem = Class.forName("io.quarkus.arc.deployment.AdditionalBeanBuildItem").asSubclass(BuildItem.class);
                    customizers.add(new Consumer<BuildChainBuilder>(){

                        @Override
                        public void accept(BuildChainBuilder buildChainBuilder) {
                            buildChainBuilder.addBuildStep(new BuildStep(){

                                public void execute(BuildContext context) {
                                    try {
                                        Method factoryMethod = buildItem.getMethod("unremovableOf", Class.class);
                                        context.produce((BuildItem)factoryMethod.invoke(null, testClass));
                                    }
                                    catch (Exception e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            }).produces(buildItem).build();
                            buildChainBuilder.addBuildStep(new BuildStep(){

                                public void execute(BuildContext context) {
                                    context.produce((BuildItem)new ApplicationClassPredicateBuildItem((Predicate)new Predicate<String>(){

                                        @Override
                                        public boolean test(String s) {
                                            QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
                                            List res = cl.getElementsWithResource(s.replace(".", "/") + ".class", true);
                                            return !res.isEmpty();
                                        }
                                    }));
                                }
                            }).produces(ApplicationClassPredicateBuildItem.class).build();
                        }
                    });
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Couldn't make the test class " + testClass.getSimpleName() + " an unremovable bean (probably because a dependency on io.quarkus:quarkus-arc-deployment is missing); other beans may also be removed and injection may not work as expected");
                }
                Path testLocation = PathTestHelper.getTestClassesLocation((Class)testClass);
                try {
                    QuarkusBootstrap.Builder builder = QuarkusBootstrap.builder().setApplicationRoot(this.deploymentDir.resolve(APP_ROOT)).setMode(QuarkusBootstrap.Mode.TEST).addExcludedPath(testLocation).setProjectRoot(testLocation).setTargetDirectory(PathTestHelper.getProjectBuildDir((Path)Paths.get("", new String[0]).normalize().toAbsolutePath(), (Path)testLocation)).setFlatClassPath(this.flatClassPath).setForcedDependencies(this.forcedDependencies);
                    for (JavaArchive dependency : this.additionalDependencies) {
                        builder.addAdditionalApplicationArchive(new AdditionalDependency(this.deploymentDir.resolve(dependency.getName()), false, true));
                    }
                    if (!this.forcedDependencies.isEmpty()) {
                        builder.setDisableClasspathCache(true);
                    }
                    if (!this.allowTestClassOutsideDeployment) {
                        builder.setBaseClassLoader((ClassLoader)QuarkusClassLoader.builder((String)"QuarkusUnitTest ClassLoader", (ClassLoader)this.getClass().getClassLoader(), (boolean)false).addClassLoaderEventListeners(this.classLoadListeners).addBannedElement(ClassPathElement.fromPath((Path)testLocation, (boolean)true)).build());
                    }
                    builder.addClassLoaderEventListeners(this.classLoadListeners);
                    this.curatedApplication = builder.build().bootstrap();
                    StartupActionImpl startupAction = new AugmentActionImpl(this.curatedApplication, customizers, this.classLoadListeners).createInitialRuntimeApplication();
                    startupAction.overrideConfig(testResourceManager.getConfigProperties());
                    this.runningQuarkusApplication = startupAction.run(this.commandLineParameters);
                    Thread.currentThread().setContextClassLoader(this.runningQuarkusApplication.getClassLoader());
                    if (this.assertException != null) {
                        Assertions.fail((String)THE_BUILD_WAS_EXPECTED_TO_FAIL);
                    }
                    this.started = true;
                    System.setProperty("test.url", TestHTTPResourceManager.getUri((RunningQuarkusApplication)this.runningQuarkusApplication));
                    try {
                        this.actualTestClass = Class.forName(testClass.getName(), true, Thread.currentThread().getContextClassLoader());
                        this.actualTestInstance = this.runningQuarkusApplication.instance(this.actualTestClass, new Annotation[0]);
                        Class<?> resM = this.runningQuarkusApplication.getClassLoader().loadClass(TestHTTPResourceManager.class.getName());
                        resM.getDeclaredMethod("inject", Object.class).invoke(null, this.actualTestInstance);
                        this.populateTestMethodInvokers(startupAction.getClassLoader());
                    }
                    catch (Exception e) {
                        throw new TestInstantiationException("Failed to create test instance", (Throwable)e);
                    }
                    extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).put((Object)testClass.getName(), this.actualTestInstance);
                }
                catch (Throwable e) {
                    this.started = false;
                    if (this.assertException != null) {
                        if (e instanceof AssertionError && e.getMessage().equals(THE_BUILD_WAS_EXPECTED_TO_FAIL)) {
                            throw e;
                        }
                        if (e instanceof RuntimeException) {
                            Throwable cause = e.getCause();
                            if (cause != null && cause instanceof BuildException) {
                                this.assertException.accept(this.unwrapException(cause.getCause()));
                            } else if (cause != null) {
                                this.assertException.accept(this.unwrapException(cause));
                            } else {
                                this.assertException.accept(e);
                            }
                        } else {
                            this.assertException.accept(e);
                        }
                        break block24;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Throwable unwrapException(Throwable cause) {
        try {
            Class<?> localVer = QuarkusUnitTest.class.getClassLoader().loadClass(cause.getClass().getName());
            if (localVer != cause.getClass()) {
                Constructor<?> ctor = localVer.getConstructor(String.class, Throwable.class);
                return (Throwable)ctor.newInstance(cause.getMessage(), cause.getCause());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cause;
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.actualTestClass = null;
        this.actualTestInstance = null;
        ArrayList<LogRecord> records = null;
        if (this.assertLogRecords != null) {
            records = new ArrayList<LogRecord>(this.inMemoryLogHandler.records);
        }
        rootLogger.setHandlers(this.originalHandlers);
        this.inMemoryLogHandler.clearRecords();
        this.inMemoryLogHandler.setFilter(null);
        try {
            if (this.runningQuarkusApplication != null) {
                this.runningQuarkusApplication.close();
                this.runningQuarkusApplication = null;
            }
            if (this.afterUndeployListener != null) {
                this.afterUndeployListener.run();
            }
            if (this.curatedApplication != null) {
                this.curatedApplication.close();
                this.curatedApplication = null;
            }
        }
        finally {
            System.clearProperty("test.url");
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
            this.originalClassLoader = null;
            this.timeoutTask.cancel();
            this.timeoutTask = null;
            this.timeoutTimer.cancel();
            this.timeoutTimer = null;
            if (this.deploymentDir != null) {
                FileUtil.deleteDirectory((Path)this.deploymentDir);
            }
            if (this.afterAllCustomizer != null) {
                this.afterAllCustomizer.run();
            }
            ClearCache.clearAnnotationCache();
            GroovyCacheCleaner.clearGroovyCache();
        }
        if (records != null) {
            this.assertLogRecords.accept(records);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (this.runningQuarkusApplication != null) {
            this.runningQuarkusApplication.getClassLoader().loadClass(RestAssuredURLManager.class.getName()).getDeclaredMethod("clearURL", new Class[0]).invoke(null, new Object[0]);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.assertException != null) {
            return;
        }
        if (this.runningQuarkusApplication == null) {
            Field extensionField;
            Optional testClass = context.getTestClass();
            if (testClass.isPresent() && (extensionField = (Field)Arrays.stream(((Class)testClass.get()).getDeclaredFields()).filter(f -> f.isAnnotationPresent(RegisterExtension.class) && QuarkusUnitTest.class.equals(f.getType())).findAny().orElse(null)) != null && !Modifier.isStatic(extensionField.getModifiers())) {
                throw new IllegalStateException("Test application not started - QuarkusUnitTest must be used with a static field: " + extensionField);
            }
            throw new IllegalStateException("Test application not started for an unknown reason");
        }
        this.runningQuarkusApplication.getClassLoader().loadClass(RestAssuredURLManager.class.getName()).getDeclaredMethod("setURL", Boolean.TYPE).invoke(null, this.useSecureConnection);
    }

    public Runnable getAfterUndeployListener() {
        return this.afterUndeployListener;
    }

    public QuarkusUnitTest setAfterUndeployListener(Runnable afterUndeployListener) {
        this.afterUndeployListener = afterUndeployListener;
        return this;
    }

    public QuarkusUnitTest withConfigurationResource(String resourceName) {
        if (this.customApplicationProperties == null) {
            this.customApplicationProperties = new Properties();
        }
        try {
            URL systemResource = ClassLoader.getSystemResource(resourceName);
            if (systemResource == null) {
                throw new FileNotFoundException("Resource '" + resourceName + "' not found");
            }
            try (InputStream in = systemResource.openStream();){
                this.customApplicationProperties.load(in);
            }
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not load resource: '" + resourceName + "'", e);
        }
    }

    public QuarkusUnitTest overrideConfigKey(String propertyKey, String propertyValue) {
        if (this.customApplicationProperties == null) {
            this.customApplicationProperties = new Properties();
        }
        this.customApplicationProperties.put(propertyKey, propertyValue);
        return this;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        boolean isConstructor = parameterContext.getDeclaringExecutable() instanceof Constructor;
        if (isConstructor) {
            return true;
        }
        if (!(parameterContext.getDeclaringExecutable() instanceof Method)) {
            return false;
        }
        if (this.testMethodInvokers == null) {
            return false;
        }
        for (Object testMethodInvoker : this.testMethodInvokers) {
            boolean handlesMethodParamType = this.testMethodInvokerHandlesParamType(testMethodInvoker, parameterContext.getParameter().getType().getName());
            if (!handlesMethodParamType) continue;
            return true;
        }
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        String className;
        if (parameterContext.getDeclaringExecutable() instanceof Method && this.testMethodInvokers != null) {
            for (Object testMethodInvoker : this.testMethodInvokers) {
                if (!this.testMethodInvokerHandlesParamType(testMethodInvoker, parameterContext.getParameter().getType().getName())) continue;
                return null;
            }
        }
        switch (className = parameterContext.getParameter().getType().getName()) {
            case "boolean": {
                return false;
            }
            case "byte": 
            case "short": 
            case "int": {
                return 0;
            }
            case "long": {
                return 0L;
            }
            case "float": {
                return Float.valueOf(0.0f);
            }
            case "double": {
                return 0.0;
            }
            case "char": {
                return Character.valueOf('\u0000');
            }
        }
        return null;
    }

    private boolean testMethodInvokerHandlesParamType(Object testMethodInvoker, String parameterTypeName) {
        try {
            return (Boolean)testMethodInvoker.getClass().getMethod("handlesMethodParamType", String.class).invoke(testMethodInvoker, parameterTypeName);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to determine if TestMethodInvoker supports parameter", e);
        }
    }

    private Object testMethodInvokerParamInstance(Object testMethodInvoker, String parameterTypeName) {
        try {
            return testMethodInvoker.getClass().getMethod("methodParamInstance", String.class).invoke(testMethodInvoker, parameterTypeName);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to obtain instance of parameter using TestMethodInvoker", e);
        }
    }

    private void populateTestMethodInvokers(ClassLoader quarkusClassLoader) {
        this.testMethodInvokers = new ArrayList<Object>();
        try {
            ServiceLoader<?> loader = ServiceLoader.load(quarkusClassLoader.loadClass(TestMethodInvoker.class.getName()), quarkusClassLoader);
            for (Object testMethodInvoker : loader) {
                this.testMethodInvokers.add(testMethodInvoker);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        rootLogger = (Logger)LogManager.getLogManager().getLogger("");
    }
}

