/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.component;

import io.quarkus.arc.DefaultBean;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.arc.impl.HierarchyDiscovery;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.Types;
import io.quarkus.test.component.MockBeanConfigurator;
import io.quarkus.test.component.QuarkusComponentTestExtension;
import io.quarkus.test.component.QuarkusComponentTestExtensionBuilder;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Alternative;
import jakarta.enterprise.inject.Default;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.mockito.Mockito;

class MockBeanConfiguratorImpl<T>
implements MockBeanConfigurator<T> {
    final QuarkusComponentTestExtensionBuilder builder;
    final Class<?> beanClass;
    Set<Type> types;
    Set<Annotation> qualifiers;
    Class<? extends Annotation> scope;
    boolean alternative = false;
    Integer priority;
    String name;
    boolean defaultBean = false;
    Function<SyntheticCreationalContext<T>, T> create;
    Set<org.jboss.jandex.Type> jandexTypes;
    Set<AnnotationInstance> jandexQualifiers;

    public MockBeanConfiguratorImpl(QuarkusComponentTestExtensionBuilder builder, Class<?> beanClass) {
        Priority priority;
        Named named;
        this.builder = builder;
        this.beanClass = beanClass;
        this.types = new HierarchyDiscovery(beanClass).getTypeClosure();
        this.scope = beanClass.isAnnotationPresent(Singleton.class) ? Singleton.class : (beanClass.isAnnotationPresent(ApplicationScoped.class) ? ApplicationScoped.class : (beanClass.isAnnotationPresent(RequestScoped.class) ? RequestScoped.class : Dependent.class));
        this.qualifiers = new HashSet<Annotation>();
        for (Annotation annotation : beanClass.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            this.qualifiers.add(annotation);
        }
        if (this.qualifiers.isEmpty()) {
            this.qualifiers.add((Annotation)Default.Literal.INSTANCE);
        }
        if (beanClass.isAnnotationPresent(Alternative.class)) {
            this.alternative = true;
        }
        if ((named = beanClass.getAnnotation(Named.class)) != null) {
            String val = named.value();
            if (!val.isBlank()) {
                this.name = val;
            } else {
                StringBuilder defaultName = new StringBuilder();
                defaultName.append(beanClass.getSimpleName());
                defaultName.setCharAt(0, Character.toLowerCase(defaultName.charAt(0)));
                this.name = defaultName.toString();
            }
        }
        if ((priority = beanClass.getAnnotation(Priority.class)) != null) {
            this.priority = priority.value();
        }
        if (beanClass.isAnnotationPresent(DefaultBean.class)) {
            this.defaultBean = true;
        }
    }

    @Override
    public MockBeanConfigurator<T> types(Class<?> ... types) {
        this.types = Set.of(types);
        return this;
    }

    @Override
    public MockBeanConfigurator<T> types(Type types) {
        this.types = Set.of(types);
        return this;
    }

    @Override
    public MockBeanConfigurator<T> qualifiers(Annotation ... qualifiers) {
        this.qualifiers = Set.of(qualifiers);
        return this;
    }

    @Override
    public MockBeanConfigurator<T> scope(Class<? extends Annotation> scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public MockBeanConfigurator<T> name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public MockBeanConfigurator<T> alternative(boolean alternative) {
        this.alternative = alternative;
        return this;
    }

    @Override
    public MockBeanConfigurator<T> priority(int priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public MockBeanConfigurator<T> defaultBean(boolean defaultBean) {
        this.defaultBean = defaultBean;
        return this;
    }

    @Override
    public QuarkusComponentTestExtensionBuilder create(Function<SyntheticCreationalContext<T>, T> create) {
        this.create = create;
        return this.register();
    }

    @Override
    public QuarkusComponentTestExtensionBuilder createMockitoMock() {
        this.create = c -> QuarkusComponentTestExtension.cast(Mockito.mock(this.beanClass));
        return this.register();
    }

    @Override
    public QuarkusComponentTestExtensionBuilder createMockitoMock(Consumer<T> mockInitializer) {
        this.create = c -> {
            Object mock = QuarkusComponentTestExtension.cast(Mockito.mock(this.beanClass));
            mockInitializer.accept(mock);
            return mock;
        };
        return this.register();
    }

    public QuarkusComponentTestExtensionBuilder register() {
        this.builder.registerMockBean(this);
        return this.builder;
    }

    boolean matches(BeanResolver beanResolver, org.jboss.jandex.Type requiredType, Set<AnnotationInstance> qualifiers) {
        return this.matchesType(requiredType, beanResolver) && this.hasQualifiers(qualifiers, beanResolver);
    }

    boolean matchesType(org.jboss.jandex.Type requiredType, BeanResolver beanResolver) {
        for (org.jboss.jandex.Type beanType : this.jandexTypes()) {
            if (!beanResolver.matches(requiredType, beanType)) continue;
            return true;
        }
        return false;
    }

    boolean hasQualifiers(Set<AnnotationInstance> requiredQualifiers, BeanResolver beanResolver) {
        for (AnnotationInstance qualifier : requiredQualifiers) {
            if (beanResolver.hasQualifier(this.jandexQualifiers(), qualifier)) continue;
            return false;
        }
        return true;
    }

    Set<org.jboss.jandex.Type> jandexTypes() {
        if (this.jandexTypes == null) {
            this.jandexTypes = new HashSet<org.jboss.jandex.Type>();
            for (Type type : this.types) {
                this.jandexTypes.add(Types.jandexType((Type)type));
            }
        }
        return this.jandexTypes;
    }

    Set<AnnotationInstance> jandexQualifiers() {
        if (this.jandexQualifiers == null) {
            this.jandexQualifiers = new HashSet<AnnotationInstance>();
            for (Annotation qualifier : this.qualifiers) {
                this.jandexQualifiers.add(Annotations.jandexAnnotation((Annotation)qualifier));
            }
        }
        return this.jandexQualifiers;
    }
}

