/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.db2.deployment;

import com.ibm.db2.jcc.resources.ResourceKeys;
import com.ibm.db2.jcc.resources.Resources;
import com.ibm.db2.jcc.resources.SqljResources;
import com.ibm.db2.jcc.resources.T2uResourceKeys;
import com.ibm.db2.jcc.resources.T2uResources;
import com.ibm.db2.jcc.resources.T2zResourceKeys;
import com.ibm.db2.jcc.resources.T2zResources;
import com.ibm.db2.jcc.resources.T4ResourceKeys;
import com.ibm.db2.jcc.resources.T4Resources;
import io.quarkus.agroal.spi.JdbcDriverBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceConfigurationHandlerBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.NativeImageEnableAllCharsetsBuildItem;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JPMSExportBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.jdbc.db2.runtime.DB2AgroalConnectionConfigurer;
import io.quarkus.jdbc.db2.runtime.DB2ServiceBindingConverter;
import java.util.ListResourceBundle;
import java.util.ResourceBundle;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class JDBCDB2Processor {
    private static final String DB2_DRIVER_CLASS = "com.ibm.db2.jcc.DB2Driver";
    private static final DotName RESOURCE_BUNDLE_DOT_NAME = DotName.createSimple(ResourceBundle.class);
    private static final DotName LIST_RESOURCE_BUNDLE_DOT_NAME = DotName.createSimple(ListResourceBundle.class);
    private static final String DB2_DRIVER_ROOT_PACKAGE = "com.ibm.db2";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.JDBC_DB2);
    }

    @BuildStep
    void indexDriver(BuildProducer<IndexDependencyBuildItem> indexDependencies, BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexedClasses) {
        indexDependencies.produce((BuildItem)new IndexDependencyBuildItem(DB2_DRIVER_ROOT_PACKAGE, "jcc"));
        additionalIndexedClasses.produce((BuildItem)new AdditionalIndexedClassesBuildItem(new String[]{RESOURCE_BUNDLE_DOT_NAME.toString(), LIST_RESOURCE_BUNDLE_DOT_NAME.toString()}));
    }

    @BuildStep
    void registerDriver(BuildProducer<JdbcDriverBuildItem> jdbcDriver, SslNativeConfigBuildItem sslNativeConfigBuildItem) {
        jdbcDriver.produce((BuildItem)new JdbcDriverBuildItem("db2", DB2_DRIVER_CLASS, "com.ibm.db2.jcc.DB2XADataSource"));
    }

    @BuildStep
    DevServicesDatasourceConfigurationHandlerBuildItem devDbHandler() {
        return DevServicesDatasourceConfigurationHandlerBuildItem.jdbc((String)"db2");
    }

    @BuildStep
    void configureAgroalConnection(BuildProducer<AdditionalBeanBuildItem> additionalBeans, Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.agroal")) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem.Builder().addBeanClass(DB2AgroalConnectionConfigurer.class).setDefaultScope(BuiltinScope.APPLICATION.getName()).setUnremovable().build());
        }
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{DB2_DRIVER_CLASS}).reason(this.getClass().getName() + " DB2 JDBC driver classes").build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{Resources.class, ResourceKeys.class, SqljResources.class, T2uResourceKeys.class, T2uResources.class, T2zResourceKeys.class, T2zResources.class, T4ResourceKeys.class, T4Resources.class}).reason(this.getClass().getName() + " DB2 JDBC driver classes").build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.ibm.pdq.cmx.client.DataSourceFactory"}).reason(this.getClass().getName() + " accessed reflectively by Db2 JDBC driver").build());
    }

    @BuildStep
    void registerResources(CombinedIndexBuildItem index, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundle) {
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"pdq.properties"}));
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"com/ibm/db2/cmx/runtime/internal/resources/messages.properties"}));
        for (ClassInfo bundle : index.getIndex().getAllKnownSubclasses(RESOURCE_BUNDLE_DOT_NAME)) {
            if (!bundle.name().toString().startsWith(DB2_DRIVER_ROOT_PACKAGE)) continue;
            resourceBundle.produce((BuildItem)new NativeImageResourceBundleBuildItem(bundle.name().toString()));
        }
    }

    @BuildStep
    NativeImageConfigBuildItem build() {
        return NativeImageConfigBuildItem.builder().addNativeImageSystemProperty("QuarkusWithJcc", "true").build();
    }

    @BuildStep
    NativeImageEnableAllCharsetsBuildItem enableAllCharsets() {
        return new NativeImageEnableAllCharsetsBuildItem();
    }

    @BuildStep
    void registerServiceBinding(Capabilities capabilities, BuildProducer<ServiceProviderBuildItem> serviceProvider, BuildProducer<DefaultDataSourceDbKindBuildItem> dbKind) {
        if (capabilities.isPresent("io.quarkus.kubernetes.service.binding")) {
            serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter", new String[]{DB2ServiceBindingConverter.class.getName()}));
        }
        dbKind.produce((BuildItem)new DefaultDataSourceDbKindBuildItem("db2"));
    }

    @BuildStep
    void addExportsToNativeImage(BuildProducer<JPMSExportBuildItem> jpmsExports) {
        jpmsExports.produce((BuildItem)new JPMSExportBuildItem("java.base", "sun.security.action"));
    }
}

