/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jacoco.runtime;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class ReportInfo {
    public String reportDir;
    public Path dataFile;
    public final List<String> savedData = new ArrayList<String>();
    public Set<String> sourceDirectories;
    public Set<String> classFiles;
    public String artifactId;
    public Path errorFile;

    public void emitError(String msg) {
        this.emitError(msg, null);
    }

    public void emitError(String msg, Throwable exception) {
        System.err.println(msg);
        if (exception != null) {
            exception.printStackTrace();
        }
        System.err.flush();
        try (OutputStream out = Files.newOutputStream(this.errorFile, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            PrintStream ps = new PrintStream(out);
            ps.println();
            ps.println(String.valueOf(new Date()) + ": " + msg);
            if (exception != null) {
                exception.printStackTrace(ps);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

