/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jacoco.deployment;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.jacoco.runtime.JacocoConfig;
import io.quarkus.jacoco.runtime.ReportCreator;
import io.quarkus.jacoco.runtime.ReportInfo;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.codehaus.plexus.util.FileUtils;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.OfflineInstrumentationAccessGenerator;
import org.jboss.jandex.ClassInfo;
import org.jboss.logging.Logger;

public class JacocoProcessor {
    private static final Logger log = Logger.getLogger(JacocoProcessor.class);

    @BuildStep(onlyIf={IsTest.class})
    FeatureBuildItem feature() {
        return new FeatureBuildItem("jacoco");
    }

    @BuildStep(onlyIf={IsTest.class})
    void transformerBuildItem(BuildProducer<BytecodeTransformerBuildItem> transformers, OutputTargetBuildItem outputTargetBuildItem, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildSystemTargetBuildItem buildSystemTargetBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, LaunchModeBuildItem launchModeBuildItem, JacocoConfig config) throws Exception {
        if (launchModeBuildItem.isAuxiliaryApplication()) {
            return;
        }
        if (!config.enabled()) {
            log.debug((Object)"quarkus-jacoco is disabled via config");
            return;
        }
        String dataFile = this.getFilePath(config.dataFile(), outputTargetBuildItem.getOutputDirectory(), "jacoco-quarkus.exec");
        System.setProperty("jacoco-agent.destfile", dataFile);
        if (!config.reuseDataFile()) {
            Files.deleteIfExists(Paths.get(dataFile, new String[0]));
        }
        final Instrumenter instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)new OfflineInstrumentationAccessGenerator());
        HashSet<String> seen = new HashSet<String>();
        for (ApplicationArchive archive : applicationArchivesBuildItem.getAllApplicationArchives()) {
            for (ClassInfo i : archive.getIndex().getKnownClasses()) {
                String className = i.name().toString();
                if (seen.contains(className)) continue;
                seen.add(className);
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem.Builder().setClassToTransform(className).setCacheable(true).setEager(true).setInputTransformer((BiFunction)new BiFunction<String, byte[], byte[]>(){

                    @Override
                    public byte[] apply(String className, byte[] bytes) {
                        try {
                            byte[] enhanced = instrumenter.instrument(bytes, className);
                            if (enhanced == null) {
                                return bytes;
                            }
                            return enhanced;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }).build());
            }
        }
        if (config.report()) {
            HashSet<String> classes;
            ReportInfo info = new ReportInfo();
            info.dataFile = dataFile;
            File targetdir = new File(this.getFilePath(config.reportLocation(), outputTargetBuildItem.getOutputDirectory(), "jacoco-report"));
            info.reportDir = targetdir.getAbsolutePath();
            String includes = String.join((CharSequence)",", config.includes());
            String excludes = String.join((CharSequence)",", config.excludes().orElse(Collections.emptyList()));
            info.classFiles = classes = new HashSet<String>();
            HashSet<String> sources = new HashSet<String>();
            ApplicationModel model = curateOutcomeBuildItem.getApplicationModel();
            if (model.getApplicationModule() != null) {
                this.addProjectModule(model.getAppArtifact(), config, info, includes, excludes, classes, sources);
            }
            for (ResolvedDependency d : model.getDependencies()) {
                if (!d.isRuntimeCp() || !d.isWorkspaceModule()) continue;
                this.addProjectModule(d, config, info, includes, excludes, classes, sources);
            }
            info.sourceDirectories = sources;
            info.artifactId = buildSystemTargetBuildItem.getBaseName();
            Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new ReportCreator(info, config)));
        }
    }

    private void addProjectModule(ResolvedDependency module, JacocoConfig config, ReportInfo info, String includes, String excludes, Set<String> classes, Set<String> sources) throws Exception {
        String dataFile = this.getFilePath(config.dataFile(), module.getWorkspaceModule().getBuildDir().toPath(), "jacoco-quarkus.exec");
        info.savedData.add(new File(dataFile).getAbsolutePath());
        if (module.getSources() == null) {
            return;
        }
        for (SourceDir src : module.getSources().getSourceDirs()) {
            for (Path p : src.getSourceTree().getRoots()) {
                sources.add(p.toAbsolutePath().toString());
            }
            if (!Files.isDirectory(src.getOutputDir(), new LinkOption[0])) continue;
            for (File file : FileUtils.getFiles((File)src.getOutputDir().toFile(), (String)includes, (String)excludes, (boolean)true)) {
                if (!file.getName().endsWith(".class")) continue;
                classes.add(file.getAbsolutePath());
            }
        }
    }

    private String getFilePath(Optional<String> path, Path outputDirectory, String defaultRelativePath) {
        return path.orElse(String.valueOf(outputDirectory.toAbsolutePath()) + File.separator + defaultRelativePath);
    }
}

