/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.standalone.elasticsearch.runtime;

import io.quarkus.arc.ActiveResult;
import io.quarkus.arc.Arc;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.hibernate.search.backend.elasticsearch.common.runtime.HibernateSearchBackendElasticsearchConfigHandler;
import io.quarkus.hibernate.search.backend.elasticsearch.common.runtime.HibernateSearchConfigUtil;
import io.quarkus.hibernate.search.backend.elasticsearch.common.runtime.MapperContext;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.HibernateSearchStandaloneBuildTimeConfig;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.HibernateSearchStandaloneElasticsearchMapperContext;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.HibernateSearchStandalonePreBootState;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.HibernateSearchStandaloneRuntimeConfig;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.bean.ArcBeanProvider;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.bean.HibernateSearchBeanUtil;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.management.HibernateSearchStandaloneManagementHandler;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.mapping.QuarkusHibernateSearchStandaloneMappingConfigurer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.pojo.standalone.bootstrap.spi.StandalonePojoIntegrationBooter;
import org.hibernate.search.mapper.pojo.standalone.mapping.SearchMapping;
import org.hibernate.search.mapper.pojo.standalone.mapping.StandalonePojoMappingConfigurer;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategy;
import org.hibernate.search.util.common.reflect.spi.ValueHandleFactory;

@Recorder
public class HibernateSearchStandaloneRecorder {
    private final HibernateSearchStandaloneBuildTimeConfig buildTimeConfig;
    private final RuntimeValue<HibernateSearchStandaloneRuntimeConfig> runtimeConfig;

    public HibernateSearchStandaloneRecorder(HibernateSearchStandaloneBuildTimeConfig buildTimeConfig, RuntimeValue<HibernateSearchStandaloneRuntimeConfig> runtimeConfig) {
        this.buildTimeConfig = buildTimeConfig;
        this.runtimeConfig = runtimeConfig;
    }

    public void preBoot(HibernateSearchStandaloneElasticsearchMapperContext mapperContext, Set<String> rootAnnotationMappedClassNames) {
        LinkedHashSet rootAnnotationMappedClasses = new LinkedHashSet();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        for (String className : rootAnnotationMappedClassNames) {
            try {
                rootAnnotationMappedClasses.add(Class.forName(className, true, tccl));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not initialize mapped class " + className, e);
            }
        }
        LinkedHashMap<String, Object> bootProperties = new LinkedHashMap<String, Object>();
        new StaticInitListener(mapperContext, this.buildTimeConfig, rootAnnotationMappedClasses).contributeBootProperties(bootProperties::put);
        StandalonePojoIntegrationBooter booter = StandalonePojoIntegrationBooter.builder().properties(bootProperties).valueReadHandleFactory(ValueHandleFactory.usingJavaLangReflect()).property("hibernate.search.bean_provider", (Object)new ArcBeanProvider(Arc.container())).build();
        booter.preBoot(bootProperties::put);
        HibernateSearchStandalonePreBootState.set(bootProperties);
    }

    public void checkNoExplicitActiveTrue() {
        if (((HibernateSearchStandaloneRuntimeConfig)this.runtimeConfig.getValue()).active().orElse(false).booleanValue()) {
            String enabledPropertyKey = HibernateSearchStandaloneRuntimeConfig.extensionPropertyKey("enabled");
            String activePropertyKey = HibernateSearchStandaloneRuntimeConfig.mapperPropertyKey("active");
            throw new ConfigurationException("Hibernate Search Standalone activated explicitly, but the Hibernate Search Standalone extension was disabled at build time. If you want Hibernate Search Standalone to be active, you must set '" + enabledPropertyKey + "' to 'true' at build time. If you don't want Hibernate Search Standalone to be active, you must leave '" + activePropertyKey + "' unset or set it to 'false'.", Set.of(enabledPropertyKey, activePropertyKey));
        }
    }

    public void clearPreBootState() {
        HibernateSearchStandalonePreBootState.pop();
    }

    public Supplier<ActiveResult> checkActiveSupplier() {
        return new Supplier<ActiveResult>(){

            @Override
            public ActiveResult get() {
                Optional<Boolean> active = ((HibernateSearchStandaloneRuntimeConfig)HibernateSearchStandaloneRecorder.this.runtimeConfig.getValue()).active();
                if (active.isPresent() && !active.get().booleanValue()) {
                    return ActiveResult.inactive((String)String.format(Locale.ROOT, "Hibernate Search Standalone was deactivated through configuration properties. To activate Hibernate Search Standalone, set configuration property '%s' to 'true'", HibernateSearchStandaloneRuntimeConfig.mapperPropertyKey("active")));
                }
                return ActiveResult.active();
            }
        };
    }

    public Function<SyntheticCreationalContext<SearchMapping>, SearchMapping> createSearchMappingFunction(final HibernateSearchStandaloneElasticsearchMapperContext mapperContext) {
        return new Function<SyntheticCreationalContext<SearchMapping>, SearchMapping>(){

            @Override
            public SearchMapping apply(SyntheticCreationalContext<SearchMapping> context) {
                LinkedHashMap<String, Object> bootProperties = new LinkedHashMap<String, Object>(HibernateSearchStandalonePreBootState.pop());
                new RuntimeInitListener(mapperContext, (HibernateSearchStandaloneRuntimeConfig)HibernateSearchStandaloneRecorder.this.runtimeConfig.getValue()).contributeRuntimeProperties(bootProperties::put);
                StandalonePojoIntegrationBooter booter = StandalonePojoIntegrationBooter.builder().properties(bootProperties).build();
                return booter.boot();
            }
        };
    }

    public Handler<RoutingContext> managementHandler() {
        return new HibernateSearchStandaloneManagementHandler();
    }

    private static final class StaticInitListener {
        private final HibernateSearchStandaloneElasticsearchMapperContext mapperContext;
        private final HibernateSearchStandaloneBuildTimeConfig buildTimeConfig;
        private final Set<Class<?>> rootAnnotationMappedClasses;

        private StaticInitListener(HibernateSearchStandaloneElasticsearchMapperContext mapperContext, HibernateSearchStandaloneBuildTimeConfig buildTimeConfig, Set<Class<?>> rootAnnotationMappedClasses) {
            this.mapperContext = mapperContext;
            this.buildTimeConfig = buildTimeConfig;
            this.rootAnnotationMappedClasses = rootAnnotationMappedClasses;
        }

        public void contributeBootProperties(BiConsumer<String, Object> propertyCollector) {
            HibernateSearchConfigUtil.addConfig(propertyCollector, (String)"hibernate.search.background_failure_handler", HibernateSearchBeanUtil.singleExtensionBeanReferenceFor(this.buildTimeConfig == null ? Optional.empty() : this.buildTimeConfig.backgroundFailureHandler(), FailureHandler.class, null, null));
            HibernateSearchConfigUtil.addConfig(propertyCollector, (String)"hibernate.search.mapping.configurer", this.collectAllStandalonePojoMappingConfigurers());
            HibernateSearchBackendElasticsearchConfigHandler.contributeBackendBuildTimeProperties(propertyCollector, (MapperContext)this.mapperContext, this.buildTimeConfig == null ? Collections.emptyMap() : this.buildTimeConfig.backends());
        }

        private List<BeanReference<StandalonePojoMappingConfigurer>> collectAllStandalonePojoMappingConfigurers() {
            ArrayList<BeanReference<StandalonePojoMappingConfigurer>> configurers = new ArrayList<BeanReference<StandalonePojoMappingConfigurer>>();
            configurers.add(BeanReference.ofInstance((Object)new QuarkusHibernateSearchStandaloneMappingConfigurer(this.buildTimeConfig.mapping().structure(), this.rootAnnotationMappedClasses)));
            Optional<List<BeanReference<StandalonePojoMappingConfigurer>>> beanReferences = HibernateSearchBeanUtil.multiExtensionBeanReferencesFor(this.buildTimeConfig.mapping().configurer(), StandalonePojoMappingConfigurer.class, null, null);
            if (beanReferences.isPresent()) {
                configurers.addAll((Collection<BeanReference<StandalonePojoMappingConfigurer>>)beanReferences.get());
            }
            return configurers;
        }
    }

    private static final class RuntimeInitListener {
        private final HibernateSearchStandaloneElasticsearchMapperContext mapperContext;
        private final HibernateSearchStandaloneRuntimeConfig runtimeConfig;

        private RuntimeInitListener(HibernateSearchStandaloneElasticsearchMapperContext mapperContext, HibernateSearchStandaloneRuntimeConfig runtimeConfig) {
            this.mapperContext = mapperContext;
            this.runtimeConfig = runtimeConfig;
        }

        public void contributeRuntimeProperties(BiConsumer<String, Object> propertyCollector) {
            if (this.runtimeConfig != null) {
                HibernateSearchConfigUtil.addConfig(propertyCollector, (String)"hibernate.search.schema_management.strategy", (Object)this.runtimeConfig.schemaManagement().strategy());
            }
            HibernateSearchConfigUtil.addConfig(propertyCollector, (String)"hibernate.search.indexing.plan.synchronization.strategy", HibernateSearchBeanUtil.singleExtensionBeanReferenceFor(this.runtimeConfig == null ? Optional.empty() : this.runtimeConfig.indexing().plan().synchronization().strategy(), IndexingPlanSynchronizationStrategy.class, null, null));
            HibernateSearchBackendElasticsearchConfigHandler.contributeBackendRuntimeProperties(propertyCollector, (MapperContext)this.mapperContext, this.runtimeConfig == null ? Collections.emptyMap() : this.runtimeConfig.backends());
        }
    }
}

