/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.outboxpolling.runtime;

import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeInitListener;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationStaticInitListener;
import io.quarkus.hibernate.search.orm.outboxpolling.runtime.HibernateSearchOutboxPollingBuildTimeConfig;
import io.quarkus.hibernate.search.orm.outboxpolling.runtime.HibernateSearchOutboxPollingBuildTimeConfigPersistenceUnit;
import io.quarkus.hibernate.search.orm.outboxpolling.runtime.HibernateSearchOutboxPollingConfigUtil;
import io.quarkus.hibernate.search.orm.outboxpolling.runtime.HibernateSearchOutboxPollingRuntimeConfig;
import io.quarkus.hibernate.search.orm.outboxpolling.runtime.HibernateSearchOutboxPollingRuntimeConfigPersistenceUnit;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.BootstrapContext;

@Recorder
public class HibernateSearchOutboxPollingRecorder {
    private final HibernateSearchOutboxPollingBuildTimeConfig buildTimeConfig;
    private final RuntimeValue<HibernateSearchOutboxPollingRuntimeConfig> runtimeConfig;

    public HibernateSearchOutboxPollingRecorder(HibernateSearchOutboxPollingBuildTimeConfig buildTimeConfig, RuntimeValue<HibernateSearchOutboxPollingRuntimeConfig> runtimeConfig) {
        this.buildTimeConfig = buildTimeConfig;
        this.runtimeConfig = runtimeConfig;
    }

    public HibernateOrmIntegrationStaticInitListener createStaticInitListener(String persistenceUnitName) {
        HibernateSearchOutboxPollingBuildTimeConfigPersistenceUnit puConfig = this.buildTimeConfig.persistenceUnits().get(persistenceUnitName);
        return new StaticInitListener(puConfig);
    }

    public HibernateOrmIntegrationRuntimeInitListener createRuntimeInitListener(String persistenceUnitName) {
        HibernateSearchOutboxPollingRuntimeConfigPersistenceUnit puConfig = ((HibernateSearchOutboxPollingRuntimeConfig)this.runtimeConfig.getValue()).persistenceUnits().get(persistenceUnitName);
        return new RuntimeInitListener(puConfig);
    }

    private static final class StaticInitListener
    implements HibernateOrmIntegrationStaticInitListener {
        private final HibernateSearchOutboxPollingBuildTimeConfigPersistenceUnit buildTimeConfig;

        private StaticInitListener(HibernateSearchOutboxPollingBuildTimeConfigPersistenceUnit buildTimeConfig) {
            this.buildTimeConfig = buildTimeConfig;
        }

        public void onMetadataInitialized(Metadata metadata, BootstrapContext bootstrapContext, BiConsumer<String, Object> propertyCollector) {
        }

        public void contributeBootProperties(BiConsumer<String, Object> propertyCollector) {
            if (this.buildTimeConfig == null) {
                return;
            }
            this.contributeCoordinationBuildTimeProperties(propertyCollector, this.buildTimeConfig.coordination());
        }

        private void contributeCoordinationBuildTimeProperties(BiConsumer<String, Object> propertyCollector, HibernateSearchOutboxPollingBuildTimeConfigPersistenceUnit.CoordinationConfig config) {
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, "entity.mapping.agent.catalog", config.entityMapping().agent().catalog());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, "entity.mapping.agent.schema", config.entityMapping().agent().schema());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, "entity.mapping.agent.table", config.entityMapping().agent().table());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, "entity.mapping.agent.uuid_gen_strategy", config.entityMapping().agent().uuidGenStrategy());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, "entity.mapping.agent.uuid_type", config.entityMapping().agent().uuidType());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, "entity.mapping.outboxevent.catalog", config.entityMapping().outboxEvent().catalog());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, "entity.mapping.outboxevent.schema", config.entityMapping().outboxEvent().schema());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, "entity.mapping.outboxevent.table", config.entityMapping().outboxEvent().table());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, "entity.mapping.outboxevent.uuid_gen_strategy", config.entityMapping().outboxEvent().uuidGenStrategy());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, "entity.mapping.outboxevent.uuid_type", config.entityMapping().outboxEvent().uuidType());
        }
    }

    private static final class RuntimeInitListener
    implements HibernateOrmIntegrationRuntimeInitListener {
        private final HibernateSearchOutboxPollingRuntimeConfigPersistenceUnit runtimeConfig;

        private RuntimeInitListener(HibernateSearchOutboxPollingRuntimeConfigPersistenceUnit runtimeConfig) {
            this.runtimeConfig = runtimeConfig;
        }

        public void contributeRuntimeProperties(BiConsumer<String, Object> propertyCollector) {
            if (this.runtimeConfig == null) {
                return;
            }
            this.contributeCoordinationRuntimeProperties(propertyCollector, null, this.runtimeConfig.coordination().defaults());
            for (Map.Entry<String, HibernateSearchOutboxPollingRuntimeConfigPersistenceUnit.AgentsConfig> tenantEntry : this.runtimeConfig.coordination().tenants().entrySet()) {
                this.contributeCoordinationRuntimeProperties(propertyCollector, tenantEntry.getKey(), tenantEntry.getValue());
            }
        }

        private void contributeCoordinationRuntimeProperties(BiConsumer<String, Object> propertyCollector, String tenantId, HibernateSearchOutboxPollingRuntimeConfigPersistenceUnit.AgentsConfig agentsConfig) {
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, tenantId, "event_processor.enabled", agentsConfig.eventProcessor().enabled());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, tenantId, "event_processor.shards.total_count", agentsConfig.eventProcessor().shards().totalCount());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, tenantId, "event_processor.shards.assigned", agentsConfig.eventProcessor().shards().assigned());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, tenantId, "event_processor.polling_interval", agentsConfig.eventProcessor().pollingInterval().toMillis());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, tenantId, "event_processor.pulse_interval", agentsConfig.eventProcessor().pulseInterval().toMillis());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, tenantId, "event_processor.pulse_expiration", agentsConfig.eventProcessor().pulseExpiration().toMillis());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, tenantId, "event_processor.batch_size", agentsConfig.eventProcessor().batchSize());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, tenantId, "event_processor.transaction_timeout", agentsConfig.eventProcessor().transactionTimeout(), Optional::isPresent, d -> ((Duration)d.get()).toSeconds());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, tenantId, "event_processor.retry_delay", agentsConfig.eventProcessor().retryDelay().toSeconds());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, tenantId, "mass_indexer.polling_interval", agentsConfig.massIndexer().pollingInterval().toMillis());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, tenantId, "mass_indexer.pulse_interval", agentsConfig.massIndexer().pulseInterval().toMillis());
            HibernateSearchOutboxPollingConfigUtil.addCoordinationConfig(propertyCollector, tenantId, "mass_indexer.pulse_expiration", agentsConfig.massIndexer().pulseExpiration().toMillis());
        }
    }
}

