/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.runtime;

import io.quarkus.hibernate.search.backend.elasticsearch.common.runtime.HibernateSearchBackendElasticsearchRuntimeConfig;
import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithUnnamedKey;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.mapper.orm.schema.management.SchemaManagementStrategyName;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;

@ConfigGroup
public interface HibernateSearchElasticsearchRuntimeConfigPersistenceUnit {
    @ConfigDocDefault(value="'true' if Hibernate Search is enabled; 'false' otherwise")
    public Optional<Boolean> active();

    @ConfigDocSection
    @WithName(value="elasticsearch")
    @WithUnnamedKey
    @ConfigDocMapKey(value="backend-name")
    public Map<String, HibernateSearchBackendElasticsearchRuntimeConfig> backends();

    public SchemaManagementConfig schemaManagement();

    @WithName(value="query.loading")
    public SearchQueryLoadingConfig queryLoading();

    public IndexingConfig indexing();

    @Deprecated
    public AutomaticIndexingConfig automaticIndexing();

    public MultiTenancyConfig multiTenancy();

    @ConfigGroup
    public static interface MultiTenancyConfig {
        public Optional<List<String>> tenantIds();
    }

    @ConfigGroup
    public static interface SchemaManagementConfig {
        @WithDefault(value="create-or-validate")
        @ConfigDocDefault(value="drop-and-create-and-drop when using Dev Services; create-or-validate otherwise")
        public SchemaManagementStrategyName strategy();
    }

    @ConfigGroup
    public static interface SearchQueryLoadingCacheLookupConfig {
        @WithDefault(value="skip")
        public EntityLoadingCacheLookupStrategy strategy();
    }

    @ConfigGroup
    public static interface SearchQueryLoadingConfig {
        public SearchQueryLoadingCacheLookupConfig cacheLookup();

        @WithDefault(value="100")
        public int fetchSize();
    }

    @ConfigGroup
    @Deprecated
    public static interface AutomaticIndexingSynchronizationConfig {
        @ConfigDocDefault(value="write-sync")
        public Optional<String> strategy();
    }

    @ConfigGroup
    @Deprecated
    public static interface AutomaticIndexingConfig {
        public AutomaticIndexingSynchronizationConfig synchronization();

        @WithDefault(value="true")
        @Deprecated
        public boolean enableDirtyCheck();
    }

    @ConfigGroup
    public static interface IndexingPlanSynchronizationConfig {
        @ConfigDocDefault(value="write-sync")
        public Optional<String> strategy();
    }

    @ConfigGroup
    public static interface IndexingPlanConfig {
        public IndexingPlanSynchronizationConfig synchronization();
    }

    @ConfigGroup
    public static interface IndexingConfig {
        public IndexingPlanConfig plan();
    }
}

