/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.runtime.dev;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.orm.PersistenceUnit;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.dev.HibernateSearchElasticsearchDevInfo;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.mapper.orm.mapping.SearchMapping;

public class HibernateSearchElasticsearchDevController {
    private static final HibernateSearchElasticsearchDevController INSTANCE = new HibernateSearchElasticsearchDevController();
    private final Set<String> activePersistenceUnitNames = new HashSet<String>();

    public static HibernateSearchElasticsearchDevController get() {
        return INSTANCE;
    }

    private HibernateSearchElasticsearchDevController() {
    }

    void setActivePersistenceUnitNames(Set<String> activePersistenceUnitNames) {
        this.activePersistenceUnitNames.clear();
        this.activePersistenceUnitNames.addAll(activePersistenceUnitNames);
    }

    public HibernateSearchElasticsearchDevInfo getInfo() {
        Map<String, SearchMapping> mappings = this.searchMappings(this.activePersistenceUnitNames);
        if (mappings.isEmpty()) {
            return new HibernateSearchElasticsearchDevInfo();
        }
        return mappings.entrySet().stream().map(mapping -> new HibernateSearchElasticsearchDevInfo.PersistenceUnit((String)mapping.getKey(), ((SearchMapping)mapping.getValue()).allIndexedEntities().stream().map(HibernateSearchElasticsearchDevInfo.IndexedEntity::new).sorted().collect(Collectors.toList()))).collect(Collector.of(HibernateSearchElasticsearchDevInfo::new, HibernateSearchElasticsearchDevInfo::add, (left, right) -> {
            left.addAll((HibernateSearchElasticsearchDevInfo)right);
            return left;
        }, new Collector.Characteristics[0]));
    }

    public SearchMapping searchMapping(String persistenceUnitName) {
        return (SearchMapping)Arc.container().select(SearchMapping.class, new Annotation[]{new PersistenceUnit.PersistenceUnitLiteral(persistenceUnitName)}).get();
    }

    public Map<String, SearchMapping> searchMappings(Set<String> persistenceUnitNames) {
        return persistenceUnitNames.stream().map(this::searchMapping).collect(Collectors.toMap(HibernateSearchElasticsearchDevController::getPersistenceUnitName, mapping -> mapping));
    }

    private static String getPersistenceUnitName(SearchMapping searchMapping) {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)searchMapping.toOrmSessionFactory().unwrap(SessionFactoryImplementor.class);
        String name = sessionFactory.getName();
        if (name != null) {
            return name;
        }
        Object persistenceUnitName = sessionFactory.getProperties().get("hibernate.persistenceUnitName");
        if (persistenceUnitName != null) {
            return persistenceUnitName.toString();
        }
        return "<default>";
    }
}

