/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeInitListener;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationStaticInitListener;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchConfigUtil;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchBuildTimeConfig;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRuntimeConfig;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRuntimeConfigPersistenceUnit;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.bean.HibernateSearchBeanUtil;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.management.HibernateSearchManagementHandler;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.mapping.QuarkusHibernateOrmSearchMappingConfigurer;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.literal.NamedLiteral;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.search.backend.elasticsearch.analysis.ElasticsearchAnalysisConfigurer;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.orm.Search;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateSearchPreIntegrationService;
import org.hibernate.search.mapper.orm.bootstrap.spi.HibernateOrmIntegrationBooter;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationStrategy;
import org.hibernate.search.mapper.orm.mapping.HibernateOrmSearchMappingConfigurer;
import org.hibernate.search.mapper.orm.mapping.SearchMapping;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategy;
import org.hibernate.search.util.common.reflect.spi.ValueHandleFactory;

@Recorder
public class HibernateSearchElasticsearchRecorder {
    public HibernateOrmIntegrationStaticInitListener createStaticInitListener(String persistenceUnitName, HibernateSearchElasticsearchBuildTimeConfig buildTimeConfig, Map<String, Set<String>> backendAndIndexNamesForSearchExtensions, Set<String> rootAnnotationMappedClassNames, List<HibernateOrmIntegrationStaticInitListener> integrationStaticInitListeners) {
        LinkedHashSet rootAnnotationMappedClasses = new LinkedHashSet();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        for (String className : rootAnnotationMappedClassNames) {
            try {
                rootAnnotationMappedClasses.add(Class.forName(className, true, tccl));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not initialize mapped class " + className, e);
            }
        }
        return new HibernateSearchIntegrationStaticInitListener(persistenceUnitName, buildTimeConfig.persistenceUnits().get(persistenceUnitName), backendAndIndexNamesForSearchExtensions, rootAnnotationMappedClasses, integrationStaticInitListeners);
    }

    public HibernateOrmIntegrationStaticInitListener createStaticInitInactiveListener() {
        return new HibernateSearchIntegrationStaticInitInactiveListener();
    }

    public HibernateOrmIntegrationRuntimeInitListener createRuntimeInitListener(HibernateSearchElasticsearchRuntimeConfig runtimeConfig, String persistenceUnitName, Map<String, Set<String>> backendAndIndexNamesForSearchExtensions, List<HibernateOrmIntegrationRuntimeInitListener> integrationRuntimeInitListeners) {
        HibernateSearchElasticsearchRuntimeConfigPersistenceUnit puConfig = runtimeConfig.persistenceUnits().get(persistenceUnitName);
        return new HibernateSearchIntegrationRuntimeInitListener(persistenceUnitName, puConfig, backendAndIndexNamesForSearchExtensions, integrationRuntimeInitListeners);
    }

    public void checkNoExplicitActiveTrue(HibernateSearchElasticsearchRuntimeConfig runtimeConfig) {
        for (Map.Entry<String, HibernateSearchElasticsearchRuntimeConfigPersistenceUnit> entry : runtimeConfig.persistenceUnits().entrySet()) {
            HibernateSearchElasticsearchRuntimeConfigPersistenceUnit config = entry.getValue();
            if (!config.active().orElse(false).booleanValue()) continue;
            String puName = entry.getKey();
            String enabledPropertyKey = HibernateSearchElasticsearchRuntimeConfig.extensionPropertyKey("enabled");
            String activePropertyKey = HibernateSearchElasticsearchRuntimeConfig.mapperPropertyKey(puName, "active");
            throw new ConfigurationException("Hibernate Search activated explicitly for persistence unit '" + puName + "', but the Hibernate Search extension was disabled at build time. If you want Hibernate Search to be active for this persistence unit, you must set '" + enabledPropertyKey + "' to 'true' at build time. If you don't want Hibernate Search to be active for this persistence unit, you must leave '" + activePropertyKey + "' unset or set it to 'false'.", Set.of(enabledPropertyKey, activePropertyKey));
        }
    }

    public HibernateOrmIntegrationRuntimeInitListener createRuntimeInitInactiveListener() {
        return new HibernateSearchIntegrationRuntimeInitInactiveListener();
    }

    public Supplier<SearchMapping> searchMappingSupplier(final HibernateSearchElasticsearchRuntimeConfig runtimeConfig, final String persistenceUnitName, final boolean isDefaultPersistenceUnit) {
        return new Supplier<SearchMapping>(){

            @Override
            public SearchMapping get() {
                HibernateSearchElasticsearchRuntimeConfigPersistenceUnit puRuntimeConfig = runtimeConfig.persistenceUnits().get(persistenceUnitName);
                if (puRuntimeConfig != null && !puRuntimeConfig.active().orElse(true).booleanValue()) {
                    throw new IllegalStateException("Cannot retrieve the SearchMapping for persistence unit " + persistenceUnitName + ": Hibernate Search was deactivated through configuration properties");
                }
                SessionFactory sessionFactory = isDefaultPersistenceUnit ? (SessionFactory)Arc.container().instance(SessionFactory.class, new Annotation[0]).get() : (SessionFactory)Arc.container().instance(SessionFactory.class, new Annotation[]{NamedLiteral.of((String)persistenceUnitName)}).get();
                return Search.mapping((SessionFactory)sessionFactory);
            }
        };
    }

    public Supplier<SearchSession> searchSessionSupplier(final HibernateSearchElasticsearchRuntimeConfig runtimeConfig, final String persistenceUnitName, final boolean isDefaultPersistenceUnit) {
        return new Supplier<SearchSession>(){

            @Override
            public SearchSession get() {
                HibernateSearchElasticsearchRuntimeConfigPersistenceUnit puRuntimeConfig = runtimeConfig.persistenceUnits().get(persistenceUnitName);
                if (puRuntimeConfig != null && !puRuntimeConfig.active().orElse(true).booleanValue()) {
                    throw new IllegalStateException("Cannot retrieve the SearchSession for persistence unit " + persistenceUnitName + ": Hibernate Search was deactivated through configuration properties");
                }
                Session session = isDefaultPersistenceUnit ? (Session)Arc.container().instance(Session.class, new Annotation[0]).get() : (Session)Arc.container().instance(Session.class, new Annotation[]{NamedLiteral.of((String)persistenceUnitName)}).get();
                return Search.session((Session)session);
            }
        };
    }

    public Handler<RoutingContext> managementHandler() {
        return new HibernateSearchManagementHandler();
    }

    private static void mergeInto(Map<String, Set<String>> target, Map<String, Set<String>> source) {
        for (Map.Entry<String, Set<String>> entry : source.entrySet()) {
            HibernateSearchElasticsearchRecorder.mergeInto(target, entry.getKey(), entry.getValue());
        }
    }

    private static void mergeInto(Map<String, Set<String>> target, String key, Set<String> values) {
        target.computeIfAbsent(key, ignored -> new LinkedHashSet()).addAll(values);
    }

    private static final class HibernateSearchIntegrationStaticInitListener
    implements HibernateOrmIntegrationStaticInitListener {
        private final String persistenceUnitName;
        private final HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit buildTimeConfig;
        private final Map<String, Set<String>> backendAndIndexNamesForSearchExtensions;
        private final Set<Class<?>> rootAnnotationMappedClasses;
        private final List<HibernateOrmIntegrationStaticInitListener> integrationStaticInitListeners;

        private HibernateSearchIntegrationStaticInitListener(String persistenceUnitName, HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit buildTimeConfig, Map<String, Set<String>> backendAndIndexNamesForSearchExtensions, Set<Class<?>> rootAnnotationMappedClasses, List<HibernateOrmIntegrationStaticInitListener> integrationStaticInitListeners) {
            this.persistenceUnitName = persistenceUnitName;
            this.buildTimeConfig = buildTimeConfig;
            this.backendAndIndexNamesForSearchExtensions = backendAndIndexNamesForSearchExtensions;
            this.rootAnnotationMappedClasses = rootAnnotationMappedClasses;
            this.integrationStaticInitListeners = integrationStaticInitListeners;
        }

        public void contributeBootProperties(BiConsumer<String, Object> propertyCollector) {
            HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.background_failure_handler", HibernateSearchBeanUtil.singleExtensionBeanReferenceFor(this.buildTimeConfig == null ? Optional.empty() : this.buildTimeConfig.backgroundFailureHandler(), FailureHandler.class, this.persistenceUnitName, null, null));
            HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.mapping.configurer", this.collectAllHibernateOrmSearchMappingConfigurers());
            HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.coordination.strategy", HibernateSearchBeanUtil.singleExtensionBeanReferenceFor(this.buildTimeConfig == null ? Optional.empty() : this.buildTimeConfig.coordination().strategy(), CoordinationStrategy.class, this.persistenceUnitName, null, null));
            Map backendConfigs = this.buildTimeConfig == null ? Collections.emptyMap() : this.buildTimeConfig.backends();
            LinkedHashMap<String, Set<String>> backendAndIndexNames = new LinkedHashMap<String, Set<String>>();
            HibernateSearchElasticsearchRecorder.mergeInto(backendAndIndexNames, this.backendAndIndexNamesForSearchExtensions);
            for (Map.Entry entry : backendConfigs.entrySet()) {
                HibernateSearchElasticsearchRecorder.mergeInto(backendAndIndexNames, (String)entry.getKey(), ((HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchBackendBuildTimeConfig)entry.getValue()).indexes().keySet());
            }
            for (Map.Entry entry : backendAndIndexNames.entrySet()) {
                String backendName = (String)entry.getKey();
                Set indexNames = (Set)entry.getValue();
                this.contributeBackendBuildTimeProperties(propertyCollector, backendName, indexNames, (HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchBackendBuildTimeConfig)backendConfigs.get(backendName));
            }
            for (HibernateOrmIntegrationStaticInitListener listener : this.integrationStaticInitListeners) {
                listener.contributeBootProperties(propertyCollector);
            }
        }

        private List<BeanReference<HibernateOrmSearchMappingConfigurer>> collectAllHibernateOrmSearchMappingConfigurers() {
            ArrayList<BeanReference<HibernateOrmSearchMappingConfigurer>> configurers = new ArrayList<BeanReference<HibernateOrmSearchMappingConfigurer>>();
            configurers.add(BeanReference.ofInstance((Object)new QuarkusHibernateOrmSearchMappingConfigurer(this.rootAnnotationMappedClasses)));
            Optional<List<BeanReference<HibernateOrmSearchMappingConfigurer>>> beanReferences = HibernateSearchBeanUtil.multiExtensionBeanReferencesFor(this.buildTimeConfig.mapping().configurer(), HibernateOrmSearchMappingConfigurer.class, this.persistenceUnitName, null, null);
            if (beanReferences.isPresent()) {
                configurers.addAll((Collection<BeanReference<HibernateOrmSearchMappingConfigurer>>)beanReferences.get());
            }
            return configurers;
        }

        public void onMetadataInitialized(Metadata metadata, BootstrapContext bootstrapContext, BiConsumer<String, Object> propertyCollector) {
            HibernateOrmIntegrationBooter booter = HibernateOrmIntegrationBooter.builder((Metadata)metadata, (BootstrapContext)bootstrapContext).valueReadHandleFactory(ValueHandleFactory.usingJavaLangReflect()).build();
            booter.preBoot(propertyCollector);
            for (HibernateOrmIntegrationStaticInitListener listener : this.integrationStaticInitListeners) {
                listener.onMetadataInitialized(metadata, bootstrapContext, propertyCollector);
            }
        }

        private void contributeBackendBuildTimeProperties(BiConsumer<String, Object> propertyCollector, String backendName, Set<String> indexNames, HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchBackendBuildTimeConfig elasticsearchBackendConfig) {
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "type", "elasticsearch");
            if (elasticsearchBackendConfig != null) {
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "version", elasticsearchBackendConfig.version());
            }
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "layout.strategy", HibernateSearchBeanUtil.singleExtensionBeanReferenceFor(elasticsearchBackendConfig == null ? Optional.empty() : elasticsearchBackendConfig.layout().strategy(), IndexLayoutStrategy.class, this.persistenceUnitName, backendName, null));
            this.contributeBackendIndexBuildTimeProperties(propertyCollector, backendName, null, elasticsearchBackendConfig == null ? null : elasticsearchBackendConfig.indexDefaults());
            for (String indexName : indexNames) {
                HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchIndexBuildTimeConfig indexConfig = elasticsearchBackendConfig == null ? null : elasticsearchBackendConfig.indexes().get(indexName);
                this.contributeBackendIndexBuildTimeProperties(propertyCollector, backendName, indexName, indexConfig);
            }
        }

        private void contributeBackendIndexBuildTimeProperties(BiConsumer<String, Object> propertyCollector, String backendName, String indexName, HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchIndexBuildTimeConfig indexConfig) {
            if (indexConfig != null) {
                HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "schema_management.settings_file", indexConfig.schemaManagement().settingsFile());
                HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "schema_management.mapping_file", indexConfig.schemaManagement().mappingFile());
            }
            HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "analysis.configurer", HibernateSearchBeanUtil.multiExtensionBeanReferencesFor(indexConfig == null ? Optional.empty() : indexConfig.analysis().configurer(), ElasticsearchAnalysisConfigurer.class, this.persistenceUnitName, backendName, indexName));
        }
    }

    private static final class HibernateSearchIntegrationStaticInitInactiveListener
    implements HibernateOrmIntegrationStaticInitListener {
        private HibernateSearchIntegrationStaticInitInactiveListener() {
        }

        public void contributeBootProperties(BiConsumer<String, Object> propertyCollector) {
            propertyCollector.accept("hibernate.search.enabled", false);
        }

        public void onMetadataInitialized(Metadata metadata, BootstrapContext bootstrapContext, BiConsumer<String, Object> propertyCollector) {
        }
    }

    private static final class HibernateSearchIntegrationRuntimeInitListener
    implements HibernateOrmIntegrationRuntimeInitListener {
        private final String persistenceUnitName;
        private final HibernateSearchElasticsearchRuntimeConfigPersistenceUnit runtimeConfig;
        private final Map<String, Set<String>> backendAndIndexNamesForSearchExtensions;
        private final List<HibernateOrmIntegrationRuntimeInitListener> integrationRuntimeInitListeners;

        private HibernateSearchIntegrationRuntimeInitListener(String persistenceUnitName, HibernateSearchElasticsearchRuntimeConfigPersistenceUnit runtimeConfig, Map<String, Set<String>> backendAndIndexNamesForSearchExtensions, List<HibernateOrmIntegrationRuntimeInitListener> integrationRuntimeInitListeners) {
            this.persistenceUnitName = persistenceUnitName;
            this.runtimeConfig = runtimeConfig;
            this.backendAndIndexNamesForSearchExtensions = backendAndIndexNamesForSearchExtensions;
            this.integrationRuntimeInitListeners = integrationRuntimeInitListeners;
        }

        public void contributeRuntimeProperties(BiConsumer<String, Object> propertyCollector) {
            if (this.runtimeConfig != null) {
                if (!this.runtimeConfig.active().orElse(true).booleanValue()) {
                    HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.enabled", false);
                    return;
                }
                HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.schema_management.strategy", this.runtimeConfig.schemaManagement().strategy());
                HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.automatic_indexing.enable_dirty_check", this.runtimeConfig.automaticIndexing().enableDirtyCheck());
                HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.query.loading.cache_lookup.strategy", this.runtimeConfig.queryLoading().cacheLookup().strategy());
                HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.query.loading.fetch_size", this.runtimeConfig.queryLoading().fetchSize());
                HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.multi_tenancy.tenant_ids", this.runtimeConfig.multiTenancy().tenantIds());
            }
            HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.indexing.plan.synchronization.strategy", HibernateSearchBeanUtil.singleExtensionBeanReferenceFor(this.runtimeConfig == null ? Optional.empty() : this.runtimeConfig.indexing().plan().synchronization().strategy(), IndexingPlanSynchronizationStrategy.class, this.persistenceUnitName, null, null));
            HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.automatic_indexing.synchronization.strategy", HibernateSearchBeanUtil.singleExtensionBeanReferenceFor(this.runtimeConfig == null ? Optional.empty() : this.runtimeConfig.automaticIndexing().synchronization().strategy(), AutomaticIndexingSynchronizationStrategy.class, this.persistenceUnitName, null, null));
            Map backendConfigs = this.runtimeConfig == null ? Collections.emptyMap() : this.runtimeConfig.backends();
            LinkedHashMap<String, Set<String>> backendAndIndexNames = new LinkedHashMap<String, Set<String>>();
            HibernateSearchElasticsearchRecorder.mergeInto(backendAndIndexNames, this.backendAndIndexNamesForSearchExtensions);
            for (Map.Entry entry : backendConfigs.entrySet()) {
                HibernateSearchElasticsearchRecorder.mergeInto(backendAndIndexNames, (String)entry.getKey(), ((HibernateSearchElasticsearchRuntimeConfigPersistenceUnit.ElasticsearchBackendRuntimeConfig)entry.getValue()).indexes().keySet());
            }
            for (Map.Entry entry : backendAndIndexNames.entrySet()) {
                String backendName = (String)entry.getKey();
                Set indexNames = (Set)entry.getValue();
                this.contributeBackendRuntimeProperties(propertyCollector, backendName, indexNames, (HibernateSearchElasticsearchRuntimeConfigPersistenceUnit.ElasticsearchBackendRuntimeConfig)backendConfigs.get(backendName));
            }
            for (HibernateOrmIntegrationRuntimeInitListener integrationRuntimeInitListener : this.integrationRuntimeInitListeners) {
                integrationRuntimeInitListener.contributeRuntimeProperties(propertyCollector);
            }
        }

        private void contributeBackendRuntimeProperties(BiConsumer<String, Object> propertyCollector, String backendName, Set<String> indexNames, HibernateSearchElasticsearchRuntimeConfigPersistenceUnit.ElasticsearchBackendRuntimeConfig elasticsearchBackendConfig) {
            if (elasticsearchBackendConfig != null) {
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "hosts", elasticsearchBackendConfig.hosts());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "protocol", elasticsearchBackendConfig.protocol().getHibernateSearchString());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "username", elasticsearchBackendConfig.username());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "password", elasticsearchBackendConfig.password());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "connection_timeout", elasticsearchBackendConfig.connectionTimeout().toMillis());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "read_timeout", elasticsearchBackendConfig.readTimeout().toMillis());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "request_timeout", elasticsearchBackendConfig.requestTimeout(), Optional::isPresent, d -> ((Duration)d.get()).toMillis());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "max_connections", elasticsearchBackendConfig.maxConnections());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "max_connections_per_route", elasticsearchBackendConfig.maxConnectionsPerRoute());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "thread_pool.size", elasticsearchBackendConfig.threadPool().size());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "version_check.enabled", elasticsearchBackendConfig.versionCheck().enabled());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "query.shard_failure.ignore", elasticsearchBackendConfig.query().shardFailure().ignore());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "discovery.enabled", elasticsearchBackendConfig.discovery().enabled());
                if (elasticsearchBackendConfig.discovery().enabled().booleanValue()) {
                    HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "discovery.refresh_interval", elasticsearchBackendConfig.discovery().refreshInterval().getSeconds());
                }
            }
            this.contributeBackendIndexRuntimeProperties(propertyCollector, backendName, null, elasticsearchBackendConfig == null ? null : elasticsearchBackendConfig.indexDefaults());
            for (String indexName : indexNames) {
                HibernateSearchElasticsearchRuntimeConfigPersistenceUnit.ElasticsearchIndexRuntimeConfig indexConfig = elasticsearchBackendConfig == null ? null : elasticsearchBackendConfig.indexes().get(indexName);
                this.contributeBackendIndexRuntimeProperties(propertyCollector, backendName, indexName, indexConfig);
            }
        }

        private void contributeBackendIndexRuntimeProperties(BiConsumer<String, Object> propertyCollector, String backendName, String indexName, HibernateSearchElasticsearchRuntimeConfigPersistenceUnit.ElasticsearchIndexRuntimeConfig indexConfig) {
            if (indexConfig != null) {
                HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "schema_management.minimal_required_status", indexConfig.schemaManagement().requiredStatus());
                HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "schema_management.minimal_required_status_wait_timeout", indexConfig.schemaManagement().requiredStatusWaitTimeout(), Optional::isPresent, d -> ((Duration)d.get()).toMillis());
                HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "indexing.queue_count", indexConfig.indexing().queueCount());
                HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "indexing.queue_size", indexConfig.indexing().queueSize());
                HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "indexing.max_bulk_size", indexConfig.indexing().maxBulkSize());
            }
        }

        public List<StandardServiceInitiator<?>> contributeServiceInitiators() {
            return List.of(new HibernateSearchPreIntegrationService.Initiator());
        }
    }

    private static final class HibernateSearchIntegrationRuntimeInitInactiveListener
    implements HibernateOrmIntegrationRuntimeInitListener {
        private HibernateSearchIntegrationRuntimeInitInactiveListener() {
        }

        public void contributeRuntimeProperties(BiConsumer<String, Object> propertyCollector) {
            propertyCollector.accept("hibernate.search.enabled", false);
        }

        public List<StandardServiceInitiator<?>> contributeServiceInitiators() {
            return List.of(new HibernateSearchPreIntegrationService.Initiator());
        }
    }
}

