/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationStaticConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchEnabled;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRecorder;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRuntimeConfig;
import java.util.List;

@BuildSteps(onlyIfNot={HibernateSearchEnabled.class})
class HibernateSearchElasticsearchDisabledProcessor {
    HibernateSearchElasticsearchDisabledProcessor() {
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void disableHibernateSearchStaticInit(HibernateSearchElasticsearchRecorder recorder, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<HibernateOrmIntegrationStaticConfiguredBuildItem> staticIntegrations) {
        for (PersistenceUnitDescriptorBuildItem puDescriptor : persistenceUnitDescriptorBuildItems) {
            String puName = puDescriptor.getPersistenceUnitName();
            staticIntegrations.produce((BuildItem)new HibernateOrmIntegrationStaticConfiguredBuildItem("Hibernate Search ORM + Elasticsearch", puName).setInitListener(recorder.createStaticInitInactiveListener()));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void disableHibernateSearchRuntimeInit(HibernateSearchElasticsearchRecorder recorder, HibernateSearchElasticsearchRuntimeConfig runtimeConfig, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeIntegrations) {
        recorder.checkNoExplicitActiveTrue(runtimeConfig);
        for (PersistenceUnitDescriptorBuildItem puDescriptor : persistenceUnitDescriptorBuildItems) {
            String puName = puDescriptor.getPersistenceUnitName();
            runtimeIntegrations.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem("Hibernate Search ORM + Elasticsearch", puName).setInitListener(recorder.createRuntimeInitInactiveListener()));
        }
    }
}

