/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.DevServicesAdditionalConfigBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.elasticsearch.restclient.common.deployment.DevservicesElasticsearchBuildItem;
import io.quarkus.elasticsearch.restclient.common.deployment.ElasticsearchCommonBuildTimeConfig;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationStaticConfiguredBuildItem;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeInitListener;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationStaticInitListener;
import io.quarkus.hibernate.search.backend.elasticsearch.common.deployment.HibernateSearchBackendElasticsearchEnabledBuildItem;
import io.quarkus.hibernate.search.backend.elasticsearch.common.runtime.ElasticsearchVersionSubstitution;
import io.quarkus.hibernate.search.backend.elasticsearch.common.runtime.HibernateSearchBackendElasticsearchBuildTimeConfig;
import io.quarkus.hibernate.search.backend.elasticsearch.common.runtime.MapperContext;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.ClassNames;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchEnabled;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchIntegrationStaticConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchManagementEnabled;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchBuildTimeConfig;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRecorder;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRuntimeConfig;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchOrmElasticsearchMapperContext;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.vertx.http.deployment.spi.RouteBuildItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategy;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={HibernateSearchEnabled.class})
class HibernateSearchElasticsearchProcessor {
    static final String HIBERNATE_SEARCH_ELASTICSEARCH = "Hibernate Search ORM + Elasticsearch";
    private static final Logger LOG = Logger.getLogger(HibernateSearchElasticsearchProcessor.class);

    HibernateSearchElasticsearchProcessor() {
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(HibernateSearchElasticsearchRecorder recorder, CombinedIndexBuildItem combinedIndexBuildItem, HibernateSearchElasticsearchBuildTimeConfig buildTimeConfig, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<HibernateOrmIntegrationStaticConfiguredBuildItem> staticIntegrations, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeIntegrations, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        IndexView index = combinedIndexBuildItem.getIndex();
        Collection indexedAnnotations = index.getAnnotations(ClassNames.INDEXED);
        Map<String, Map<String, Set<String>>> persistenceUnitAndBackendAndIndexNamesForSearchExtensions = HibernateSearchElasticsearchProcessor.collectPersistenceUnitAndBackendAndIndexNamesForSearchExtensions(index);
        Map configByPU = buildTimeConfig.persistenceUnits();
        for (PersistenceUnitDescriptorBuildItem puDescriptor : persistenceUnitDescriptorBuildItems) {
            ArrayList<AnnotationInstance> indexedAnnotationsForPU = new ArrayList<AnnotationInstance>();
            for (AnnotationInstance indexedAnnotation : indexedAnnotations) {
                String targetName = indexedAnnotation.target().asClass().name().toString();
                if (!puDescriptor.getManagedClassNames().contains(targetName)) continue;
                indexedAnnotationsForPU.add(indexedAnnotation);
            }
            Map<String, Set<String>> backendAndIndexNamesForSearchExtensions = persistenceUnitAndBackendAndIndexNamesForSearchExtensions.getOrDefault(puDescriptor.getPersistenceUnitName(), Collections.emptyMap());
            String puName = puDescriptor.getPersistenceUnitName();
            this.buildForPersistenceUnit(recorder, indexedAnnotationsForPU, puName, (HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit)configByPU.get(puName), backendAndIndexNamesForSearchExtensions, configuredPersistenceUnits, staticIntegrations, runtimeIntegrations);
        }
    }

    private static Map<String, Map<String, Set<String>>> collectPersistenceUnitAndBackendAndIndexNamesForSearchExtensions(IndexView index) {
        LinkedHashMap<String, Map<String, Set<String>>> result = new LinkedHashMap<String, Map<String, Set<String>>>();
        for (AnnotationInstance annotation : index.getAnnotations(ClassNames.SEARCH_EXTENSION)) {
            AnnotationValue puName = annotation.value("persistenceUnit");
            AnnotationValue backendName = annotation.value("backend");
            AnnotationValue indexName = annotation.value("index");
            Set indexNames = result.computeIfAbsent(puName == null ? "<default>" : puName.asString(), ignored -> new LinkedHashMap()).computeIfAbsent(backendName == null ? null : backendName.asString(), ignored -> new LinkedHashSet());
            if (indexName == null) continue;
            indexNames.add(indexName.asString());
        }
        return result;
    }

    private void buildForPersistenceUnit(HibernateSearchElasticsearchRecorder recorder, Collection<AnnotationInstance> indexedAnnotationsForPU, String persistenceUnitName, HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit puConfig, Map<String, Set<String>> backendAndIndexNamesForSearchExtensions, BuildProducer<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<HibernateOrmIntegrationStaticConfiguredBuildItem> staticIntegrations, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeIntegrations) {
        if (indexedAnnotationsForPU.isEmpty()) {
            staticIntegrations.produce((BuildItem)new HibernateOrmIntegrationStaticConfiguredBuildItem(HIBERNATE_SEARCH_ELASTICSEARCH, persistenceUnitName).setInitListener(recorder.createStaticInitInactiveListener()));
            runtimeIntegrations.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem(HIBERNATE_SEARCH_ELASTICSEARCH, persistenceUnitName).setInitListener(recorder.createRuntimeInitInactiveListener()));
            return;
        }
        LinkedHashSet<String> backendNamesForIndexedEntities = new LinkedHashSet<String>();
        for (AnnotationInstance indexedAnnotation : indexedAnnotationsForPU) {
            AnnotationValue backendNameValue = indexedAnnotation.value("backend");
            String backendName = backendNameValue == null ? null : backendNameValue.asString();
            backendNamesForIndexedEntities.add(backendName);
        }
        configuredPersistenceUnits.produce((BuildItem)new HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem(new HibernateSearchOrmElasticsearchMapperContext(persistenceUnitName, backendNamesForIndexedEntities, backendAndIndexNamesForSearchExtensions), puConfig));
    }

    @BuildStep
    void enableBackend(List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> enabledPUs, BuildProducer<HibernateSearchBackendElasticsearchEnabledBuildItem> elasticsearchEnabled) {
        for (HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem enabled : enabledPUs) {
            HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit buildTimeConfig = enabled.getBuildTimeConfig();
            elasticsearchEnabled.produce((BuildItem)new HibernateSearchBackendElasticsearchEnabledBuildItem((MapperContext)enabled.mapperContext, buildTimeConfig == null ? Collections.emptyMap() : buildTimeConfig.backends()));
        }
    }

    @BuildStep
    void registerBeans(List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> searchEnabledPUs, BuildProducer<UnremovableBeanBuildItem> unremovableBean) {
        if (searchEnabledPUs.isEmpty()) {
            return;
        }
        unremovableBean.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{FailureHandler.class, AutomaticIndexingSynchronizationStrategy.class, IndexingPlanSynchronizationStrategy.class}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setStaticConfig(RecorderContext recorderContext, HibernateSearchElasticsearchRecorder recorder, CombinedIndexBuildItem combinedIndexBuildItem, List<HibernateSearchIntegrationStaticConfiguredBuildItem> integrationStaticConfigBuildItems, List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, HibernateSearchElasticsearchBuildTimeConfig buildTimeConfig, BuildProducer<HibernateOrmIntegrationStaticConfiguredBuildItem> staticConfigured) {
        recorderContext.registerSubstitution(ElasticsearchVersion.class, String.class, ElasticsearchVersionSubstitution.class);
        IndexView index = combinedIndexBuildItem.getIndex();
        Set<String> rootAnnotationMappedClassNames = HibernateSearchElasticsearchProcessor.collectRootAnnotationMappedClassNames(index);
        for (HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem configuredPersistenceUnit : configuredPersistenceUnits) {
            String puName = configuredPersistenceUnit.getPersistenceUnitName();
            ArrayList<HibernateOrmIntegrationStaticInitListener> integrationStaticInitListeners = new ArrayList<HibernateOrmIntegrationStaticInitListener>();
            boolean xmlMappingRequired = false;
            for (HibernateSearchIntegrationStaticConfiguredBuildItem item : integrationStaticConfigBuildItems) {
                HibernateOrmIntegrationStaticInitListener listener;
                if (item.getPersistenceUnitName().equals(puName) && (listener = item.getInitListener()) != null) {
                    integrationStaticInitListeners.add(listener);
                }
                if (!item.isXmlMappingRequired()) continue;
                xmlMappingRequired = true;
            }
            staticConfigured.produce((BuildItem)new HibernateOrmIntegrationStaticConfiguredBuildItem(HIBERNATE_SEARCH_ELASTICSEARCH, puName).setInitListener(recorder.createStaticInitListener(configuredPersistenceUnit.mapperContext, buildTimeConfig, rootAnnotationMappedClassNames, integrationStaticInitListeners)).setXmlMappingRequired(xmlMappingRequired));
        }
    }

    private static Set<String> collectRootAnnotationMappedClassNames(IndexView index) {
        LinkedHashSet<DotName> rootMappingAnnotationNames = new LinkedHashSet<DotName>();
        rootMappingAnnotationNames.add(ClassNames.PROJECTION_CONSTRUCTOR);
        for (AnnotationInstance rootMappingAnnotationInstance : index.getAnnotations(ClassNames.ROOT_MAPPING)) {
            rootMappingAnnotationNames.add(rootMappingAnnotationInstance.target().asClass().name());
        }
        LinkedHashSet<String> rootAnnotationMappedClassNames = new LinkedHashSet<String>();
        for (DotName rootMappingAnnotationName : rootMappingAnnotationNames) {
            for (AnnotationInstance annotation : index.getAnnotations(rootMappingAnnotationName)) {
                rootAnnotationMappedClassNames.add(JandexUtil.getEnclosingClass((AnnotationInstance)annotation).name().toString());
            }
        }
        return rootAnnotationMappedClassNames;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setRuntimeConfig(HibernateSearchElasticsearchRecorder recorder, HibernateSearchElasticsearchRuntimeConfig runtimeConfig, List<HibernateSearchIntegrationRuntimeConfiguredBuildItem> integrationRuntimeConfigBuildItems, List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeConfigured) {
        for (HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem configuredPersistenceUnit : configuredPersistenceUnits) {
            String puName = configuredPersistenceUnit.getPersistenceUnitName();
            ArrayList<HibernateOrmIntegrationRuntimeInitListener> integrationRuntimeInitListeners = new ArrayList<HibernateOrmIntegrationRuntimeInitListener>();
            for (HibernateSearchIntegrationRuntimeConfiguredBuildItem item : integrationRuntimeConfigBuildItems) {
                HibernateOrmIntegrationRuntimeInitListener listener;
                if (!item.getPersistenceUnitName().equals(puName) || (listener = item.getInitListener()) == null) continue;
                integrationRuntimeInitListeners.add(listener);
            }
            runtimeConfigured.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem(HIBERNATE_SEARCH_ELASTICSEARCH, puName).setInitListener(recorder.createRuntimeInitListener(configuredPersistenceUnit.mapperContext, runtimeConfig, integrationRuntimeInitListeners)));
        }
    }

    @BuildStep(onlyIfNot={IsNormal.class})
    DevservicesElasticsearchBuildItem devServices(HibernateSearchElasticsearchBuildTimeConfig buildTimeConfig) {
        HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit defaultPUConfig = (HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit)buildTimeConfig.persistenceUnits().get("<default>");
        if (defaultPUConfig == null) {
            return null;
        }
        HibernateSearchBackendElasticsearchBuildTimeConfig defaultPUDefaultBackendConfig = (HibernateSearchBackendElasticsearchBuildTimeConfig)defaultPUConfig.backends().get(null);
        if (defaultPUDefaultBackendConfig == null || !defaultPUDefaultBackendConfig.version().isPresent()) {
            return null;
        }
        Optional active = ConfigUtils.getFirstOptionalValue((List)HibernateSearchElasticsearchRuntimeConfig.mapperPropertyKeys((String)"<default>", (String)"active"), Boolean.class);
        if (active.isPresent() && !((Boolean)active.get()).booleanValue()) {
            return null;
        }
        ElasticsearchVersion version = (ElasticsearchVersion)defaultPUDefaultBackendConfig.version().get();
        String hostsPropertyKey = HibernateSearchElasticsearchRuntimeConfig.backendPropertyKey((String)"<default>", null, null, (String)"hosts");
        return new DevservicesElasticsearchBuildItem(hostsPropertyKey, version.versionString(), ElasticsearchCommonBuildTimeConfig.ElasticsearchDevServicesBuildTimeConfig.Distribution.valueOf((String)version.distribution().toString().toUpperCase()));
    }

    @BuildStep(onlyIfNot={IsNormal.class})
    void devServicesDropAndCreateAndDropByDefault(List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<DevServicesAdditionalConfigBuildItem> devServicesAdditionalConfigProducer) {
        for (HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem configuredPersistenceUnit : configuredPersistenceUnits) {
            String schemaManagementStrategyPropertyKey;
            String puName = configuredPersistenceUnit.getPersistenceUnitName();
            List propertyKeysIndicatingHostsConfigured = HibernateSearchElasticsearchRuntimeConfig.defaultBackendPropertyKeys((String)puName, (String)"hosts");
            if (ConfigUtils.isAnyPropertyPresent((Collection)propertyKeysIndicatingHostsConfigured) || ConfigUtils.isPropertyPresent((String)(schemaManagementStrategyPropertyKey = HibernateSearchElasticsearchRuntimeConfig.mapperPropertyKey((String)puName, (String)"schema-management.strategy")))) continue;
            devServicesAdditionalConfigProducer.produce((BuildItem)new DevServicesAdditionalConfigBuildItem(devServicesConfig -> {
                if (propertyKeysIndicatingHostsConfigured.stream().anyMatch(devServicesConfig::containsKey)) {
                    String forcedValue = "drop-and-create-and-drop";
                    LOG.infof("Setting %s=%s to initialize Dev Services managed Elasticsearch server", (Object)schemaManagementStrategyPropertyKey, (Object)forcedValue);
                    return Map.of(schemaManagementStrategyPropertyKey, forcedValue);
                }
                return Map.of();
            }));
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={HibernateSearchManagementEnabled.class})
    void createManagementRoutes(BuildProducer<RouteBuildItem> routes, HibernateSearchElasticsearchRecorder recorder, HibernateSearchElasticsearchBuildTimeConfig hibernateSearchElasticsearchBuildTimeConfig) {
        String managementRootPath;
        routes.produce((BuildItem)RouteBuildItem.newManagementRoute((String)(managementRootPath + ((managementRootPath = hibernateSearchElasticsearchBuildTimeConfig.management().rootPath()).endsWith("/") ? "" : "/") + "reindex")).withRoutePathConfigKey("quarkus.hibernate-search-orm.management.root-path").withRequestHandler(recorder.managementHandler()).displayOnNotFoundPage().build());
    }
}

