/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.rest.data.panache.runtime;

import io.quarkus.rest.data.panache.RestDataPanacheException;
import io.smallrye.mutiny.CompositeException;
import jakarta.ws.rs.core.Response;
import org.hibernate.HibernateException;
import org.hibernate.exception.ConstraintViolationException;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;

public class RestDataPanacheExceptionMapper {
    private static final Logger LOGGER = Logger.getLogger(RestDataPanacheExceptionMapper.class);

    @ServerExceptionMapper(value={RestDataPanacheException.class, CompositeException.class})
    public RestResponse<Response> mapExceptions(Exception exception) {
        LOGGER.warnf((Throwable)exception, "Mapping an unhandled %s", (Object)exception.getClass().getSimpleName());
        RestResponse response = this.throwableToResponse(exception, exception.getMessage());
        if (response == null) {
            response = RestResponse.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (String)exception.getMessage());
        }
        return response;
    }

    private RestResponse<Response> throwableToResponse(Throwable throwable, String message) {
        if (throwable instanceof ConstraintViolationException || throwable instanceof HibernateException) {
            return RestResponse.status((int)Response.Status.CONFLICT.getStatusCode(), (String)message);
        }
        if (throwable instanceof jakarta.validation.ConstraintViolationException) {
            return RestResponse.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)message);
        }
        if (throwable instanceof CompositeException) {
            CompositeException compositeException = (CompositeException)throwable;
            for (Throwable cause : compositeException.getCauses()) {
                RestResponse<Response> response = this.throwableToResponse(cause, message);
                if (response == null) continue;
                return response;
            }
        } else if (throwable.getCause() != null) {
            return this.throwableToResponse(throwable.getCause(), message);
        }
        return null;
    }
}

