/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.rest.data.panache.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.hibernate.reactive.panache.PanacheQuery;
import io.quarkus.hibernate.reactive.panache.PanacheRepositoryBase;
import io.quarkus.hibernate.reactive.rest.data.panache.deployment.DataAccessImplementor;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Sort;
import io.quarkus.rest.data.panache.deployment.utils.UniImplementor;
import io.smallrye.mutiny.Uni;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.reactive.mutiny.Mutiny;

final class RepositoryDataAccessImplementor
implements DataAccessImplementor {
    private final String repositoryClassName;

    RepositoryDataAccessImplementor(String repositoryClassName) {
        this.repositoryClassName = repositoryClassName;
    }

    @Override
    public ResultHandle findById(BytecodeCreator creator, ResultHandle id) {
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheRepositoryBase.class, (String)"findById", Uni.class, (Class[])new Class[]{Object.class}), this.getRepositoryInstance(creator), new ResultHandle[]{id});
    }

    @Override
    public ResultHandle findAll(BytecodeCreator creator, ResultHandle page) {
        ResultHandle query = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheRepositoryBase.class, (String)"findAll", PanacheQuery.class, (Class[])new Class[0]), this.getRepositoryInstance(creator), new ResultHandle[0]);
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{Page.class}), query, new ResultHandle[]{page});
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", Uni.class, (Class[])new Class[0]), query, new ResultHandle[0]);
    }

    @Override
    public ResultHandle findAll(BytecodeCreator creator, ResultHandle page, ResultHandle sort) {
        ResultHandle query = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheRepositoryBase.class, (String)"findAll", PanacheQuery.class, (Class[])new Class[]{Sort.class}), this.getRepositoryInstance(creator), new ResultHandle[]{sort});
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{Page.class}), query, new ResultHandle[]{page});
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", Uni.class, (Class[])new Class[0]), query, new ResultHandle[0]);
    }

    @Override
    public ResultHandle findAll(BytecodeCreator creator, ResultHandle page, ResultHandle query, ResultHandle queryParams) {
        ResultHandle panacheQuery = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheRepositoryBase.class, (String)"find", PanacheQuery.class, (Class[])new Class[]{String.class, Map.class}), this.getRepositoryInstance(creator), new ResultHandle[]{query, queryParams});
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{Page.class}), panacheQuery, new ResultHandle[]{page});
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", Uni.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
    }

    @Override
    public ResultHandle findAll(BytecodeCreator creator, ResultHandle page, ResultHandle sort, ResultHandle query, ResultHandle queryParams) {
        ResultHandle panacheQuery = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheRepositoryBase.class, (String)"find", PanacheQuery.class, (Class[])new Class[]{String.class, Sort.class, Map.class}), this.getRepositoryInstance(creator), new ResultHandle[]{query, sort, queryParams});
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{Page.class}), panacheQuery, new ResultHandle[]{page});
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", Uni.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
    }

    @Override
    public ResultHandle persist(BytecodeCreator creator, ResultHandle entity) {
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheRepositoryBase.class, (String)"persist", Uni.class, (Class[])new Class[]{Object.class}), this.getRepositoryInstance(creator), new ResultHandle[]{entity});
    }

    @Override
    public ResultHandle update(BytecodeCreator creator, ResultHandle entity) {
        ResultHandle uniSession = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheRepositoryBase.class, (String)"getSession", Uni.class, (Class[])new Class[0]), this.getRepositoryInstance(creator), new ResultHandle[0]);
        return UniImplementor.flatMap((BytecodeCreator)creator, (ResultHandle)uniSession, (String)"Failed to retrieve session", (body, session) -> body.returnValue(body.invokeInterfaceMethod(MethodDescriptor.ofMethod(Mutiny.Session.class, (String)"merge", Uni.class, (Class[])new Class[]{Object.class}), session, new ResultHandle[]{entity})));
    }

    @Override
    public ResultHandle deleteById(BytecodeCreator creator, ResultHandle id) {
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheRepositoryBase.class, (String)"deleteById", Uni.class, (Class[])new Class[]{Object.class}), this.getRepositoryInstance(creator), new ResultHandle[]{id});
    }

    @Override
    public ResultHandle pageCount(BytecodeCreator creator, ResultHandle page, ResultHandle query, ResultHandle queryParams) {
        ResultHandle panacheQuery = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheRepositoryBase.class, (String)"find", PanacheQuery.class, (Class[])new Class[]{String.class, Map.class}), this.getRepositoryInstance(creator), new ResultHandle[]{query, queryParams});
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{Page.class}), panacheQuery, new ResultHandle[]{page});
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"pageCount", Uni.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
    }

    @Override
    public ResultHandle count(BytecodeCreator creator) {
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheRepositoryBase.class, (String)"count", Uni.class, (Class[])new Class[0]), this.getRepositoryInstance(creator), new ResultHandle[0]);
    }

    private ResultHandle getRepositoryInstance(BytecodeCreator creator) {
        ResultHandle arcContainer = creator.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle instanceHandle = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), arcContainer, new ResultHandle[]{creator.loadClass(this.repositoryClassName), creator.newArray(Annotation.class, 0)});
        ResultHandle instance = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        creator.ifNull(instance).trueBranch().throwException(RuntimeException.class, this.repositoryClassName + " instance was not found");
        return instance;
    }
}

