/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.deployment;

import io.quarkus.arc.deployment.RecorderBeanInitializedBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfigPersistenceUnit;
import io.quarkus.hibernate.orm.deployment.HibernateOrmProcessor;
import io.quarkus.hibernate.orm.deployment.JpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceProviderSetUpBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceXmlDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.orm.deployment.spi.DatabaseKindDialectBuildItem;
import io.quarkus.hibernate.orm.deployment.util.HibernateProcessorUtil;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDescriptor;
import io.quarkus.hibernate.orm.runtime.customized.BuiltinFormatMapperBehaviour;
import io.quarkus.hibernate.orm.runtime.customized.FormatMapperKind;
import io.quarkus.hibernate.orm.runtime.migration.MultiTenancyStrategy;
import io.quarkus.hibernate.orm.runtime.recording.RecordedConfig;
import io.quarkus.hibernate.reactive.deployment.HibernateReactiveEnabled;
import io.quarkus.hibernate.reactive.runtime.FastBootHibernateReactivePersistenceProvider;
import io.quarkus.hibernate.reactive.runtime.HibernateReactiveRecorder;
import io.quarkus.reactive.datasource.deployment.VertxPoolBuildItem;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveBuildTimeConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.persistence.PersistenceUnitTransactionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.hibernate.reactive.provider.impl.ReactiveIntegrator;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={HibernateReactiveEnabled.class})
public final class HibernateReactiveProcessor {
    private static final String HIBERNATE_REACTIVE = "Hibernate Reactive";
    private static final Logger LOG = Logger.getLogger(HibernateReactiveProcessor.class);
    static final String[] REFLECTIVE_CONSTRUCTORS_NEEDED = new String[]{"org.hibernate.reactive.persister.entity.impl.ReactiveSingleTableEntityPersister", "org.hibernate.reactive.persister.entity.impl.ReactiveJoinedSubclassEntityPersister", "org.hibernate.reactive.persister.entity.impl.ReactiveUnionSubclassEntityPersister", "org.hibernate.reactive.persister.collection.impl.ReactiveOneToManyPersister", "org.hibernate.reactive.persister.collection.impl.ReactiveBasicCollectionPersister"};

    @BuildStep
    void registerServicesForReflection(BuildProducer<ServiceProviderBuildItem> services) {
        services.produce((BuildItem)new ServiceProviderBuildItem("io.vertx.core.spi.VertxServiceProvider", new String[]{"org.hibernate.reactive.context.impl.ContextualDataStorage"}));
    }

    @BuildStep
    void reflections(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, REFLECTIVE_CONSTRUCTORS_NEEDED));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(HibernateReactiveRecorder recorder, JpaModelBuildItem jpaModel) {
        boolean enableRx = HibernateProcessorUtil.hasEntities((JpaModelBuildItem)jpaModel);
        recorder.callHibernateReactiveFeatureInit(enableRx);
    }

    @BuildStep
    public void buildReactivePersistenceUnit(HibernateOrmConfig hibernateOrmConfig, CombinedIndexBuildItem index, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, List<PersistenceXmlDescriptorBuildItem> persistenceXmlDescriptors, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchModeBuildItem launchMode, JpaModelBuildItem jpaModel, Capabilities capabilities, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, BuildProducer<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, List<DatabaseKindDialectBuildItem> dbKindDialectBuildItems) {
        boolean enableHR = HibernateProcessorUtil.hasEntities((JpaModelBuildItem)jpaModel);
        if (!enableHR) {
            LOG.warn((Object)"Hibernate Reactive is disabled because no JPA entities were found");
            return;
        }
        for (PersistenceXmlDescriptorBuildItem persistenceXmlDescriptorBuildItem : persistenceXmlDescriptors) {
            String provider = persistenceXmlDescriptorBuildItem.getDescriptor().getProviderClassName();
            if (provider != null && !provider.equals(FastBootHibernateReactivePersistenceProvider.class.getCanonicalName()) && !provider.equals("org.hibernate.reactive.provider.ReactivePersistenceProvider")) continue;
            throw new ConfigurationException("Cannot use persistence.xml with Hibernate Reactive in Quarkus. Must use application.properties instead.");
        }
        HibernateOrmConfigPersistenceUnit persistenceUnitConfig = hibernateOrmConfig.defaultPersistenceUnit();
        String datasourceNameFromConf = persistenceUnitConfig.datasource().orElse("<default>");
        DataSourceBuildTimeConfig defaultDataSourceBuildTimeConfig = (DataSourceBuildTimeConfig)dataSourcesBuildTimeConfig.dataSources().get("<default>");
        DataSourceBuildTimeConfig dataSourceBuildTimeConfig = (DataSourceBuildTimeConfig)dataSourcesBuildTimeConfig.dataSources().get(datasourceNameFromConf);
        Optional<String> datasourceName = Optional.of(datasourceNameFromConf);
        Optional explicitDialect = hibernateOrmConfig.defaultPersistenceUnit().dialect().dialect();
        Optional explicitDbMinVersion = defaultDataSourceBuildTimeConfig.dbVersion();
        Optional dbKindOptional = DefaultDataSourceDbKindBuildItem.resolve((Optional)dataSourceBuildTimeConfig.dbKind(), defaultDataSourceDbKindBuildItems, (boolean)defaultDataSourceBuildTimeConfig.devservices().enabled().orElse(!dataSourcesBuildTimeConfig.hasNamedDataSources()), (CurateOutcomeBuildItem)curateOutcomeBuildItem);
        Optional dbVersion = dataSourceBuildTimeConfig.dbVersion();
        if (dbKindOptional.isEmpty()) {
            throw new ConfigurationException("The datasource must be configured for Hibernate Reactive. Refer to https://quarkus.io/guides/datasource for guidance.", Set.of("quarkus.datasource.db-kind", "quarkus.datasource.username", "quarkus.datasource.password"));
        }
        DataSourcesReactiveBuildTimeConfig.DataSourceReactiveOuterNamedBuildTimeConfig dataSourceReactiveBuildTimeConfig = (DataSourcesReactiveBuildTimeConfig.DataSourceReactiveOuterNamedBuildTimeConfig)dataSourcesReactiveBuildTimeConfig.dataSources().get(datasourceNameFromConf);
        if (dataSourceReactiveBuildTimeConfig == null || !dataSourceReactiveBuildTimeConfig.reactive().enabled()) {
            LOG.warn((Object)"Hibernate Reactive is disabled because the datasource is not reactive");
            return;
        }
        QuarkusPersistenceUnitDescriptor reactivePU = HibernateReactiveProcessor.generateReactivePersistenceUnit(hibernateOrmConfig, index, persistenceUnitConfig, jpaModel, dbKindOptional, explicitDialect, explicitDbMinVersion, applicationArchivesBuildItem, launchMode.getLaunchMode(), systemProperties, nativeImageResources, hotDeploymentWatchedFiles, dbKindDialectBuildItems);
        Optional jsonMapper = HibernateProcessorUtil.jsonMapperKind((Capabilities)capabilities, (BuiltinFormatMapperBehaviour)hibernateOrmConfig.mapping().format().global());
        Optional xmlMapper = HibernateProcessorUtil.xmlMapperKind((Capabilities)capabilities, (BuiltinFormatMapperBehaviour)hibernateOrmConfig.mapping().format().global());
        jsonMapper.flatMap(FormatMapperKind::requiredBeanType).ifPresent(type -> unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{type})));
        xmlMapper.flatMap(FormatMapperKind::requiredBeanType).ifPresent(type -> unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{type})));
        persistenceUnitDescriptors.produce((BuildItem)new PersistenceUnitDescriptorBuildItem(reactivePU, new RecordedConfig(datasourceName, dbKindOptional, dbVersion, persistenceUnitConfig.dialect().dialect(), MultiTenancyStrategy.NONE, hibernateOrmConfig.database().ormCompatibilityVersion(), hibernateOrmConfig.mapping().format().global(), persistenceUnitConfig.unsupportedProperties()), null, jpaModel.getXmlMappings(reactivePU.getName()), false, HibernateProcessorUtil.isHibernateValidatorPresent((Capabilities)capabilities), jsonMapper, xmlMapper));
    }

    @BuildStep
    @Consume(value=VertxPoolBuildItem.class)
    void waitForVertxPool(List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeConfigured) {
        for (PersistenceUnitDescriptorBuildItem puDescriptor : persistenceUnitDescriptorBuildItems) {
            runtimeConfigured.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem(HIBERNATE_REACTIVE, puDescriptor.getPersistenceUnitName()));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    PersistenceProviderSetUpBuildItem setUpPersistenceProviderAndWaitForVertxPool(HibernateReactiveRecorder recorder, List<HibernateOrmIntegrationRuntimeConfiguredBuildItem> integrationBuildItems, BuildProducer<RecorderBeanInitializedBuildItem> orderEnforcer) {
        recorder.initializePersistenceProvider(HibernateOrmIntegrationRuntimeConfiguredBuildItem.collectDescriptors(integrationBuildItems));
        return new PersistenceProviderSetUpBuildItem();
    }

    @BuildStep
    void silenceLogging(BuildProducer<LogCategoryBuildItem> logCategories) {
        logCategories.produce((BuildItem)new LogCategoryBuildItem(ReactiveIntegrator.class.getName(), Level.WARNING));
    }

    private static QuarkusPersistenceUnitDescriptor generateReactivePersistenceUnit(HibernateOrmConfig hibernateOrmConfig, CombinedIndexBuildItem index, HibernateOrmConfigPersistenceUnit persistenceUnitConfig, JpaModelBuildItem jpaModel, Optional<String> dbKindOptional, Optional<String> explicitDialect, Optional<String> explicitDbMinVersion, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchMode launchMode, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, List<DatabaseKindDialectBuildItem> dbKindDialectBuildItems) {
        Set modelClassesAndPackages;
        String persistenceUnitConfigName = "<default>";
        Map modelClassesAndPackagesPerPersistencesUnits = HibernateOrmProcessor.getModelClassesAndPackagesPerPersistenceUnits((HibernateOrmConfig)hibernateOrmConfig, (JpaModelBuildItem)jpaModel, (IndexView)index.getIndex(), (boolean)true);
        Set nonDefaultPUWithModelClassesOrPackages = modelClassesAndPackagesPerPersistencesUnits.entrySet().stream().filter(e -> !"<default>".equals(e.getKey()) && !((Set)e.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!nonDefaultPUWithModelClassesOrPackages.isEmpty()) {
            LOG.warnf("Entities are affected to non-default Hibernate Reactive persistence units %s. Since Hibernate Reactive only works with the default persistence unit, those entities will be ignored.", nonDefaultPUWithModelClassesOrPackages);
        }
        if ((modelClassesAndPackages = modelClassesAndPackagesPerPersistencesUnits.getOrDefault("<default>", Collections.emptySet())).isEmpty()) {
            LOG.warnf("Could not find any entities affected to the Hibernate Reactive persistence unit.", new Object[0]);
        }
        QuarkusPersistenceUnitDescriptor descriptor = new QuarkusPersistenceUnitDescriptor("default-reactive", "<default>", PersistenceUnitTransactionType.RESOURCE_LOCAL, new ArrayList(modelClassesAndPackages), new Properties(), true);
        HashSet storageEngineCollector = new HashSet();
        HibernateProcessorUtil.setDialectAndStorageEngine((String)"<default>", dbKindOptional, explicitDialect, explicitDbMinVersion, dbKindDialectBuildItems, (Optional)persistenceUnitConfig.dialect().storageEngine(), systemProperties, descriptor.getProperties()::setProperty, storageEngineCollector);
        HibernateProcessorUtil.configureProperties((QuarkusPersistenceUnitDescriptor)descriptor, (HibernateOrmConfigPersistenceUnit)persistenceUnitConfig, (HibernateOrmConfig)hibernateOrmConfig, (boolean)true);
        HibernateProcessorUtil.configureSqlLoadScript((String)"<default>", (HibernateOrmConfigPersistenceUnit)persistenceUnitConfig, (ApplicationArchivesBuildItem)applicationArchivesBuildItem, (LaunchMode)launchMode, nativeImageResources, hotDeploymentWatchedFiles, (QuarkusPersistenceUnitDescriptor)descriptor);
        return descriptor;
    }
}

