/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.rest.data.panache.deployment;

import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.hibernate.orm.rest.data.panache.deployment.DataAccessImplementor;
import io.quarkus.hibernate.orm.rest.data.panache.deployment.EntityClassHelper;
import io.quarkus.hibernate.orm.rest.data.panache.deployment.HibernateORMResourceMethodListenerImplementor;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Sort;
import io.quarkus.runtime.util.HashUtil;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Alternative;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.logging.Logger;

class ResourceImplementor {
    private static final Logger LOGGER = Logger.getLogger(ResourceImplementor.class);
    private final EntityClassHelper entityClassHelper;

    ResourceImplementor(EntityClassHelper entityClassHelper) {
        this.entityClassHelper = entityClassHelper;
    }

    String implement(ClassOutput classOutput, DataAccessImplementor dataAccessImplementor, ClassInfo resourceInterface, String entityType, List<ClassInfo> resourceMethodListeners) {
        String resourceType = resourceInterface.name().toString();
        String className = resourceType + "Impl_" + HashUtil.sha1((String)resourceType);
        LOGGER.tracef("Starting generation of '%s'", (Object)className);
        ClassCreator classCreator = ClassCreator.builder().classOutput(classOutput).className(className).interfaces(new String[]{resourceType}).build();
        classCreator.addAnnotation(ApplicationScoped.class);
        classCreator.addAnnotation(Alternative.class);
        classCreator.addAnnotation(Priority.class).add("value", (Object)Integer.MAX_VALUE);
        HibernateORMResourceMethodListenerImplementor listenerImplementor = new HibernateORMResourceMethodListenerImplementor(classCreator, resourceMethodListeners);
        this.implementList(classCreator, dataAccessImplementor);
        this.implementListWithQuery(classCreator, dataAccessImplementor);
        this.implementListPageCount(classCreator, dataAccessImplementor);
        this.implementCount(classCreator, dataAccessImplementor);
        this.implementGet(classCreator, dataAccessImplementor);
        this.implementAdd(classCreator, dataAccessImplementor, listenerImplementor);
        this.implementUpdate(classCreator, dataAccessImplementor, entityType, listenerImplementor);
        this.implementDelete(classCreator, dataAccessImplementor, listenerImplementor);
        classCreator.close();
        LOGGER.tracef("Completed generation of '%s'", (Object)className);
        return className;
    }

    private void implementList(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("list", List.class, new Class[]{Page.class, Sort.class});
        ResultHandle page = methodCreator.getMethodParam(0);
        ResultHandle sort = methodCreator.getMethodParam(1);
        ResultHandle columns = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Sort.class, (String)"getColumns", List.class, (Class[])new Class[0]), sort, new ResultHandle[0]);
        ResultHandle isEmptySort = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"isEmpty", Boolean.TYPE, (Class[])new Class[0]), columns, new ResultHandle[0]);
        BranchResult isEmptySortBranch = methodCreator.ifTrue(isEmptySort);
        isEmptySortBranch.trueBranch().returnValue(dataAccessImplementor.findAll(isEmptySortBranch.trueBranch(), page));
        isEmptySortBranch.falseBranch().returnValue(dataAccessImplementor.findAll(isEmptySortBranch.falseBranch(), page, sort));
        methodCreator.close();
    }

    private void implementListWithQuery(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("list", List.class, new Class[]{Page.class, Sort.class, String.class, Map.class});
        ResultHandle page = methodCreator.getMethodParam(0);
        ResultHandle sort = methodCreator.getMethodParam(1);
        ResultHandle query = methodCreator.getMethodParam(2);
        ResultHandle queryParams = methodCreator.getMethodParam(3);
        ResultHandle columns = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Sort.class, (String)"getColumns", List.class, (Class[])new Class[0]), sort, new ResultHandle[0]);
        ResultHandle isEmptySort = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"isEmpty", Boolean.TYPE, (Class[])new Class[0]), columns, new ResultHandle[0]);
        BranchResult isEmptySortBranch = methodCreator.ifTrue(isEmptySort);
        isEmptySortBranch.trueBranch().returnValue(dataAccessImplementor.findAll(isEmptySortBranch.trueBranch(), page, query, queryParams));
        isEmptySortBranch.falseBranch().returnValue(dataAccessImplementor.findAll(isEmptySortBranch.falseBranch(), page, sort, query, queryParams));
        methodCreator.close();
    }

    private void implementListPageCount(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("$$_page_count_list", Integer.TYPE, new Class[]{Page.class, String.class, Map.class});
        ResultHandle page = methodCreator.getMethodParam(0);
        ResultHandle query = methodCreator.getMethodParam(1);
        ResultHandle queryParams = methodCreator.getMethodParam(2);
        methodCreator.returnValue(dataAccessImplementor.pageCount((BytecodeCreator)methodCreator, page, query, queryParams));
        methodCreator.close();
    }

    private void implementCount(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("count", Long.TYPE, new Class[0]);
        methodCreator.returnValue(dataAccessImplementor.count((BytecodeCreator)methodCreator));
        methodCreator.close();
    }

    private void implementGet(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("get", Object.class, new Class[]{Object.class});
        ResultHandle id = methodCreator.getMethodParam(0);
        methodCreator.returnValue(dataAccessImplementor.findById((BytecodeCreator)methodCreator, id));
        methodCreator.close();
    }

    private void implementAdd(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor, HibernateORMResourceMethodListenerImplementor resourceMethodListenerImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("add", Object.class, new Class[]{Object.class});
        methodCreator.addAnnotation(Transactional.class);
        ResultHandle entity = methodCreator.getMethodParam(0);
        resourceMethodListenerImplementor.onBeforeAdd((BytecodeCreator)methodCreator, entity);
        ResultHandle createdEntity = dataAccessImplementor.persist((BytecodeCreator)methodCreator, entity);
        resourceMethodListenerImplementor.onAfterAdd((BytecodeCreator)methodCreator, createdEntity);
        methodCreator.returnValue(createdEntity);
        methodCreator.close();
    }

    private void implementUpdate(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor, String entityType, HibernateORMResourceMethodListenerImplementor resourceMethodListenerImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("update", Object.class, new Class[]{Object.class, Object.class});
        methodCreator.addAnnotation(Transactional.class);
        ResultHandle id = methodCreator.getMethodParam(0);
        ResultHandle entity = methodCreator.getMethodParam(1);
        this.setId((BytecodeCreator)methodCreator, entityType, entity, id);
        resourceMethodListenerImplementor.onBeforeUpdate((BytecodeCreator)methodCreator, entity);
        ResultHandle updatedEntity = dataAccessImplementor.update((BytecodeCreator)methodCreator, entity);
        resourceMethodListenerImplementor.onAfterUpdate((BytecodeCreator)methodCreator, updatedEntity);
        methodCreator.returnValue(updatedEntity);
        methodCreator.close();
    }

    private void implementDelete(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor, HibernateORMResourceMethodListenerImplementor resourceMethodListenerImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("delete", Boolean.TYPE, new Class[]{Object.class});
        methodCreator.addAnnotation(Transactional.class);
        ResultHandle id = methodCreator.getMethodParam(0);
        resourceMethodListenerImplementor.onBeforeDelete((BytecodeCreator)methodCreator, id);
        ResultHandle deleted = dataAccessImplementor.deleteById((BytecodeCreator)methodCreator, id);
        resourceMethodListenerImplementor.onAfterDelete((BytecodeCreator)methodCreator, id);
        methodCreator.returnValue(deleted);
        methodCreator.close();
    }

    private void setId(BytecodeCreator creator, String entityType, ResultHandle entity, ResultHandle id) {
        FieldInfo idField = this.entityClassHelper.getIdField(entityType);
        MethodDescriptor idSetter = this.entityClassHelper.getSetter(entityType, idField);
        creator.invokeVirtualMethod(idSetter, entity, new ResultHandle[]{id});
    }
}

