/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.kotlin.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.hibernate.orm.deployment.JpaModelPersistenceUnitMappingBuildItem;
import io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.orm.panache.kotlin.PanacheEntity;
import io.quarkus.hibernate.orm.panache.kotlin.deployment.KotlinJpaTypeBundle;
import io.quarkus.hibernate.orm.panache.kotlin.runtime.PanacheKotlinHibernateOrmRecorder;
import io.quarkus.panache.common.deployment.ByteCodeType;
import io.quarkus.panache.common.deployment.KotlinPanacheCompanionEnhancer;
import io.quarkus.panache.common.deployment.KotlinPanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.KotlinPanacheRepositoryEnhancer;
import io.quarkus.panache.common.deployment.PanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizerBuildItem;
import io.quarkus.panache.common.deployment.PanacheRepositoryEnhancer;
import io.quarkus.panache.common.deployment.TypeBundle;
import io.quarkus.panache.hibernate.common.deployment.HibernateEnhancersRegisteredBuildItem;
import jakarta.persistence.Id;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public final class KotlinPanacheResourceProcessor {
    private static final DotName DOTNAME_ID = DotName.createSimple((String)Id.class.getName());
    private static final DotName DOTNAME_PANACHE_ENTITY = DotName.createSimple((String)PanacheEntity.class.getName());
    private static final Set<DotName> UNREMOVABLE_BEANS = Collections.singleton(DotName.createSimple((String)Session.class.getName()));

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    @Consume(value=HibernateEnhancersRegisteredBuildItem.class)
    void build(PanacheKotlinHibernateOrmRecorder recorder, CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, List<PanacheMethodCustomizerBuildItem> methodCustomizersBuildItems, Optional<JpaModelPersistenceUnitMappingBuildItem> jpaModelPersistenceUnitMapping) {
        List<PanacheMethodCustomizer> methodCustomizers = methodCustomizersBuildItems.stream().map(bi -> bi.getMethodCustomizer()).collect(Collectors.toList());
        TypeBundle bundle = KotlinJpaTypeBundle.BUNDLE;
        this.processRepositories(index, transformers, reflectiveClass, this.createRepositoryEnhancer(index, methodCustomizers), bundle.repositoryBase(), bundle.repository());
        this.processEntities(index, transformers, reflectiveClass, recorder, jpaModelPersistenceUnitMapping, this.createEntityEnhancer(index, methodCustomizers), bundle.entityBase(), bundle.entity());
        this.processCompanions(index, transformers, reflectiveClass, this.createCompanionEnhancer(index, methodCustomizers), bundle.entityCompanionBase(), bundle.entityCompanion());
    }

    private PanacheEntityEnhancer createEntityEnhancer(CombinedIndexBuildItem index, List<PanacheMethodCustomizer> methodCustomizers) {
        return new KotlinPanacheEntityEnhancer(index.getIndex(), methodCustomizers, KotlinJpaTypeBundle.BUNDLE);
    }

    private PanacheRepositoryEnhancer createRepositoryEnhancer(CombinedIndexBuildItem index, List<PanacheMethodCustomizer> methodCustomizers) {
        return new KotlinPanacheRepositoryEnhancer(index.getIndex(), methodCustomizers, KotlinJpaTypeBundle.BUNDLE);
    }

    private KotlinPanacheCompanionEnhancer createCompanionEnhancer(CombinedIndexBuildItem index, List<PanacheMethodCustomizer> customizers) {
        return new KotlinPanacheCompanionEnhancer(index.getIndex(), customizers, KotlinJpaTypeBundle.BUNDLE);
    }

    @BuildStep
    UnremovableBeanBuildItem ensureBeanLookupAvailable() {
        return new UnremovableBeanBuildItem((Predicate)new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo beanInfo) {
                for (Type t : beanInfo.getTypes()) {
                    if (!UNREMOVABLE_BEANS.contains(t.name())) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem(Feature.HIBERNATE_ORM_PANACHE_KOTLIN);
    }

    private void processEntities(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, PanacheKotlinHibernateOrmRecorder recorder, Optional<JpaModelPersistenceUnitMappingBuildItem> jpaModelPersistenceUnitMapping, PanacheEntityEnhancer entityEnhancer, ByteCodeType baseType, ByteCodeType type) {
        boolean incomplete;
        Map collectedEntityToPersistenceUnits;
        HashSet<String> modelClasses = new HashSet<String>();
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(baseType.dotName())) {
            String name;
            if (classInfo.name().equals((Object)type.dotName()) || !modelClasses.add(name = classInfo.name().toString())) continue;
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(name, (BiFunction)entityEnhancer));
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{name}).methods().fields().build());
        }
        if (jpaModelPersistenceUnitMapping.isPresent()) {
            collectedEntityToPersistenceUnits = jpaModelPersistenceUnitMapping.get().getEntityToPersistenceUnits();
            incomplete = jpaModelPersistenceUnitMapping.get().isIncomplete();
        } else {
            collectedEntityToPersistenceUnits = new HashMap();
            incomplete = false;
        }
        HashMap<String, String> panacheEntityToPersistenceUnit = new HashMap<String, String>();
        for (Map.Entry entry : collectedEntityToPersistenceUnits.entrySet()) {
            String entityName = (String)entry.getKey();
            ArrayList selectedPersistenceUnits = new ArrayList((Collection)entry.getValue());
            boolean isPanacheEntity = modelClasses.contains(entityName);
            if (selectedPersistenceUnits.size() > 1 && isPanacheEntity) {
                throw new IllegalStateException(String.format("PanacheEntity '%s' cannot be defined for usage in several persistence units which is not supported. The following persistence units were found: %s.", entityName, String.join((CharSequence)",", selectedPersistenceUnits)));
            }
            panacheEntityToPersistenceUnit.put(entityName, (String)selectedPersistenceUnits.get(0));
        }
        recorder.setEntityToPersistenceUnit(panacheEntityToPersistenceUnit, incomplete);
    }

    private void processRepositories(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, PanacheRepositoryEnhancer enhancer, ByteCodeType baseType, ByteCodeType type) {
        HashSet typeParameters = new HashSet();
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(baseType.dotName())) {
            if (classInfo.name().equals((Object)type.dotName()) || enhancer.skipRepository(classInfo)) continue;
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.name().toString(), (BiFunction)enhancer));
            typeParameters.addAll(JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)baseType.dotName(), (IndexView)index.getIndex()));
        }
        for (Type parameterType : typeParameters) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{parameterType.name().toString()}).methods().fields().build());
        }
    }

    private void processCompanions(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, KotlinPanacheCompanionEnhancer enhancer, ByteCodeType baseType, ByteCodeType type) {
        HashSet typeParameters = new HashSet();
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(baseType.dotName())) {
            if (classInfo.name().equals((Object)type.dotName())) continue;
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.name().toString(), (BiFunction)enhancer));
            typeParameters.addAll(JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)baseType.dotName(), (IndexView)index.getIndex()));
        }
        for (Type parameterType : typeParameters) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{parameterType.name().toString()}).methods().fields().build());
        }
    }

    @BuildStep
    AdditionalJpaModelBuildItem produceModel() {
        return new AdditionalJpaModelBuildItem("io.quarkus.hibernate.orm.panache.kotlin.PanacheEntity", Set.of());
    }

    @BuildStep
    ValidationPhaseBuildItem.ValidationErrorBuildItem validate(ValidationPhaseBuildItem validationPhase, CombinedIndexBuildItem index) throws BuildException {
        for (AnnotationInstance annotationInstance : index.getIndex().getAnnotations(DOTNAME_ID)) {
            ClassInfo info = JandexUtil.getEnclosingClass((AnnotationInstance)annotationInstance);
            if (!JandexUtil.isSubclassOf((IndexView)index.getIndex(), (ClassInfo)info, (DotName)DOTNAME_PANACHE_ENTITY)) continue;
            BuildException be = new BuildException("You provide a JPA identifier via @Id inside '" + String.valueOf(info.name()) + "' but one is already provided by PanacheEntity, your class should extend PanacheEntityBase instead, or use the id provided by PanacheEntity", Collections.emptyList());
            return new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{be});
        }
        return null;
    }
}

