/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.agroal.spi.JdbcDataSourceSchemaReadyBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.RecorderBeanInitializedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.deployment.staticmethods.InterceptedStaticMethodsTransformersRegisteredBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeRecorderConstantDefinitionBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.hibernate.orm.PersistenceUnit;
import io.quarkus.hibernate.orm.deployment.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.ClassNames;
import io.quarkus.hibernate.orm.deployment.HibernateConfigUtil;
import io.quarkus.hibernate.orm.deployment.HibernateEntityEnhancer;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfigPersistenceUnit;
import io.quarkus.hibernate.orm.deployment.HibernateOrmEnabled;
import io.quarkus.hibernate.orm.deployment.HibernateOrmTypes;
import io.quarkus.hibernate.orm.deployment.IgnorableNonIndexedClasses;
import io.quarkus.hibernate.orm.deployment.ImpliedBlockingPersistenceUnitTypeBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaJandexScavenger;
import io.quarkus.hibernate.orm.deployment.JpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaModelIndexBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaModelPersistenceUnitContributionBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaModelPersistenceUnitMappingBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceProviderSetUpBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceXmlDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.ProxyBuildingHelper;
import io.quarkus.hibernate.orm.deployment.QuarkusPersistenceXmlParser;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationStaticConfiguredBuildItem;
import io.quarkus.hibernate.orm.deployment.spi.DatabaseKindDialectBuildItem;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRecorder;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.RequestScopedSessionHolder;
import io.quarkus.hibernate.orm.runtime.RequestScopedStatelessSessionHolder;
import io.quarkus.hibernate.orm.runtime.TransactionSessions;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDefinition;
import io.quarkus.hibernate.orm.runtime.boot.scan.QuarkusScanner;
import io.quarkus.hibernate.orm.runtime.boot.xml.JAXBElementSubstitution;
import io.quarkus.hibernate.orm.runtime.boot.xml.QNameSubstitution;
import io.quarkus.hibernate.orm.runtime.boot.xml.RecordableXmlMapping;
import io.quarkus.hibernate.orm.runtime.cdi.QuarkusArcBeanContainer;
import io.quarkus.hibernate.orm.runtime.dev.HibernateOrmDevIntegrator;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationStaticDescriptor;
import io.quarkus.hibernate.orm.runtime.migration.MultiTenancyStrategy;
import io.quarkus.hibernate.orm.runtime.proxies.PreGeneratedProxies;
import io.quarkus.hibernate.orm.runtime.recording.RecordedConfig;
import io.quarkus.hibernate.orm.runtime.schema.SchemaManagementIntegrator;
import io.quarkus.hibernate.orm.runtime.tenant.DataSourceTenantConnectionResolver;
import io.quarkus.hibernate.orm.runtime.tenant.TenantConnectionResolver;
import io.quarkus.panache.common.deployment.HibernateEnhancersRegisteredBuildItem;
import io.quarkus.panache.common.deployment.HibernateModelClassCandidatesForFieldAccessBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import jakarta.transaction.TransactionManager;
import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.pool.TypePool;
import org.hibernate.boot.archive.scan.spi.ClassDescriptor;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.id.SequenceMismatchStrategy;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.loader.BatchFetchStyle;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={HibernateOrmEnabled.class})
public final class HibernateOrmProcessor {
    public static final String HIBERNATE_ORM_CONFIG_PREFIX = "quarkus.hibernate-orm.";
    public static final String NO_SQL_LOAD_SCRIPT_FILE = "no-file";
    private static final Logger LOG = Logger.getLogger(HibernateOrmProcessor.class);
    private static final String INTEGRATOR_SERVICE_FILE = "META-INF/services/org.hibernate.integrator.spi.Integrator";

    @BuildStep
    void registerHibernateOrmMetadataForCoreDialects(BuildProducer<DatabaseKindDialectBuildItem> producer) {
        producer.produce((BuildItem)new DatabaseKindDialectBuildItem("db2", "org.hibernate.dialect.DB2Dialect"));
        producer.produce((BuildItem)new DatabaseKindDialectBuildItem("derby", "org.hibernate.dialect.DerbyDialect"));
        producer.produce((BuildItem)new DatabaseKindDialectBuildItem("h2", "org.hibernate.dialect.H2Dialect", "2.2.224"));
        producer.produce((BuildItem)new DatabaseKindDialectBuildItem("mariadb", "org.hibernate.dialect.MariaDBDialect", "10.6"));
        producer.produce((BuildItem)new DatabaseKindDialectBuildItem("mssql", "org.hibernate.dialect.SQLServerDialect", "13"));
        producer.produce((BuildItem)new DatabaseKindDialectBuildItem("mysql", "org.hibernate.dialect.MySQLDialect"));
        producer.produce((BuildItem)new DatabaseKindDialectBuildItem("oracle", "org.hibernate.dialect.OracleDialect"));
        producer.produce((BuildItem)new DatabaseKindDialectBuildItem("postgresql", "org.hibernate.dialect.PostgreSQLDialect"));
    }

    @BuildStep
    void checkTransactionsSupport(Capabilities capabilities, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        if (capabilities.isMissing("io.quarkus.transactions") && capabilities.isMissing("io.quarkus.hibernate.reactive")) {
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new ConfigurationException("The Hibernate ORM extension is only functional in a JTA environment.")}));
        }
    }

    @BuildStep
    void includeArchivesHostingEntityPackagesInIndex(HibernateOrmConfig hibernateOrmConfig, BuildProducer<AdditionalApplicationArchiveMarkerBuildItem> additionalApplicationArchiveMarkers) {
        for (HibernateOrmConfigPersistenceUnit persistenceUnit : hibernateOrmConfig.getAllPersistenceUnitConfigsAsMap().values()) {
            if (!persistenceUnit.packages.isPresent()) continue;
            for (String pakkage : persistenceUnit.packages.get()) {
                additionalApplicationArchiveMarkers.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem(pakkage.replace('.', '/')));
            }
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=ServiceStartBuildItem.class)
    @BuildStep(onlyIf={IsDevelopment.class})
    void warnOfSchemaProblems(HibernateOrmConfig config, HibernateOrmRecorder recorder) {
        for (Map.Entry<String, HibernateOrmConfigPersistenceUnit> e : config.getAllPersistenceUnitConfigsAsMap().entrySet()) {
            if (!e.getValue().validateInDevMode) continue;
            recorder.doValidation(e.getKey());
        }
    }

    @BuildStep
    AdditionalIndexedClassesBuildItem addPersistenceUnitAnnotationToIndex() {
        return new AdditionalIndexedClassesBuildItem(ClassNames.QUARKUS_PERSISTENCE_UNIT.toString());
    }

    @BuildStep
    public void enrollBeanValidationTypeSafeActivatorForReflection(Capabilities capabilities, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        if (capabilities.isPresent("io.quarkus.hibernate.validator")) {
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.hibernate.boot.beanvalidation.TypeSafeActivator"}).methods().fields().build());
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"jakarta.validation.ConstraintViolation"}).constructors(false).build());
        }
    }

    @BuildStep
    List<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles(HibernateOrmConfig config, LaunchModeBuildItem launchMode) {
        ArrayList<HotDeploymentWatchedFileBuildItem> watchedFiles = new ArrayList<HotDeploymentWatchedFileBuildItem>();
        if (!this.shouldIgnorePersistenceXmlResources(config)) {
            watchedFiles.add(new HotDeploymentWatchedFileBuildItem("META-INF/persistence.xml"));
        }
        watchedFiles.add(new HotDeploymentWatchedFileBuildItem(INTEGRATOR_SERVICE_FILE));
        return watchedFiles;
    }

    @BuildStep
    public void parsePersistenceXmlDescriptors(HibernateOrmConfig config, BuildProducer<PersistenceXmlDescriptorBuildItem> persistenceXmlDescriptorBuildItemBuildProducer) {
        if (!this.shouldIgnorePersistenceXmlResources(config)) {
            List<ParsedPersistenceXmlDescriptor> explicitDescriptors = QuarkusPersistenceXmlParser.locatePersistenceUnits();
            for (ParsedPersistenceXmlDescriptor desc : explicitDescriptors) {
                persistenceXmlDescriptorBuildItemBuildProducer.produce((BuildItem)new PersistenceXmlDescriptorBuildItem(desc));
            }
        }
    }

    @BuildStep
    public ImpliedBlockingPersistenceUnitTypeBuildItem defineTypeOfImpliedPU(List<JdbcDataSourceBuildItem> jdbcDataSourcesBuildItem, Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.hibernate.reactive")) {
            return ImpliedBlockingPersistenceUnitTypeBuildItem.none();
        }
        return ImpliedBlockingPersistenceUnitTypeBuildItem.generateImpliedPersistenceUnit();
    }

    @BuildStep
    public void configurationDescriptorBuilding(HibernateOrmConfig hibernateOrmConfig, CombinedIndexBuildItem index, ImpliedBlockingPersistenceUnitTypeBuildItem impliedPU, List<PersistenceXmlDescriptorBuildItem> persistenceXmlDescriptors, List<JdbcDataSourceBuildItem> jdbcDataSources, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchModeBuildItem launchMode, JpaModelBuildItem jpaModel, Capabilities capabilities, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, BuildProducer<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, List<DatabaseKindDialectBuildItem> dbKindMetadataBuildItems) {
        if (!this.hasEntities(jpaModel)) {
            LOG.warn((Object)"Hibernate ORM is disabled because no JPA entities were found");
            return;
        }
        for (PersistenceXmlDescriptorBuildItem persistenceXmlDescriptorBuildItem : persistenceXmlDescriptors) {
            ParsedPersistenceXmlDescriptor xmlDescriptor = persistenceXmlDescriptorBuildItem.getDescriptor();
            String puName = xmlDescriptor.getName();
            Optional<JdbcDataSourceBuildItem> jdbcDataSource = jdbcDataSources.stream().filter(i -> i.isDefault()).findFirst();
            HibernateOrmProcessor.collectDialectConfigForPersistenceXml(puName, xmlDescriptor);
            persistenceUnitDescriptors.produce((BuildItem)new PersistenceUnitDescriptorBuildItem(xmlDescriptor, puName, new RecordedConfig(Optional.of("<default>"), jdbcDataSource.map(JdbcDataSourceBuildItem::getDbKind), jdbcDataSource.flatMap(JdbcDataSourceBuildItem::getDbVersion), HibernateOrmProcessor.getMultiTenancyStrategy(Optional.ofNullable(persistenceXmlDescriptorBuildItem.getDescriptor().getProperties().getProperty("hibernate.multiTenancy"))), hibernateOrmConfig.database.ormCompatibilityVersion, Collections.emptyMap()), null, jpaModel.getXmlMappings(persistenceXmlDescriptorBuildItem.getDescriptor().getName()), false, true, capabilities));
        }
        if (impliedPU.shouldGenerateImpliedBlockingPersistenceUnit()) {
            this.handleHibernateORMWithNoPersistenceXml(hibernateOrmConfig, index, persistenceXmlDescriptors, jdbcDataSources, applicationArchivesBuildItem, launchMode.getLaunchMode(), jpaModel, capabilities, systemProperties, nativeImageResources, hotDeploymentWatchedFiles, persistenceUnitDescriptors, dbKindMetadataBuildItems);
        }
    }

    @BuildStep
    public JpaModelIndexBuildItem jpaEntitiesIndexer(CombinedIndexBuildItem index, List<io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem> additionalJpaModelBuildItems, List<AdditionalJpaModelBuildItem> deprecatedAdditionalJpaModelBuildItems) {
        HashSet<String> additionalClassNames = new HashSet<String>();
        for (io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem additionalJpaModelBuildItem : additionalJpaModelBuildItems) {
            additionalClassNames.add(additionalJpaModelBuildItem.getClassName());
        }
        for (AdditionalJpaModelBuildItem additionalJpaModelBuildItem : deprecatedAdditionalJpaModelBuildItems) {
            additionalClassNames.add(additionalJpaModelBuildItem.getClassName());
        }
        Indexer indexer = new Indexer();
        HashSet hashSet = new HashSet();
        for (String className : additionalClassNames) {
            IndexingUtil.indexClass((String)className, (Indexer)indexer, (IndexView)index.getIndex(), hashSet, (ClassLoader)HibernateOrmProcessor.class.getClassLoader());
        }
        CompositeIndex compositeIndex = CompositeIndex.create((IndexView[])new IndexView[]{index.getComputingIndex(), indexer.complete()});
        return new JpaModelIndexBuildItem(compositeIndex);
    }

    @BuildStep
    public void contributePersistenceXmlToJpaModel(BuildProducer<JpaModelPersistenceUnitContributionBuildItem> jpaModelPuContributions, List<PersistenceXmlDescriptorBuildItem> persistenceXmlDescriptors) {
        for (PersistenceXmlDescriptorBuildItem persistenceXmlDescriptor : persistenceXmlDescriptors) {
            ParsedPersistenceXmlDescriptor descriptor = persistenceXmlDescriptor.getDescriptor();
            jpaModelPuContributions.produce((BuildItem)new JpaModelPersistenceUnitContributionBuildItem(descriptor.getName(), descriptor.getPersistenceUnitRootUrl(), descriptor.getManagedClassNames(), descriptor.getMappingFileNames()));
        }
    }

    @BuildStep
    public void contributeQuarkusConfigToJpaModel(BuildProducer<JpaModelPersistenceUnitContributionBuildItem> jpaModelPuContributions, HibernateOrmConfig hibernateOrmConfig) {
        for (Map.Entry<String, HibernateOrmConfigPersistenceUnit> entry : hibernateOrmConfig.getAllPersistenceUnitConfigsAsMap().entrySet()) {
            String name = entry.getKey();
            HibernateOrmConfigPersistenceUnit config = entry.getValue();
            jpaModelPuContributions.produce((BuildItem)new JpaModelPersistenceUnitContributionBuildItem(name, null, Collections.emptySet(), config.mappingFiles.orElse(Collections.emptySet())));
        }
    }

    @BuildStep
    public void defineJpaEntities(JpaModelIndexBuildItem indexBuildItem, BuildProducer<JpaModelBuildItem> domainObjectsProducer, List<IgnorableNonIndexedClasses> ignorableNonIndexedClassesBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, List<JpaModelPersistenceUnitContributionBuildItem> jpaModelPuContributions) throws BuildException {
        Set<String> ignorableNonIndexedClasses = Collections.emptySet();
        if (!ignorableNonIndexedClassesBuildItems.isEmpty()) {
            ignorableNonIndexedClasses = new HashSet();
            for (IgnorableNonIndexedClasses buildItem : ignorableNonIndexedClassesBuildItems) {
                ignorableNonIndexedClasses.addAll(buildItem.getClasses());
            }
        }
        JpaJandexScavenger scavenger = new JpaJandexScavenger(reflectiveClass, hotDeploymentWatchedFiles, jpaModelPuContributions, (IndexView)indexBuildItem.getIndex(), ignorableNonIndexedClasses);
        JpaModelBuildItem domainObjects = scavenger.discoverModelAndRegisterForReflection();
        domainObjectsProducer.produce((BuildItem)domainObjects);
    }

    @BuildStep
    public BytecodeRecorderConstantDefinitionBuildItem pregenProxies(JpaModelBuildItem jpaModel, JpaModelIndexBuildItem indexBuildItem, TransformedClassesBuildItem transformedClassesBuildItem, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, List<io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem> additionalJpaModelBuildItems, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, LiveReloadBuildItem liveReloadBuildItem) {
        HashSet<String> managedClassAndPackageNames = new HashSet<String>(jpaModel.getEntityClassNames());
        for (PersistenceUnitDescriptorBuildItem pud : persistenceUnitDescriptorBuildItems) {
            managedClassAndPackageNames.addAll(pud.getManagedClassNames());
        }
        for (io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem additionalJpaModelBuildItem : additionalJpaModelBuildItems) {
            managedClassAndPackageNames.add(additionalJpaModelBuildItem.getClassName());
        }
        PreGeneratedProxies proxyDefinitions = this.generatedProxies(managedClassAndPackageNames, (IndexView)indexBuildItem.getIndex(), transformedClassesBuildItem, generatedClassBuildItemBuildProducer, liveReloadBuildItem);
        return new BytecodeRecorderConstantDefinitionBuildItem(PreGeneratedProxies.class, (Object)proxyDefinitions);
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void preGenAnnotationProxies(List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<ReflectiveClassBuildItem> reflective, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinitions) {
        if (this.hasXmlMappings(persistenceUnitDescriptorBuildItems)) {
            ArrayList<String> annotationClassNames = new ArrayList<String>();
            for (DotName name : HibernateOrmTypes.JPA_MAPPING_ANNOTATIONS) {
                annotationClassNames.add(name.toString());
            }
            for (DotName name : HibernateOrmTypes.HIBERNATE_MAPPING_ANNOTATIONS) {
                annotationClassNames.add(name.toString());
            }
            reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])annotationClassNames.toArray(new String[0])).methods().fields().build());
            for (String annotationClassName : annotationClassNames) {
                proxyDefinitions.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{annotationClassName}));
            }
        }
    }

    private boolean hasXmlMappings(List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems) {
        for (PersistenceUnitDescriptorBuildItem descriptor : persistenceUnitDescriptorBuildItems) {
            if (!descriptor.hasXmlMappings()) continue;
            return true;
        }
        return false;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(RecorderContext recorderContext, HibernateOrmRecorder recorder, Capabilities capabilities, JpaModelBuildItem jpaModel, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, List<HibernateOrmIntegrationStaticConfiguredBuildItem> integrationBuildItems, BuildProducer<BeanContainerListenerBuildItem> beanContainerListener, LaunchModeBuildItem launchMode) throws Exception {
        this.validateHibernatePropertiesNotUsed();
        boolean enableORM = this.hasEntities(jpaModel);
        boolean hibernateReactivePresent = capabilities.isPresent("io.quarkus.hibernate.reactive");
        if (!hibernateReactivePresent) {
            recorder.callHibernateFeatureInit(enableORM);
        }
        if (!enableORM) {
            return;
        }
        recorder.enlistPersistenceUnit(jpaModel.getEntityClassNames());
        QuarkusScanner scanner = HibernateOrmProcessor.buildQuarkusScanner(jpaModel);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        LinkedHashSet<Class> integratorClasses = new LinkedHashSet<Class>();
        for (String integratorClassName : ServiceUtil.classNamesNamedIn((ClassLoader)classLoader, (String)INTEGRATOR_SERVICE_FILE)) {
            integratorClasses.add(recorderContext.classProxy(integratorClassName));
        }
        if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT) {
            integratorClasses.add(HibernateOrmDevIntegrator.class);
            integratorClasses.add(SchemaManagementIntegrator.class);
        }
        Map<String, List<HibernateOrmIntegrationStaticDescriptor>> integrationStaticDescriptors = HibernateOrmIntegrationStaticConfiguredBuildItem.collectDescriptors(integrationBuildItems);
        ArrayList<QuarkusPersistenceUnitDefinition> finalStagePUDescriptors = new ArrayList<QuarkusPersistenceUnitDefinition>();
        for (PersistenceUnitDescriptorBuildItem pud : persistenceUnitDescriptorBuildItems) {
            finalStagePUDescriptors.add(pud.asOutputPersistenceUnitDefinition(integrationStaticDescriptors.getOrDefault(pud.getPersistenceUnitName(), Collections.emptyList())));
        }
        if (this.hasXmlMappings(persistenceUnitDescriptorBuildItems)) {
            recorderContext.registerSubstitution(JAXBElement.class, JAXBElementSubstitution.Serialized.class, JAXBElementSubstitution.class);
            recorderContext.registerSubstitution(QName.class, QNameSubstitution.Serialized.class, QNameSubstitution.class);
        }
        beanContainerListener.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.initMetadata(finalStagePUDescriptors, (Scanner)scanner, integratorClasses)));
    }

    private void validateHibernatePropertiesNotUsed() {
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("hibernate.properties");
            if (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                throw new IllegalStateException("The Hibernate ORM configuration in Quarkus does not support sourcing configuration properties from resources named `hibernate.properties`, and this is now expressly prohibited as such a file could lead to unpredictable semantics. Please remove it from `" + url.toExternalForm() + "`");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @BuildStep
    void handleNativeImageImportSql(BuildProducer<NativeImageResourceBuildItem> resources, List<PersistenceUnitDescriptorBuildItem> descriptors, JpaModelBuildItem jpaModel, LaunchModeBuildItem launchMode) {
        if (!this.hasEntities(jpaModel)) {
            return;
        }
        for (PersistenceUnitDescriptorBuildItem i : descriptors) {
            String resourceName = i.getExplicitSqlImportScriptResourceName();
            if (resourceName == null) continue;
            resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{resourceName}));
        }
    }

    @BuildStep
    void registerBeans(HibernateOrmConfig hibernateOrmConfig, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, Capabilities capabilities, CombinedIndexBuildItem combinedIndex, List<PersistenceUnitDescriptorBuildItem> descriptors, JpaModelBuildItem jpaModel) {
        if (!this.hasEntities(jpaModel)) {
            return;
        }
        ArrayList<Class<QuarkusArcBeanContainer>> unremovableClasses = new ArrayList<Class<QuarkusArcBeanContainer>>();
        if (capabilities.isPresent("io.quarkus.transactions")) {
            unremovableClasses.add(TransactionManager.class);
            unremovableClasses.add(TransactionSessions.class);
        }
        unremovableClasses.add(RequestScopedSessionHolder.class);
        unremovableClasses.add(RequestScopedStatelessSessionHolder.class);
        unremovableClasses.add(QuarkusArcBeanContainer.class);
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(unremovableClasses.toArray(new Class[unremovableClasses.size()])).build());
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{AttributeConverter.class}));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes(jpaModel.getPotentialCdiBeanClassNames()));
    }

    @Consume(value=InterceptedStaticMethodsTransformersRegisteredBuildItem.class)
    @BuildStep
    public HibernateEnhancersRegisteredBuildItem enhancerDomainObjects(JpaModelBuildItem jpaModel, BuildProducer<BytecodeTransformerBuildItem> transformers, List<io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem> additionalJpaModelBuildItems, List<AdditionalJpaModelBuildItem> deprecatedAdditionalJpaModelBuildItems, BuildProducer<GeneratedClassBuildItem> additionalClasses) {
        this.enhanceEntities(jpaModel, transformers, additionalJpaModelBuildItems, deprecatedAdditionalJpaModelBuildItems, additionalClasses);
        return new HibernateEnhancersRegisteredBuildItem();
    }

    @BuildStep
    public HibernateModelClassCandidatesForFieldAccessBuildItem candidatesForFieldAccess(JpaModelBuildItem jpaModel) {
        return new HibernateModelClassCandidatesForFieldAccessBuildItem(jpaModel.getManagedClassNames());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void build(HibernateOrmRecorder recorder, HibernateOrmConfig hibernateOrmConfig, HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig, BuildProducer<JpaModelPersistenceUnitMappingBuildItem> jpaModelPersistenceUnitMapping, List<PersistenceUnitDescriptorBuildItem> descriptors, JpaModelBuildItem jpaModel) throws Exception {
        if (!this.hasEntities(jpaModel)) {
            return;
        }
        HashMap<String, Set<String>> entityPersistenceUnitMapping = new HashMap<String, Set<String>>();
        for (PersistenceUnitDescriptorBuildItem descriptor : descriptors) {
            for (String entityClass : descriptor.getManagedClassNames()) {
                entityPersistenceUnitMapping.putIfAbsent(entityClass, new HashSet());
                ((Set)entityPersistenceUnitMapping.get(entityClass)).add(descriptor.getPersistenceUnitName());
            }
        }
        jpaModelPersistenceUnitMapping.produce((BuildItem)new JpaModelPersistenceUnitMappingBuildItem(entityPersistenceUnitMapping));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public PersistenceProviderSetUpBuildItem setupPersistenceProvider(HibernateOrmRecorder recorder, Capabilities capabilities, HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig, List<HibernateOrmIntegrationRuntimeConfiguredBuildItem> integrationBuildItems, BuildProducer<RecorderBeanInitializedBuildItem> orderEnforcer) {
        if (capabilities.isMissing("io.quarkus.hibernate.reactive")) {
            recorder.setupPersistenceProvider(hibernateOrmRuntimeConfig, HibernateOrmIntegrationRuntimeConfiguredBuildItem.collectDescriptors(integrationBuildItems));
        }
        return new PersistenceProviderSetUpBuildItem();
    }

    @BuildStep
    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public ServiceStartBuildItem startPersistenceUnits(HibernateOrmRecorder recorder, BeanContainerBuildItem beanContainer, List<JdbcDataSourceBuildItem> dataSourcesConfigured, JpaModelBuildItem jpaModel, List<JdbcDataSourceSchemaReadyBuildItem> schemaReadyBuildItem, List<PersistenceProviderSetUpBuildItem> persistenceProviderSetUp) throws Exception {
        if (this.hasEntities(jpaModel)) {
            recorder.startAllPersistenceUnits(beanContainer.getValue());
        }
        return new ServiceStartBuildItem("Hibernate ORM");
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void multitenancy(HibernateOrmRecorder recorder, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        boolean multitenancyEnabled = false;
        for (PersistenceUnitDescriptorBuildItem persistenceUnitDescriptor : persistenceUnitDescriptors) {
            if (persistenceUnitDescriptor.getConfig().getMultiTenancyStrategy() == MultiTenancyStrategy.NONE) continue;
            multitenancyEnabled = true;
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(DataSourceTenantConnectionResolver.class).scope(ApplicationScoped.class)).types(new Class[]{TenantConnectionResolver.class})).setRuntimeInit().defaultBean()).unremovable()).supplier(recorder.dataSourceTenantConnectionResolver(persistenceUnitDescriptor.getPersistenceUnitName(), persistenceUnitDescriptor.getConfig().getDataSource(), persistenceUnitDescriptor.getConfig().getMultiTenancyStrategy(), persistenceUnitDescriptor.getMultiTenancySchemaDataSource()));
            if (PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitDescriptor.getPersistenceUnitName())) {
                configurator.addQualifier(Default.class);
            } else {
                configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)persistenceUnitDescriptor.getPersistenceUnitName()).done();
                configurator.addQualifier().annotation(PersistenceUnit.class).addValue("value", (Object)persistenceUnitDescriptor.getPersistenceUnitName()).done();
            }
            syntheticBeans.produce((BuildItem)configurator.done());
        }
        if (multitenancyEnabled) {
            unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanTypeExclusion(ClassNames.TENANT_CONNECTION_RESOLVER)));
            unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanTypeExclusion(ClassNames.TENANT_RESOLVER)));
        }
    }

    @BuildStep
    public void produceLoggingCategories(HibernateOrmConfig hibernateOrmConfig, BuildProducer<LogCategoryBuildItem> categories) {
        if (hibernateOrmConfig.log.bindParam || hibernateOrmConfig.log.bindParameters) {
            categories.produce((BuildItem)new LogCategoryBuildItem("org.hibernate.orm.jdbc.bind", (Level)org.jboss.logmanager.Level.TRACE, true));
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void registerStaticMetamodelClassesForReflection(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflective) {
        Collection annotationInstances = index.getIndex().getAnnotations(ClassNames.STATIC_METAMODEL);
        if (!annotationInstances.isEmpty()) {
            String[] metamodel = (String[])annotationInstances.stream().map(a -> a.target().asClass().name().toString()).toArray(String[]::new);
            reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])metamodel).constructors(false).fields().build());
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void registerInjectServiceMethodsForReflection(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflective) {
        HashSet classes = new HashSet();
        HibernateOrmTypes.ANNOTATED_WITH_INJECT_SERVICE.stream().map(DotName::toString).forEach(classes::add);
        index.getIndex().getAnnotations(ClassNames.INJECT_SERVICE).stream().map(a -> a.target().asMethod().declaringClass().name().toString()).forEach(classes::add);
        if (!classes.isEmpty()) {
            reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classes.toArray(new String[0])).constructors(false).methods().build());
        }
    }

    private static List<String> getSqlLoadScript(Optional<List<String>> sqlLoadScript, LaunchMode launchMode) {
        if (sqlLoadScript.isPresent()) {
            return sqlLoadScript.get().stream().filter(s -> !NO_SQL_LOAD_SCRIPT_FILE.equalsIgnoreCase((String)s)).collect(Collectors.toList());
        }
        if (launchMode == LaunchMode.NORMAL) {
            return Collections.emptyList();
        }
        return List.of("import.sql");
    }

    private boolean hasEntities(JpaModelBuildItem jpaModel) {
        return !jpaModel.getEntityClassNames().isEmpty();
    }

    private void handleHibernateORMWithNoPersistenceXml(HibernateOrmConfig hibernateOrmConfig, CombinedIndexBuildItem index, List<PersistenceXmlDescriptorBuildItem> descriptors, List<JdbcDataSourceBuildItem> jdbcDataSources, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchMode launchMode, JpaModelBuildItem jpaModel, Capabilities capabilities, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, BuildProducer<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, List<DatabaseKindDialectBuildItem> dbKindMetadataBuildItems) {
        if (!descriptors.isEmpty()) {
            if (hibernateOrmConfig.isAnyNonPersistenceXmlPropertySet() || !hibernateOrmConfig.persistenceUnits.isEmpty()) {
                throw new ConfigurationException("A legacy persistence.xml file is present in the classpath, but Hibernate ORM is also configured through the Quarkus config file.\nLegacy persistence.xml files and Quarkus configuration cannot be used at the same time.\nTo ignore persistence.xml files, set the configuration property 'quarkus.hibernate-orm.persistence-xml.ignore' to 'true'.\nTo use persistence.xml files, remove all 'quarkus.hibernate-orm.*' properties from the Quarkus config file.");
            }
            LOG.infof("A legacy persistence.xml file is present in the classpath. This file will be used to configure JPA/Hibernate ORM persistence units, and any configuration of the Hibernate ORM extension will be ignored. To ignore persistence.xml files instead, set the configuration property 'quarkus.hibernate-orm.persistence-xml.ignore' to 'true'.", new Object[0]);
            return;
        }
        Optional<JdbcDataSourceBuildItem> defaultJdbcDataSource = jdbcDataSources.stream().filter(i -> i.isDefault()).findFirst();
        boolean enableDefaultPersistenceUnit = defaultJdbcDataSource.isPresent() && hibernateOrmConfig.persistenceUnits.isEmpty() || hibernateOrmConfig.defaultPersistenceUnit.isAnyPropertySet();
        Map<String, Set<String>> modelClassesAndPackagesPerPersistencesUnits = HibernateOrmProcessor.getModelClassesAndPackagesPerPersistenceUnits(hibernateOrmConfig, jpaModel, index.getIndex(), enableDefaultPersistenceUnit);
        Set<String> modelClassesAndPackagesForDefaultPersistenceUnit = modelClassesAndPackagesPerPersistencesUnits.getOrDefault("<default>", Collections.emptySet());
        HashSet<String> storageEngineCollector = new HashSet<String>();
        if (enableDefaultPersistenceUnit) {
            HibernateOrmProcessor.producePersistenceUnitDescriptorFromConfig(hibernateOrmConfig, "<default>", hibernateOrmConfig.defaultPersistenceUnit, modelClassesAndPackagesForDefaultPersistenceUnit, jpaModel.getXmlMappings("<default>"), jdbcDataSources, applicationArchivesBuildItem, launchMode, capabilities, systemProperties, nativeImageResources, hotDeploymentWatchedFiles, persistenceUnitDescriptors, storageEngineCollector, dbKindMetadataBuildItems);
        } else if (!(modelClassesAndPackagesForDefaultPersistenceUnit.isEmpty() || hibernateOrmConfig.defaultPersistenceUnit.datasource.isPresent() && !DataSourceUtil.isDefault((String)hibernateOrmConfig.defaultPersistenceUnit.datasource.get()) || defaultJdbcDataSource.isPresent())) {
            String persistenceUnitName = "<default>";
            String dataSourceName = "<default>";
            throw PersistenceUnitUtil.unableToFindDataSource((String)persistenceUnitName, (String)dataSourceName, (Throwable)DataSourceUtil.dataSourceNotConfigured((String)dataSourceName));
        }
        for (Map.Entry<String, HibernateOrmConfigPersistenceUnit> persistenceUnitEntry : hibernateOrmConfig.persistenceUnits.entrySet()) {
            HibernateOrmProcessor.producePersistenceUnitDescriptorFromConfig(hibernateOrmConfig, persistenceUnitEntry.getKey(), persistenceUnitEntry.getValue(), modelClassesAndPackagesPerPersistencesUnits.getOrDefault(persistenceUnitEntry.getKey(), Collections.emptySet()), jpaModel.getXmlMappings(persistenceUnitEntry.getKey()), jdbcDataSources, applicationArchivesBuildItem, launchMode, capabilities, systemProperties, nativeImageResources, hotDeploymentWatchedFiles, persistenceUnitDescriptors, storageEngineCollector, dbKindMetadataBuildItems);
        }
        if (storageEngineCollector.size() > 1) {
            throw new ConfigurationException("The dialect storage engine is a global configuration property: it must be consistent across all persistence units.");
        }
    }

    private static void producePersistenceUnitDescriptorFromConfig(HibernateOrmConfig hibernateOrmConfig, String persistenceUnitName, HibernateOrmConfigPersistenceUnit persistenceUnitConfig, Set<String> modelClassesAndPackages, List<RecordableXmlMapping> xmlMappings, List<JdbcDataSourceBuildItem> jdbcDataSources, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchMode launchMode, Capabilities capabilities, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, BuildProducer<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, Set<String> storageEngineCollector, List<DatabaseKindDialectBuildItem> dbKindMetadataBuildItems) {
        List<String> importFiles;
        Optional<JdbcDataSourceBuildItem> jdbcDataSource = HibernateOrmProcessor.findJdbcDataSource(persistenceUnitName, persistenceUnitConfig, jdbcDataSources);
        ParsedPersistenceXmlDescriptor descriptor = new ParsedPersistenceXmlDescriptor(null);
        descriptor.setName(persistenceUnitName);
        descriptor.setExcludeUnlistedClasses(true);
        if (modelClassesAndPackages.isEmpty()) {
            LOG.warnf("Could not find any entities affected to the persistence unit '%s'.", (Object)persistenceUnitName);
        } else {
            descriptor.addClasses(new ArrayList<String>(modelClassesAndPackages));
        }
        descriptor.setTransactionType(PersistenceUnitTransactionType.JTA);
        MultiTenancyStrategy multiTenancyStrategy = HibernateOrmProcessor.getMultiTenancyStrategy(persistenceUnitConfig.multitenant);
        HibernateOrmProcessor.collectDialectConfig(persistenceUnitName, persistenceUnitConfig, dbKindMetadataBuildItems, jdbcDataSource, multiTenancyStrategy, systemProperties, descriptor.getProperties()::setProperty, storageEngineCollector);
        persistenceUnitConfig.physicalNamingStrategy.ifPresent(namingStrategy -> descriptor.getProperties().setProperty("hibernate.physical_naming_strategy", (String)namingStrategy));
        persistenceUnitConfig.implicitNamingStrategy.ifPresent(namingStrategy -> descriptor.getProperties().setProperty("hibernate.implicit_naming_strategy", (String)namingStrategy));
        persistenceUnitConfig.metadataBuilderContributor.ifPresent(className -> descriptor.getProperties().setProperty("hibernate.metadata_builder_contributor", (String)className));
        if (persistenceUnitConfig.mapping.timezone.timeZoneDefaultStorage.isPresent()) {
            descriptor.getProperties().setProperty("hibernate.timezone.default_storage", persistenceUnitConfig.mapping.timezone.timeZoneDefaultStorage.get().name());
        }
        descriptor.getProperties().setProperty("hibernate.id.optimizer.pooled.preferred", persistenceUnitConfig.mapping.id.optimizer.idOptimizerDefault.orElse((HibernateOrmConfigPersistenceUnit.IdOptimizerType)HibernateOrmConfigPersistenceUnit.IdOptimizerType.POOLED_LO).configName);
        descriptor.getProperties().setProperty("hibernate.hbm2ddl.charset_name", persistenceUnitConfig.database.charset.name());
        if (persistenceUnitConfig.quoteIdentifiers.strategy == HibernateOrmConfigPersistenceUnit.IdentifierQuotingStrategy.ALL || persistenceUnitConfig.quoteIdentifiers.strategy == HibernateOrmConfigPersistenceUnit.IdentifierQuotingStrategy.ALL_EXCEPT_COLUMN_DEFINITIONS || persistenceUnitConfig.database.globallyQuotedIdentifiers) {
            descriptor.getProperties().setProperty("hibernate.globally_quoted_identifiers", "true");
        }
        if (persistenceUnitConfig.quoteIdentifiers.strategy == HibernateOrmConfigPersistenceUnit.IdentifierQuotingStrategy.ALL_EXCEPT_COLUMN_DEFINITIONS) {
            descriptor.getProperties().setProperty("hibernate.globally_quoted_identifiers_skip_column_definitions", "true");
        } else if (persistenceUnitConfig.quoteIdentifiers.strategy == HibernateOrmConfigPersistenceUnit.IdentifierQuotingStrategy.ONLY_KEYWORDS) {
            descriptor.getProperties().setProperty("hibernate.auto_quote_keyword", "true");
        }
        int batchSize = HibernateConfigUtil.firstPresent(persistenceUnitConfig.fetch.batchSize, persistenceUnitConfig.batchFetchSize).orElse(16);
        if (batchSize > 0) {
            descriptor.getProperties().setProperty("hibernate.default_batch_fetch_size", Integer.toString(batchSize));
            descriptor.getProperties().setProperty("hibernate.batch_fetch_style", BatchFetchStyle.PADDED.toString());
        }
        if (persistenceUnitConfig.fetch.maxDepth.isPresent()) {
            HibernateOrmProcessor.setMaxFetchDepth(descriptor, persistenceUnitConfig.fetch.maxDepth);
        } else if (persistenceUnitConfig.maxFetchDepth.isPresent()) {
            HibernateOrmProcessor.setMaxFetchDepth(descriptor, persistenceUnitConfig.maxFetchDepth);
        }
        descriptor.getProperties().setProperty("hibernate.query.plan_cache_max_size", Integer.toString(persistenceUnitConfig.query.queryPlanCacheMaxSize));
        descriptor.getProperties().setProperty("hibernate.order_by.default_null_ordering", persistenceUnitConfig.query.defaultNullOrdering.name().toLowerCase(Locale.ROOT));
        descriptor.getProperties().setProperty("hibernate.query.in_clause_parameter_padding", String.valueOf(persistenceUnitConfig.query.inClauseParameterPadding));
        descriptor.getProperties().put("hibernate.id.sequence.increment_size_mismatch_strategy", SequenceMismatchStrategy.NONE);
        persistenceUnitConfig.jdbc.timezone.ifPresent(timezone -> descriptor.getProperties().setProperty("hibernate.jdbc.time_zone", (String)timezone));
        persistenceUnitConfig.jdbc.statementFetchSize.ifPresent(fetchSize -> descriptor.getProperties().setProperty("hibernate.jdbc.fetch_size", String.valueOf(fetchSize)));
        persistenceUnitConfig.jdbc.statementBatchSize.ifPresent(fetchSize -> descriptor.getProperties().setProperty("hibernate.jdbc.batch_size", String.valueOf(fetchSize)));
        if (hibernateOrmConfig.metrics.enabled || hibernateOrmConfig.statistics.isPresent() && hibernateOrmConfig.statistics.get().booleanValue()) {
            descriptor.getProperties().setProperty("hibernate.generate_statistics", "true");
            descriptor.getProperties().setProperty("hibernate.session.events.log", String.valueOf(hibernateOrmConfig.logSessionMetrics.orElse(false)));
        }
        if (!(importFiles = HibernateOrmProcessor.getSqlLoadScript(persistenceUnitConfig.sqlLoadScript, launchMode)).isEmpty()) {
            for (String importFile : importFiles) {
                Path loadScriptPath;
                try {
                    loadScriptPath = applicationArchivesBuildItem.getRootArchive().getChildPath(importFile);
                }
                catch (RuntimeException e) {
                    throw new ConfigurationException("Unable to interpret path referenced in '" + HibernateOrmRuntimeConfig.puPropertyKey((String)persistenceUnitName, (String)"sql-load-script") + "=" + String.join((CharSequence)",", (Iterable<? extends CharSequence>)persistenceUnitConfig.sqlLoadScript.get()) + "': " + e.getMessage());
                }
                if (loadScriptPath != null && !Files.isDirectory(loadScriptPath, new LinkOption[0])) {
                    nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{importFile}));
                } else if (persistenceUnitConfig.sqlLoadScript.isPresent()) {
                    throw new ConfigurationException("Unable to find file referenced in '" + HibernateOrmRuntimeConfig.puPropertyKey((String)persistenceUnitName, (String)"sql-load-script") + "=" + String.join((CharSequence)",", (Iterable<? extends CharSequence>)persistenceUnitConfig.sqlLoadScript.get()) + "'. Remove property or add file to your path.");
                }
                hotDeploymentWatchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(importFile));
            }
            if (persistenceUnitConfig.sqlLoadScript.isPresent()) {
                descriptor.getProperties().setProperty("hibernate.hbm2ddl.import_files", String.join((CharSequence)",", importFiles));
            }
        } else {
            descriptor.getProperties().setProperty("hibernate.hbm2ddl.import_files", "");
        }
        if (persistenceUnitConfig.secondLevelCachingEnabled) {
            p = descriptor.getProperties();
            p.putIfAbsent("hibernate.cache.use_reference_entries", Boolean.TRUE);
            p.putIfAbsent("hibernate.cache.use_second_level_cache", Boolean.TRUE);
            p.putIfAbsent("hibernate.cache.use_query_cache", Boolean.TRUE);
            p.putIfAbsent("jakarta.persistence.sharedCache.mode", SharedCacheMode.ENABLE_SELECTIVE);
            Map<String, String> cacheConfigEntries = HibernateConfigUtil.getCacheConfigEntries(persistenceUnitConfig);
            for (Map.Entry<String, String> entry : cacheConfigEntries.entrySet()) {
                descriptor.getProperties().setProperty(entry.getKey(), entry.getValue());
            }
        } else {
            p = descriptor.getProperties();
            p.put("hibernate.cache.use_reference_entries", Boolean.FALSE);
            p.put("hibernate.cache.use_second_level_cache", Boolean.FALSE);
            p.put("hibernate.cache.use_query_cache", Boolean.FALSE);
            p.put("jakarta.persistence.sharedCache.mode", SharedCacheMode.NONE);
        }
        if (capabilities.isPresent("io.quarkus.hibernate.validator")) {
            if (persistenceUnitConfig.validation.enabled) {
                descriptor.getProperties().setProperty("jakarta.persistence.validation.mode", ValidationMode.CALLBACK.name());
            } else {
                descriptor.getProperties().setProperty("jakarta.persistence.validation.mode", ValidationMode.NONE.name());
            }
        }
        descriptor.getProperties().setProperty("hibernate.discriminator.ignore_explicit_for_joined", String.valueOf(persistenceUnitConfig.discriminator.ignoreExplicitForJoined));
        persistenceUnitDescriptors.produce((BuildItem)new PersistenceUnitDescriptorBuildItem(descriptor, descriptor.getName(), new RecordedConfig(jdbcDataSource.map(JdbcDataSourceBuildItem::getName), jdbcDataSource.map(JdbcDataSourceBuildItem::getDbKind), jdbcDataSource.flatMap(JdbcDataSourceBuildItem::getDbVersion), multiTenancyStrategy, hibernateOrmConfig.database.ormCompatibilityVersion, persistenceUnitConfig.unsupportedProperties), persistenceUnitConfig.multitenantSchemaDatasource.orElse(null), xmlMappings, false, false, capabilities));
    }

    private static void collectDialectConfig(String persistenceUnitName, HibernateOrmConfigPersistenceUnit persistenceUnitConfig, List<DatabaseKindDialectBuildItem> dbKindMetadataBuildItems, Optional<JdbcDataSourceBuildItem> jdbcDataSource, MultiTenancyStrategy multiTenancyStrategy, BuildProducer<SystemPropertyBuildItem> systemProperties, BiConsumer<String, String> puPropertiesCollector, Set<String> storageEngineCollector) {
        Optional<String> explicitDialect = persistenceUnitConfig.dialect.dialect;
        Optional<String> dbKind = jdbcDataSource.map(JdbcDataSourceBuildItem::getDbKind);
        Optional explicitDbMinVersion = jdbcDataSource.flatMap(JdbcDataSourceBuildItem::getDbVersion);
        if (multiTenancyStrategy != MultiTenancyStrategy.DATABASE && jdbcDataSource.isEmpty()) {
            throw new ConfigurationException(String.format(Locale.ROOT, "Datasource must be defined for persistence unit '%s'. Refer to https://quarkus.io/guides/datasource for guidance.", persistenceUnitName), new HashSet<String>(Arrays.asList("quarkus.datasource.db-kind", "quarkus.datasource.username", "quarkus.datasource.password", "quarkus.datasource.jdbc.url")));
        }
        Optional<String> dialect = explicitDialect;
        Optional dbProductVersion = explicitDbMinVersion;
        if (dbKind.isPresent() || explicitDialect.isPresent()) {
            for (DatabaseKindDialectBuildItem item : dbKindMetadataBuildItems) {
                if ((!dbKind.isPresent() || !DatabaseKind.is((String)dbKind.get(), (String)item.getDbKind())) && (!explicitDialect.isPresent() || !explicitDialect.get().equals(item.getDialect()))) continue;
                if (explicitDialect.isEmpty()) {
                    dialect = Optional.of(item.getDialect());
                }
                if (!explicitDbMinVersion.isEmpty()) break;
                dbProductVersion = item.getDefaultDatabaseProductVersion();
                break;
            }
            if (dialect.isEmpty()) {
                throw new ConfigurationException("The Hibernate ORM extension could not guess the dialect from the database kind '" + dbKind.get() + "'. Add an explicit '" + HibernateOrmRuntimeConfig.puPropertyKey((String)persistenceUnitName, (String)"dialect") + "' property.");
            }
        }
        if (!dialect.isPresent()) {
            assert (multiTenancyStrategy == MultiTenancyStrategy.DATABASE);
            throw new ConfigurationException(String.format(Locale.ROOT, "The Hibernate ORM extension could not infer the dialect for persistence unit '%s'. When using database multi-tenancy, you must either configure a datasource for that persistence unit (refer to https://quarkus.io/guides/datasource for guidance), or set the dialect explicitly through property '" + HibernateOrmRuntimeConfig.puPropertyKey((String)persistenceUnitName, (String)"dialect") + "'.", persistenceUnitName));
        }
        puPropertiesCollector.accept("hibernate.dialect", dialect.get());
        if (persistenceUnitConfig.dialect.storageEngine.isPresent()) {
            if (HibernateOrmProcessor.isMySQLOrMariaDB(dialect.get())) {
                storageEngineCollector.add(persistenceUnitConfig.dialect.storageEngine.get());
                systemProperties.produce((BuildItem)new SystemPropertyBuildItem("hibernate.dialect.storage_engine", persistenceUnitConfig.dialect.storageEngine.get()));
            } else {
                LOG.warnf("The storage engine set through configuration property '%1$s' is being ignored because the database is neither MySQL nor MariaDB.", (Object)HibernateOrmRuntimeConfig.puPropertyKey((String)persistenceUnitName, (String)"dialect.storage-engine"));
            }
        }
        if (dbProductVersion.isPresent()) {
            puPropertiesCollector.accept("jakarta.persistence.database-product-version", (String)dbProductVersion.get());
        }
    }

    private static void collectDialectConfigForPersistenceXml(String persistenceUnitName, ParsedPersistenceXmlDescriptor puDescriptor) {
        Properties properties = puDescriptor.getProperties();
        String dialect = puDescriptor.getProperties().getProperty("hibernate.dialect");
        if (!(!"H2".equals(dialect) && !"org.hibernate.dialect.H2Dialect".equals(dialect) || properties.containsKey("jakarta.persistence.database-major-version") || properties.containsKey("jakarta.persistence.database-minor-version") || properties.containsKey("jakarta.persistence.database-product-version"))) {
            Logger.getLogger(HibernateOrmProcessor.class).infof("Persistence unit '%1$s': Enforcing Quarkus defaults for dialect 'org.hibernate.dialect.H2Dialect' by automatically setting '%2$s=%3$s'.", (Object)persistenceUnitName, (Object)"jakarta.persistence.database-product-version", (Object)"2.2.224");
            properties.setProperty("jakarta.persistence.database-product-version", "2.2.224");
        }
    }

    private static Optional<JdbcDataSourceBuildItem> findJdbcDataSource(String persistenceUnitName, HibernateOrmConfigPersistenceUnit persistenceUnitConfig, List<JdbcDataSourceBuildItem> jdbcDataSources) {
        if (persistenceUnitConfig.datasource.isPresent()) {
            String dataSourceName = persistenceUnitConfig.datasource.get();
            return Optional.of(jdbcDataSources.stream().filter(i -> dataSourceName.equals(i.getName())).findFirst().orElseThrow(() -> PersistenceUnitUtil.unableToFindDataSource((String)persistenceUnitName, (String)dataSourceName, (Throwable)DataSourceUtil.dataSourceNotConfigured((String)dataSourceName))));
        }
        if (PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName)) {
            return jdbcDataSources.stream().filter(i -> i.isDefault()).findFirst();
        }
        return Optional.empty();
    }

    private static void setMaxFetchDepth(ParsedPersistenceXmlDescriptor descriptor, OptionalInt maxFetchDepth) {
        descriptor.getProperties().setProperty("hibernate.max_fetch_depth", String.valueOf(maxFetchDepth.getAsInt()));
    }

    private void enhanceEntities(JpaModelBuildItem jpaModel, BuildProducer<BytecodeTransformerBuildItem> transformers, List<io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem> additionalJpaModelBuildItems, List<AdditionalJpaModelBuildItem> deprecatedAdditionalJpaModelBuildItems, BuildProducer<GeneratedClassBuildItem> additionalClasses) {
        HibernateEntityEnhancer hibernateEntityEnhancer = new HibernateEntityEnhancer();
        for (String i : jpaModel.getManagedClassNames()) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(true, i, (BiFunction)hibernateEntityEnhancer, true));
        }
        HashSet<String> additionalClassNames = new HashSet<String>();
        for (io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem additionalJpaModelBuildItem : additionalJpaModelBuildItems) {
            additionalClassNames.add(additionalJpaModelBuildItem.getClassName());
        }
        for (AdditionalJpaModelBuildItem additionalJpaModelBuildItem : deprecatedAdditionalJpaModelBuildItems) {
            additionalClassNames.add(additionalJpaModelBuildItem.getClassName());
        }
        for (String string : additionalClassNames) {
            try {
                byte[] bytes = IoUtil.readClassAsBytes((ClassLoader)HibernateOrmProcessor.class.getClassLoader(), (String)string);
                byte[] enhanced = hibernateEntityEnhancer.enhance(string, bytes);
                additionalClasses.produce((BuildItem)new GeneratedClassBuildItem(false, string, enhanced != null ? enhanced : bytes));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read Model class", e);
            }
        }
    }

    public static Map<String, Set<String>> getModelClassesAndPackagesPerPersistenceUnits(HibernateOrmConfig hibernateOrmConfig, JpaModelBuildItem jpaModel, IndexView index, boolean enableDefaultPersistenceUnit) {
        HashMap<String, Set<String>> modelClassesAndPackagesPerPersistenceUnits = new HashMap<String, Set<String>>();
        boolean hasPackagesInQuarkusConfig = HibernateOrmProcessor.hasPackagesInQuarkusConfig(hibernateOrmConfig);
        Collection<AnnotationInstance> packageLevelPersistenceUnitAnnotations = HibernateOrmProcessor.getPackageLevelPersistenceUnitAnnotations(index);
        HashMap<String, Set> packageRules = new HashMap<String, Set>();
        if (hasPackagesInQuarkusConfig) {
            if (!packageLevelPersistenceUnitAnnotations.isEmpty()) {
                LOG.warn((Object)"Mixing Quarkus configuration and @PersistenceUnit annotations to define the persistence units is not supported. Ignoring the annotations.");
            }
            if (enableDefaultPersistenceUnit) {
                if (!hibernateOrmConfig.defaultPersistenceUnit.packages.isPresent()) {
                    throw new ConfigurationException("Packages must be configured for the default persistence unit.");
                }
                for (String string : hibernateOrmConfig.defaultPersistenceUnit.packages.get()) {
                    packageRules.computeIfAbsent(HibernateOrmProcessor.normalizePackage(string), p -> new HashSet()).add("<default>");
                }
            }
            for (Map.Entry entry : hibernateOrmConfig.persistenceUnits.entrySet()) {
                String candidatePersistenceUnitName = (String)entry.getKey();
                Set<String> candidatePersistenceUnitPackages = ((HibernateOrmConfigPersistenceUnit)entry.getValue()).packages.orElseThrow(() -> new ConfigurationException(String.format(Locale.ROOT, "Packages must be configured for persistence unit '%s'.", candidatePersistenceUnitName)));
                for (String string : candidatePersistenceUnitPackages) {
                    packageRules.computeIfAbsent(HibernateOrmProcessor.normalizePackage(string), p -> new HashSet()).add(candidatePersistenceUnitName);
                }
            }
        } else if (!packageLevelPersistenceUnitAnnotations.isEmpty()) {
            for (AnnotationInstance annotationInstance : packageLevelPersistenceUnitAnnotations) {
                String className = annotationInstance.target().asClass().name().toString();
                String packageName = className == null || className.isEmpty() || className.indexOf(46) == -1 ? "" : HibernateOrmProcessor.normalizePackage(className.substring(0, className.lastIndexOf(46)));
                String persistenceUnitName = annotationInstance.value().asString();
                if (persistenceUnitName == null || persistenceUnitName.isEmpty()) continue;
                packageRules.computeIfAbsent(packageName, p -> new HashSet()).add(persistenceUnitName);
            }
        } else {
            if (!hibernateOrmConfig.persistenceUnits.isEmpty()) {
                throw new ConfigurationException("Multiple persistence units are defined but the entities are not mapped to them. You should either use the .packages Quarkus configuration property or package-level @PersistenceUnit annotations.");
            }
            HashSet<String> allModelClassesAndPackages = new HashSet<String>(jpaModel.getAllModelClassNames());
            allModelClassesAndPackages.addAll(jpaModel.getAllModelPackageNames());
            return Collections.singletonMap("<default>", allModelClassesAndPackages);
        }
        TreeSet<String> modelClassesWithPersistenceUnitAnnotations = new TreeSet<String>();
        for (String modelClassName : jpaModel.getAllModelClassNames()) {
            ClassInfo modelClassInfo = index.getClassByName(DotName.createSimple((String)modelClassName));
            Set<String> relatedModelClassNames = HibernateOrmProcessor.getRelatedModelClassNames(index, jpaModel.getAllModelClassNames(), modelClassInfo);
            if (modelClassInfo != null && (modelClassInfo.declaredAnnotation(ClassNames.QUARKUS_PERSISTENCE_UNIT) != null || modelClassInfo.declaredAnnotation(ClassNames.QUARKUS_PERSISTENCE_UNIT_REPEATABLE_CONTAINER) != null)) {
                modelClassesWithPersistenceUnitAnnotations.add(modelClassInfo.name().toString());
            }
            for (Map.Entry entry : packageRules.entrySet()) {
                if (!modelClassName.startsWith((String)entry.getKey())) continue;
                for (String persistenceUnitName : (Set)entry.getValue()) {
                    modelClassesAndPackagesPerPersistenceUnits.putIfAbsent(persistenceUnitName, new HashSet());
                    ((Set)modelClassesAndPackagesPerPersistenceUnits.get(persistenceUnitName)).add(modelClassName);
                    for (String relatedModelClassName : relatedModelClassNames) {
                        ((Set)modelClassesAndPackagesPerPersistenceUnits.get(persistenceUnitName)).add(relatedModelClassName);
                    }
                }
            }
        }
        if (!modelClassesWithPersistenceUnitAnnotations.isEmpty()) {
            throw new IllegalStateException(String.format(Locale.ROOT, "@PersistenceUnit annotations are not supported at the class level on model classes:\n\t- %s\nUse the `.packages` configuration property or package-level annotations instead.", String.join((CharSequence)"\n\t- ", modelClassesWithPersistenceUnitAnnotations)));
        }
        Set set = modelClassesAndPackagesPerPersistenceUnits.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Set unaffectedModelClasses = jpaModel.getAllModelClassNames().stream().filter(c -> !affectedModelClasses.contains(c)).collect(Collectors.toCollection(TreeSet::new));
        if (!unaffectedModelClasses.isEmpty()) {
            LOG.warnf("Could not find a suitable persistence unit for model classes:\n\t- %s", (Object)String.join((CharSequence)"\n\t- ", unaffectedModelClasses));
        }
        for (String modelPackageName : jpaModel.getAllModelPackageNames()) {
            Set set2 = (Set)packageRules.get(HibernateOrmProcessor.normalizePackage(modelPackageName));
            if (set2 == null) continue;
            for (String persistenceUnitName : set2) {
                modelClassesAndPackagesPerPersistenceUnits.putIfAbsent(persistenceUnitName, new HashSet());
                ((Set)modelClassesAndPackagesPerPersistenceUnits.get(persistenceUnitName)).add(modelPackageName);
            }
        }
        return modelClassesAndPackagesPerPersistenceUnits;
    }

    private static Set<String> getRelatedModelClassNames(IndexView index, Set<String> knownModelClassNames, ClassInfo modelClassInfo) {
        if (modelClassInfo == null) {
            return Collections.emptySet();
        }
        HashSet<String> relatedModelClassNames = new HashSet<String>();
        if (modelClassInfo.declaredAnnotation(ClassNames.JPA_ENTITY) == null && modelClassInfo.declaredAnnotation(ClassNames.MAPPED_SUPERCLASS) == null) {
            return Collections.emptySet();
        }
        modelClassInfo = index.getClassByName(modelClassInfo.superName());
        while (modelClassInfo != null && !modelClassInfo.name().equals((Object)DotNames.OBJECT)) {
            String modelSuperClassName = modelClassInfo.name().toString();
            if (knownModelClassNames.contains(modelSuperClassName)) {
                relatedModelClassNames.add(modelSuperClassName);
            }
            modelClassInfo = index.getClassByName(modelClassInfo.superName());
        }
        return relatedModelClassNames;
    }

    private static String normalizePackage(String pakkage) {
        if (pakkage.endsWith(".")) {
            return pakkage;
        }
        return pakkage + ".";
    }

    private static boolean hasPackagesInQuarkusConfig(HibernateOrmConfig hibernateOrmConfig) {
        for (HibernateOrmConfigPersistenceUnit persistenceUnitConfig : hibernateOrmConfig.getAllPersistenceUnitConfigsAsMap().values()) {
            if (!persistenceUnitConfig.packages.isPresent()) continue;
            return true;
        }
        return false;
    }

    private static Collection<AnnotationInstance> getPackageLevelPersistenceUnitAnnotations(IndexView index) {
        Collection persistenceUnitAnnotations = index.getAnnotationsWithRepeatable(ClassNames.QUARKUS_PERSISTENCE_UNIT, index);
        ArrayList<AnnotationInstance> packageLevelPersistenceUnitAnnotations = new ArrayList<AnnotationInstance>();
        for (AnnotationInstance persistenceUnitAnnotation : persistenceUnitAnnotations) {
            if (persistenceUnitAnnotation.target().kind() != AnnotationTarget.Kind.CLASS || !"package-info".equals(persistenceUnitAnnotation.target().asClass().simpleName())) continue;
            packageLevelPersistenceUnitAnnotations.add(persistenceUnitAnnotation);
        }
        return packageLevelPersistenceUnitAnnotations;
    }

    private boolean shouldIgnorePersistenceXmlResources(HibernateOrmConfig config) {
        return config.persistenceXml.ignore || Boolean.getBoolean("SKIP_PARSE_PERSISTENCE_XML");
    }

    public static QuarkusScanner buildQuarkusScanner(JpaModelBuildItem jpaModel) {
        QuarkusScanner scanner = new QuarkusScanner();
        HashSet<QuarkusScanner.PackageDescriptorImpl> packageDescriptors = new HashSet<QuarkusScanner.PackageDescriptorImpl>();
        for (String packageName : jpaModel.getAllModelPackageNames()) {
            QuarkusScanner.PackageDescriptorImpl desc = new QuarkusScanner.PackageDescriptorImpl(packageName);
            packageDescriptors.add(desc);
        }
        scanner.setPackageDescriptors(packageDescriptors);
        HashSet<QuarkusScanner.ClassDescriptorImpl> classDescriptors = new HashSet<QuarkusScanner.ClassDescriptorImpl>();
        for (String className : jpaModel.getEntityClassNames()) {
            QuarkusScanner.ClassDescriptorImpl desc = new QuarkusScanner.ClassDescriptorImpl(className, ClassDescriptor.Categorization.MODEL);
            classDescriptors.add(desc);
        }
        scanner.setClassDescriptors(classDescriptors);
        return scanner;
    }

    private static MultiTenancyStrategy getMultiTenancyStrategy(Optional<String> multitenancyStrategy) {
        MultiTenancyStrategy multiTenancyStrategy = MultiTenancyStrategy.valueOf((String)multitenancyStrategy.orElse(MultiTenancyStrategy.NONE.name()).toUpperCase(Locale.ROOT));
        return multiTenancyStrategy;
    }

    private PreGeneratedProxies generatedProxies(Set<String> managedClassAndPackageNames, IndexView combinedIndex, TransformedClassesBuildItem transformedClassesBuildItem, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, LiveReloadBuildItem liveReloadBuildItem) {
        ProxyCache proxyCache = (ProxyCache)liveReloadBuildItem.getContextObject(ProxyCache.class);
        if (proxyCache == null) {
            proxyCache = new ProxyCache();
            liveReloadBuildItem.setContextObject(ProxyCache.class, (Object)proxyCache);
        }
        Set changedClasses = Collections.emptySet();
        if (liveReloadBuildItem.getChangeInformation() != null) {
            changedClasses = liveReloadBuildItem.getChangeInformation().getChangedClasses();
        } else {
            proxyCache.cache.clear();
        }
        PreGeneratedProxies preGeneratedProxies = new PreGeneratedProxies();
        HashMap<String, String> proxyAnnotations = new HashMap<String, String>();
        for (AnnotationInstance i : combinedIndex.getAnnotations(ClassNames.PROXY)) {
            AnnotationValue proxyClass = i.value("proxyClass");
            if (proxyClass == null) continue;
            proxyAnnotations.put(i.target().asClass().name().toString(), proxyClass.asClass().name().toString());
        }
        TypePool transformedClassesTypePool = this.createTransformedClassesTypePool(transformedClassesBuildItem, managedClassAndPackageNames);
        try (ProxyBuildingHelper proxyHelper = new ProxyBuildingHelper(transformedClassesTypePool);){
            for (String managedClassOrPackageName : managedClassAndPackageNames) {
                CachedProxy result;
                if (proxyCache.cache.containsKey(managedClassOrPackageName) && !this.isModified(managedClassOrPackageName, changedClasses, combinedIndex)) {
                    result = proxyCache.cache.get(managedClassOrPackageName);
                } else {
                    TreeSet<String> proxyInterfaceNames = new TreeSet<String>();
                    proxyInterfaceNames.add(ClassNames.HIBERNATE_PROXY.toString());
                    String proxy = (String)proxyAnnotations.get(managedClassOrPackageName);
                    if (proxy == null) {
                        if (!proxyHelper.isProxiable(managedClassOrPackageName)) {
                            continue;
                        }
                    } else {
                        proxyInterfaceNames.add(proxy);
                    }
                    String mappedClass = managedClassOrPackageName;
                    for (ClassInfo subclass : combinedIndex.getAllKnownSubclasses(DotName.createSimple((String)managedClassOrPackageName))) {
                        String subclassName = subclass.name().toString();
                        if (!managedClassAndPackageNames.contains(subclassName) || (proxy = (String)proxyAnnotations.get(subclassName)) == null) continue;
                        proxyInterfaceNames.add(proxy);
                    }
                    DynamicType.Unloaded<?> unloaded = proxyHelper.buildUnloadedProxy(mappedClass, proxyInterfaceNames);
                    result = new CachedProxy(unloaded, proxyInterfaceNames);
                    proxyCache.cache.put(managedClassOrPackageName, result);
                }
                for (Map.Entry i : result.proxyDef.getAllTypes().entrySet()) {
                    generatedClassBuildItemBuildProducer.produce((BuildItem)new GeneratedClassBuildItem(true, ((TypeDescription)i.getKey()).getName(), (byte[])i.getValue()));
                }
                preGeneratedProxies.getProxies().put(managedClassOrPackageName, new PreGeneratedProxies.ProxyClassDetailsHolder(result.proxyDef.getTypeDescription().getName(), result.interfaces));
            }
        }
        return preGeneratedProxies;
    }

    private TypePool createTransformedClassesTypePool(TransformedClassesBuildItem transformedClassesBuildItem, Set<String> entityClasses) {
        HashMap<String, byte[]> transformedClasses = new HashMap<String, byte[]>();
        for (Set transformedClassSet : transformedClassesBuildItem.getTransformedClassesByJar().values()) {
            for (TransformedClassesBuildItem.TransformedClass transformedClass : transformedClassSet) {
                String className = transformedClass.getClassName();
                if (!entityClasses.contains(className)) continue;
                transformedClasses.put(className, transformedClass.getData());
            }
        }
        return TypePool.Default.of((ClassFileLocator)new ClassFileLocator.Compound(new ClassFileLocator[]{new ClassFileLocator.Simple(transformedClasses), ClassFileLocator.ForClassLoader.of((ClassLoader)Thread.currentThread().getContextClassLoader())}));
    }

    private boolean isModified(String entity, Set<String> changedClasses, IndexView index) {
        if (changedClasses.contains(entity)) {
            return true;
        }
        ClassInfo clazz = index.getClassByName(DotName.createSimple((String)entity));
        if (clazz == null) {
            return false;
        }
        for (DotName i : clazz.interfaceNames()) {
            if (!this.isModified(i.toString(), changedClasses, index)) continue;
            return true;
        }
        DotName superName = clazz.superName();
        if (superName != null) {
            return this.isModified(superName.toString(), changedClasses, index);
        }
        return false;
    }

    private static Class[] toArray(Set<Class<?>> interfaces) {
        if (interfaces == null) {
            return ArrayHelper.EMPTY_CLASS_ARRAY;
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    private static boolean isMySQLOrMariaDB(String dialect) {
        String lowercaseDialect = dialect.toLowerCase(Locale.ROOT);
        return lowercaseDialect.contains("mysql") || lowercaseDialect.contains("mariadb");
    }

    private static final class ProxyCache {
        Map<String, CachedProxy> cache = new HashMap<String, CachedProxy>();

        private ProxyCache() {
        }
    }

    static final class CachedProxy {
        final DynamicType.Unloaded<?> proxyDef;
        final Set<String> interfaces;

        CachedProxy(DynamicType.Unloaded<?> proxyDef, Set<String> interfaces) {
            this.proxyDef = proxyDef;
            this.interfaces = interfaces;
        }
    }
}

