/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.hibernate.orm.deployment.ClassNames;
import java.util.List;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.pool.TypePool;
import org.hibernate.bytecode.internal.bytebuddy.BytecodeProviderImpl;
import org.hibernate.proxy.pojo.bytebuddy.ByteBuddyProxyHelper;
import org.jboss.jandex.ClassInfo;

final class ProxyBuildingHelper
implements AutoCloseable {
    private final TypePool typePool;
    private final List<TypeDefinition> interfaces;
    private ByteBuddyProxyHelper byteBuddyProxyHelper;
    private BytecodeProviderImpl bytecodeProvider;

    public ProxyBuildingHelper(TypePool typePool) {
        this.typePool = typePool;
        this.interfaces = List.of(typePool.describe(ClassNames.HIBERNATE_PROXY.toString()).resolve());
    }

    public DynamicType.Unloaded<?> buildUnloadedProxy(String mappedClassName) {
        return this.getByteBuddyProxyHelper().buildUnloadedProxy(this.typePool, (TypeDefinition)this.typePool.describe(mappedClassName).resolve(), this.interfaces);
    }

    private ByteBuddyProxyHelper getByteBuddyProxyHelper() {
        if (this.byteBuddyProxyHelper == null) {
            this.bytecodeProvider = new BytecodeProviderImpl(ClassFileVersion.JAVA_V11);
            this.byteBuddyProxyHelper = this.bytecodeProvider.getByteBuddyProxyHelper();
        }
        return this.byteBuddyProxyHelper;
    }

    public boolean isProxiable(ClassInfo classInfo) {
        return classInfo != null && !classInfo.isInterface() && !classInfo.isAbstract() && !classInfo.isFinal() && classInfo.hasNoArgsConstructor();
    }

    @Override
    public void close() {
        if (this.bytecodeProvider != null) {
            this.bytecodeProvider.resetCaches();
            this.bytecodeProvider = null;
            this.byteBuddyProxyHelper = null;
        }
    }
}

