/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment.util;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateConfigUtil;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfigPersistenceUnit;
import io.quarkus.hibernate.orm.deployment.JpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.spi.DatabaseKindDialectBuildItem;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDescriptor;
import io.quarkus.hibernate.orm.runtime.customized.BuiltinFormatMapperBehaviour;
import io.quarkus.hibernate.orm.runtime.customized.FormatMapperKind;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.hibernate.id.SequenceMismatchStrategy;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.jboss.logging.Logger;

public final class HibernateProcessorUtil {
    private static final Logger LOG = Logger.getLogger(HibernateProcessorUtil.class);
    public static final String NO_SQL_LOAD_SCRIPT_FILE = "no-file";

    private HibernateProcessorUtil() {
    }

    public static boolean hasEntities(JpaModelBuildItem jpaModel) {
        return !jpaModel.getEntityClassNames().isEmpty();
    }

    public static Optional<FormatMapperKind> jsonMapperKind(Capabilities capabilities, BuiltinFormatMapperBehaviour behaviour) {
        if (BuiltinFormatMapperBehaviour.IGNORE.equals((Object)behaviour)) {
            return Optional.empty();
        }
        if (capabilities.isPresent("io.quarkus.jackson")) {
            return Optional.of(FormatMapperKind.JACKSON);
        }
        if (capabilities.isPresent("io.quarkus.jsonb")) {
            return Optional.of(FormatMapperKind.JSONB);
        }
        return Optional.empty();
    }

    public static Optional<FormatMapperKind> xmlMapperKind(Capabilities capabilities, BuiltinFormatMapperBehaviour behaviour) {
        if (BuiltinFormatMapperBehaviour.IGNORE.equals((Object)behaviour)) {
            return Optional.empty();
        }
        return capabilities.isPresent("io.quarkus.jaxb") ? Optional.of(FormatMapperKind.JAXB) : Optional.empty();
    }

    public static boolean isHibernateValidatorPresent(Capabilities capabilities) {
        return capabilities.isPresent("io.quarkus.hibernate.validator");
    }

    public static void setDialectAndStorageEngine(String persistenceUnitName, Optional<String> dbKind, Optional<String> explicitDialect, Optional<String> explicitDbMinVersion, List<DatabaseKindDialectBuildItem> dbKindDialectBuildItems, Optional<String> storageEngine, BuildProducer<SystemPropertyBuildItem> systemProperties, BiConsumer<String, String> puPropertiesCollector, Set<String> storageEngineCollector) {
        Optional dialect = explicitDialect;
        Optional dbProductName = Optional.empty();
        Optional dbProductVersion = explicitDbMinVersion;
        if (dbKind.isPresent() || explicitDialect.isPresent()) {
            for (DatabaseKindDialectBuildItem item : dbKindDialectBuildItems) {
                if ((!dbKind.isPresent() || !DatabaseKind.is((String)dbKind.get(), (String)item.getDbKind())) && (!explicitDialect.isPresent() || !item.getMatchingDialects().contains(explicitDialect.get()))) continue;
                dbProductName = item.getDatabaseProductName();
                if (dbProductName.isEmpty() && explicitDialect.isEmpty()) {
                    dialect = item.getDialectOptional();
                }
                if (!explicitDbMinVersion.isEmpty()) break;
                dbProductVersion = item.getDefaultDatabaseProductVersion();
                break;
            }
            if (dialect.isEmpty() && dbProductName.isEmpty()) {
                throw new ConfigurationException("Could not guess the dialect from the database kind '" + dbKind.get() + "'. Add an explicit '" + HibernateOrmRuntimeConfig.puPropertyKey((String)persistenceUnitName, (String)"dialect") + "' property.");
            }
        }
        if (dialect.isPresent()) {
            puPropertiesCollector.accept("hibernate.dialect", dialect.get());
        } else if (dbProductName.isPresent()) {
            puPropertiesCollector.accept("jakarta.persistence.database-product-name", (String)dbProductName.get());
        }
        if (storageEngine.isPresent()) {
            if (HibernateProcessorUtil.isMySQLOrMariaDB(dbKind, dialect)) {
                storageEngineCollector.add(storageEngine.get());
                systemProperties.produce((BuildItem)new SystemPropertyBuildItem("hibernate.dialect.storage_engine", storageEngine.get()));
            } else {
                LOG.warnf("The storage engine configuration is being ignored because the database is neither MySQL nor MariaDB.", new Object[0]);
            }
        }
        if (dbProductVersion.isPresent()) {
            puPropertiesCollector.accept("jakarta.persistence.database-product-version", dbProductVersion.get());
        }
    }

    public static void configureProperties(QuarkusPersistenceUnitDescriptor desc, HibernateOrmConfigPersistenceUnit config, HibernateOrmConfig hibernateOrmConfig, boolean reactive) {
        HibernateProcessorUtil.configureQuoting(desc, config);
        config.physicalNamingStrategy().ifPresent(namingStrategy -> desc.getProperties().setProperty("hibernate.physical_naming_strategy", (String)namingStrategy));
        config.implicitNamingStrategy().ifPresent(namingStrategy -> desc.getProperties().setProperty("hibernate.implicit_naming_strategy", (String)namingStrategy));
        config.metadataBuilderContributor().ifPresent(className -> desc.getProperties().setProperty("hibernate.metadata_builder_contributor", (String)className));
        if (config.mapping().timezone().timeZoneDefaultStorage().isPresent()) {
            desc.getProperties().setProperty("hibernate.timezone.default_storage", config.mapping().timezone().timeZoneDefaultStorage().get().name());
        }
        desc.getProperties().setProperty("hibernate.id.optimizer.pooled.preferred", config.mapping().id().optimizer().idOptimizerDefault().orElse((HibernateOrmConfigPersistenceUnit.IdOptimizerType)HibernateOrmConfigPersistenceUnit.IdOptimizerType.POOLED_LO).configName);
        desc.getProperties().setProperty("hibernate.hbm2ddl.charset_name", config.database().charset().name());
        int batchSize = HibernateConfigUtil.firstPresent(config.fetch().batchSize(), config.batchFetchSize()).orElse(HibernateProcessorUtil.defaultBatchSize(reactive));
        if (batchSize > 0) {
            desc.getProperties().setProperty("hibernate.default_batch_fetch_size", Integer.toString(batchSize));
        }
        if (config.fetch().maxDepth().isPresent()) {
            HibernateProcessorUtil.setMaxFetchDepth((PersistenceUnitDescriptor)desc, config.fetch().maxDepth());
        } else if (config.maxFetchDepth().isPresent()) {
            HibernateProcessorUtil.setMaxFetchDepth((PersistenceUnitDescriptor)desc, config.maxFetchDepth());
        }
        desc.getProperties().setProperty("hibernate.query.plan_cache_max_size", Integer.toString(config.query().queryPlanCacheMaxSize()));
        desc.getProperties().setProperty("hibernate.order_by.default_null_ordering", config.query().defaultNullOrdering().name().toLowerCase(Locale.ROOT));
        desc.getProperties().setProperty("hibernate.query.in_clause_parameter_padding", String.valueOf(config.query().inClauseParameterPadding()));
        desc.getProperties().setProperty("hibernate.query.fail_on_pagination_over_collection_fetch", String.valueOf(config.query().failOnPaginationOverCollectionFetch()));
        desc.getProperties().put("hibernate.id.sequence.increment_size_mismatch_strategy", SequenceMismatchStrategy.NONE);
        config.jdbc().timezone().ifPresent(timezone -> desc.getProperties().setProperty("hibernate.jdbc.time_zone", (String)timezone));
        config.jdbc().statementFetchSize().ifPresent(fetchSize -> desc.getProperties().setProperty("hibernate.jdbc.fetch_size", String.valueOf(fetchSize)));
        config.jdbc().statementBatchSize().ifPresent(fetchSize -> desc.getProperties().setProperty("hibernate.jdbc.batch_size", String.valueOf(fetchSize)));
        if (hibernateOrmConfig.metrics().enabled() || hibernateOrmConfig.statistics().isPresent() && hibernateOrmConfig.statistics().get().booleanValue()) {
            desc.getProperties().setProperty("hibernate.generate_statistics", "true");
            desc.getProperties().setProperty("hibernate.session.events.log", String.valueOf(hibernateOrmConfig.logSessionMetrics().orElse(false)));
        }
        HibernateProcessorUtil.configureCaching(desc, config);
        HibernateProcessorUtil.configureValidation(desc, config);
        desc.getProperties().setProperty("hibernate.discriminator.ignore_explicit_for_joined", String.valueOf(config.discriminator().ignoreExplicitForJoined()));
    }

    private static int defaultBatchSize(boolean reactive) {
        return reactive ? -1 : 16;
    }

    private static void setMaxFetchDepth(PersistenceUnitDescriptor descriptor, OptionalInt maxFetchDepth) {
        descriptor.getProperties().setProperty("hibernate.max_fetch_depth", String.valueOf(maxFetchDepth.getAsInt()));
    }

    private static List<String> getSqlLoadScript(Optional<List<String>> sqlLoadScript, LaunchMode launchMode) {
        if (sqlLoadScript.isPresent()) {
            return sqlLoadScript.get().stream().filter(s -> !NO_SQL_LOAD_SCRIPT_FILE.equalsIgnoreCase((String)s)).collect(Collectors.toList());
        }
        if (launchMode == LaunchMode.NORMAL) {
            return Collections.emptyList();
        }
        return List.of("import.sql");
    }

    private static boolean isMySQLOrMariaDB(Optional<String> dbKind, Optional<String> dialect) {
        if (dbKind.isPresent() && (DatabaseKind.isMySQL((String)dbKind.get()) || DatabaseKind.isMariaDB((String)dbKind.get()))) {
            return true;
        }
        if (dialect.isPresent()) {
            String lowercaseDialect = dialect.get().toLowerCase(Locale.ROOT);
            return lowercaseDialect.contains("mysql") || lowercaseDialect.contains("mariadb");
        }
        return false;
    }

    private static void configureCaching(QuarkusPersistenceUnitDescriptor descriptor, HibernateOrmConfigPersistenceUnit config) {
        if (config.secondLevelCachingEnabled()) {
            Properties p = descriptor.getProperties();
            p.putIfAbsent("hibernate.cache.use_reference_entries", Boolean.TRUE);
            p.putIfAbsent("hibernate.cache.use_second_level_cache", Boolean.TRUE);
            p.putIfAbsent("hibernate.cache.use_query_cache", Boolean.TRUE);
            p.putIfAbsent("jakarta.persistence.sharedCache.mode", SharedCacheMode.ENABLE_SELECTIVE);
            Map<String, String> cacheConfigEntries = HibernateConfigUtil.getCacheConfigEntries(config);
            for (Map.Entry<String, String> entry : cacheConfigEntries.entrySet()) {
                descriptor.getProperties().setProperty(entry.getKey(), entry.getValue());
            }
        } else {
            Properties p = descriptor.getProperties();
            p.put("hibernate.cache.use_reference_entries", Boolean.FALSE);
            p.put("hibernate.cache.use_second_level_cache", Boolean.FALSE);
            p.put("hibernate.cache.use_query_cache", Boolean.FALSE);
            p.put("jakarta.persistence.sharedCache.mode", SharedCacheMode.NONE);
        }
    }

    private static void configureValidation(QuarkusPersistenceUnitDescriptor descriptor, HibernateOrmConfigPersistenceUnit config) {
        if (!config.validation().enabled()) {
            descriptor.getProperties().setProperty("jakarta.persistence.validation.mode", ValidationMode.NONE.name());
        } else {
            descriptor.getProperties().setProperty("jakarta.persistence.validation.mode", config.validation().mode().stream().map(Enum::name).collect(Collectors.joining(",")));
        }
    }

    private static void configureQuoting(QuarkusPersistenceUnitDescriptor desc, HibernateOrmConfigPersistenceUnit persistenceUnitConfig) {
        if (persistenceUnitConfig.quoteIdentifiers().strategy() == HibernateOrmConfigPersistenceUnit.IdentifierQuotingStrategy.ALL || persistenceUnitConfig.quoteIdentifiers().strategy() == HibernateOrmConfigPersistenceUnit.IdentifierQuotingStrategy.ALL_EXCEPT_COLUMN_DEFINITIONS || persistenceUnitConfig.database().globallyQuotedIdentifiers()) {
            desc.getProperties().setProperty("hibernate.globally_quoted_identifiers", "true");
        }
        if (persistenceUnitConfig.quoteIdentifiers().strategy() == HibernateOrmConfigPersistenceUnit.IdentifierQuotingStrategy.ALL_EXCEPT_COLUMN_DEFINITIONS) {
            desc.getProperties().setProperty("hibernate.globally_quoted_identifiers_skip_column_definitions", "true");
        } else if (persistenceUnitConfig.quoteIdentifiers().strategy() == HibernateOrmConfigPersistenceUnit.IdentifierQuotingStrategy.ONLY_KEYWORDS) {
            desc.getProperties().setProperty("hibernate.auto_quote_keyword", "true");
        }
    }

    public static void configureSqlLoadScript(String persistenceUnitName, HibernateOrmConfigPersistenceUnit persistenceUnitConfig, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchMode launchMode, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, QuarkusPersistenceUnitDescriptor descriptor) {
        List<String> importFiles = HibernateProcessorUtil.getSqlLoadScript(persistenceUnitConfig.sqlLoadScript(), launchMode);
        if (!importFiles.isEmpty()) {
            for (String importFile : importFiles) {
                Path loadScriptPath;
                try {
                    loadScriptPath = applicationArchivesBuildItem.getRootArchive().getChildPath(importFile);
                }
                catch (RuntimeException e) {
                    throw new ConfigurationException("Unable to interpret path referenced in '" + HibernateOrmRuntimeConfig.puPropertyKey((String)persistenceUnitName, (String)"sql-load-script") + "=" + String.join((CharSequence)",", (Iterable<? extends CharSequence>)persistenceUnitConfig.sqlLoadScript().get()) + "': " + e.getMessage());
                }
                if (loadScriptPath != null && !Files.isDirectory(loadScriptPath, new LinkOption[0])) {
                    nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{importFile}));
                } else if (persistenceUnitConfig.sqlLoadScript().isPresent()) {
                    throw new ConfigurationException("Unable to find file referenced in '" + HibernateOrmRuntimeConfig.puPropertyKey((String)persistenceUnitName, (String)"sql-load-script") + "=" + String.join((CharSequence)",", (Iterable<? extends CharSequence>)persistenceUnitConfig.sqlLoadScript().get()) + "'. Remove property or add file to your path.");
                }
                hotDeploymentWatchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(importFile));
            }
            if (persistenceUnitConfig.sqlLoadScript().isPresent()) {
                descriptor.getProperties().setProperty("hibernate.hbm2ddl.import_files", String.join((CharSequence)",", importFiles));
            }
        } else {
            descriptor.getProperties().setProperty("hibernate.hbm2ddl.import_files", "");
            descriptor.getProperties().setProperty("hibernate.hbm2ddl.skip_default_import_file", "true");
        }
    }
}

