/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment.dev;

import io.quarkus.agroal.spi.JdbcDataSourceSchemaReadyBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.DevServicesAdditionalConfigBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfigPersistenceUnit;
import io.quarkus.hibernate.orm.deployment.HibernateOrmEnabled;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={HibernateOrmEnabled.class}, onlyIfNot={IsNormal.class})
public class HibernateOrmDevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(HibernateOrmDevServicesProcessor.class);

    @BuildStep
    void devServicesAutoGenerateByDefault(List<JdbcDataSourceSchemaReadyBuildItem> schemaReadyBuildItems, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, HibernateOrmConfig config, BuildProducer<DevServicesAdditionalConfigBuildItem> devServicesAdditionalConfigProducer) {
        Set managedSources = schemaReadyBuildItems.stream().map(JdbcDataSourceSchemaReadyBuildItem::getDatasourceNames).collect(HashSet::new, Collection::addAll, Collection::addAll);
        for (Map.Entry<String, HibernateOrmConfigPersistenceUnit> entry : config.persistenceUnits().entrySet()) {
            Optional<String> dataSourceName = entry.getValue().datasource();
            List propertyKeysIndicatingDataSourceConfigured = DataSourceUtil.dataSourcePropertyKeys((String)dataSourceName.orElse(null), (String)"username");
            if (managedSources.contains(dataSourceName.orElse("<default>"))) continue;
            String schemaManagementStrategyPropertyKey = HibernateOrmRuntimeConfig.puPropertyKey((String)entry.getKey(), (String)"schema-management.strategy");
            String legacyDatabaseGenerationPropertyKey = HibernateOrmRuntimeConfig.puPropertyKey((String)entry.getKey(), (String)"database.generation");
            if (ConfigUtils.isAnyPropertyPresent((Collection)propertyKeysIndicatingDataSourceConfigured) || ConfigUtils.isPropertyNonEmpty((String)schemaManagementStrategyPropertyKey) || ConfigUtils.isPropertyNonEmpty((String)legacyDatabaseGenerationPropertyKey)) continue;
            devServicesAdditionalConfigProducer.produce((BuildItem)new DevServicesAdditionalConfigBuildItem(devServicesConfig -> {
                if (propertyKeysIndicatingDataSourceConfigured.stream().anyMatch(devServicesConfig::containsKey)) {
                    String forcedValue = "drop-and-create";
                    LOG.infof("Setting %s=%s to initialize Dev Services managed database", (Object)schemaManagementStrategyPropertyKey, (Object)forcedValue);
                    return Map.of(schemaManagementStrategyPropertyKey, forcedValue);
                }
                return Map.of();
            }));
        }
    }
}

