/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.grpc.deployment.GrpcDotNames;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jboss.jandex.DotName;

public final class GrpcClientBuildItem
extends MultiBuildItem {
    private final String clientName;
    private final Set<ClientInfo> clients;

    public GrpcClientBuildItem(String name) {
        this.clientName = name;
        this.clients = new HashSet<ClientInfo>();
    }

    public Set<ClientInfo> getClients() {
        return this.clients;
    }

    public void addClient(ClientInfo client) {
        this.addClient(client, false);
    }

    public void addClient(ClientInfo client, boolean addChannel) {
        this.clients.add(client);
        if (addChannel) {
            this.clients.add(new ClientInfo(GrpcDotNames.CHANNEL, ClientType.CHANNEL, client.interceptors));
        }
    }

    public String getClientName() {
        return this.clientName;
    }

    public static final class ClientInfo {
        public final DotName className;
        public final ClientType type;
        public final DotName implName;
        public final Set<String> interceptors;

        public ClientInfo(DotName className, ClientType type, Set<String> interceptors) {
            this(className, type, null, interceptors);
        }

        public ClientInfo(DotName className, ClientType type, DotName implName, Set<String> interceptors) {
            this.className = className;
            this.type = type;
            this.implName = implName;
            this.interceptors = interceptors;
        }

        public int hashCode() {
            return Objects.hash(this.className, this.interceptors);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClientInfo other = (ClientInfo)obj;
            return Objects.equals(this.className, other.className) && Objects.equals(this.interceptors, other.interceptors);
        }
    }

    public static enum ClientType {
        CHANNEL(null, false),
        BLOCKING_STUB("newBlockingStub", true),
        MUTINY_STUB("newMutinyStub", false),
        MUTINY_CLIENT(null, false);

        private final String factoryMethodName;
        private boolean blocking;

        private ClientType(String factoryMethodName, boolean blocking) {
            this.factoryMethodName = factoryMethodName;
            this.blocking = blocking;
        }

        public String getFactoryMethodName() {
            return this.factoryMethodName;
        }

        public boolean isBlocking() {
            return this.blocking;
        }
    }
}

