/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.vertx.core.http.impl.VertxHttpResponse;

class AssembledHttpResponse
extends VertxHttpResponse
implements HttpContent {
    private final ByteBuf content;

    AssembledHttpResponse(boolean head, HttpVersion version, HttpResponseStatus status, HttpHeaders headers) {
        this(head, version, status, headers, Unpooled.EMPTY_BUFFER);
    }

    AssembledHttpResponse(boolean head, HttpVersion version, HttpResponseStatus status, HttpHeaders headers, ByteBuf content) {
        super(head, version, status, headers);
        this.content = content;
    }

    @Override
    public HttpContent copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpContent duplicate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpContent retainedDuplicate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpContent replace(ByteBuf content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AssembledHttpResponse retain() {
        this.content.retain();
        return this;
    }

    @Override
    public AssembledHttpResponse retain(int increment) {
        this.content.retain(increment);
        return this;
    }

    @Override
    public AssembledHttpResponse setStatus(HttpResponseStatus status) {
        return (AssembledHttpResponse)super.setStatus(status);
    }

    @Override
    public AssembledHttpResponse setProtocolVersion(HttpVersion version) {
        return (AssembledHttpResponse)super.setProtocolVersion(version);
    }

    @Override
    public AssembledHttpResponse touch() {
        this.content.touch();
        return this;
    }

    @Override
    public AssembledHttpResponse touch(Object hint) {
        this.content.touch(hint);
        return this;
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public boolean release() {
        return this.content.release();
    }

    @Override
    public boolean release(int decrement) {
        return this.content.release(decrement);
    }
}

